/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import com.google.auto.value.processor.AbstractMethodExtractor;
import com.google.auto.value.processor.AbstractMethodLister;
import com.google.auto.value.processor.AutoValueProcessor;
import com.google.auto.value.processor.JavaTokenizer;
import com.google.auto.value.processor.TypeSimplifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

class EclipseHack {
    static final String ENABLING_OPTION = "com.google.auto.value.EclipseHackTest";
    private final ProcessingEnvironment processingEnv;
    private final boolean eclipseHackTest;
    private static final Comparator<ExecutableElement> ELEMENT_COMPARATOR = new Comparator<ExecutableElement>(){

        @Override
        public int compare(ExecutableElement a, ExecutableElement b) {
            return a.getSimpleName().toString().compareTo(b.getSimpleName().toString());
        }
    };

    EclipseHack(ProcessingEnvironment processingEnv) {
        boolean eclipseHackTest = processingEnv.getOptions().containsKey(ENABLING_OPTION);
        this.processingEnv = eclipseHackTest ? new EclipseProcessingEnvironment(processingEnv) : processingEnv;
        this.eclipseHackTest = eclipseHackTest;
    }

    void sortMethodsIfSimulatingEclipse(List<ExecutableElement> methods) {
        if (this.eclipseHackTest) {
            Collections.sort(methods, ELEMENT_COMPARATOR);
        }
    }

    void reorderProperties(List<AutoValueProcessor.Property> properties) {
        int index = 0;
        while (index < properties.size()) {
            int nextIndex;
            TypeElement owner = properties.get(index).owner();
            for (nextIndex = index + 1; nextIndex < properties.size() && properties.get(nextIndex).owner().equals(owner); ++nextIndex) {
            }
            List<AutoValueProcessor.Property> subList = properties.subList(index, nextIndex);
            this.reorderProperties(owner, subList);
            index = nextIndex;
        }
    }

    private void reorderProperties(TypeElement type, List<AutoValueProcessor.Property> properties) {
        List<String> order;
        PropertyOrderer propertyOrderer = this.getPropertyOrderer(type);
        if (propertyOrderer == null) {
            return;
        }
        try {
            order = propertyOrderer.determinePropertyOrder();
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, e.toString());
            return;
        }
        boolean allFound = true;
        for (AutoValueProcessor.Property property : properties) {
            allFound &= order.contains(property.toString());
        }
        if (allFound) {
            Comparator<AutoValueProcessor.Property> comparator = new Comparator<AutoValueProcessor.Property>(){

                @Override
                public int compare(AutoValueProcessor.Property a, AutoValueProcessor.Property b) {
                    String aName = a.toString();
                    String bName = b.toString();
                    return order.indexOf(aName) - order.indexOf(bName);
                }
            };
            Collections.sort(properties, comparator);
        }
    }

    private PropertyOrderer getPropertyOrderer(TypeElement type) {
        try {
            Method getEnclosingIFile = this.processingEnv.getClass().getMethod("getEnclosingIFile", Element.class);
            final Object iFile = getEnclosingIFile.invoke((Object)this.processingEnv, type);
            URI uri = (URI)iFile.getClass().getMethod("getRawLocationURI", new Class[0]).invoke(iFile, new Object[0]);
            if (uri.getPath().endsWith(".class")) {
                return new BinaryPropertyOrderer(uri);
            }
            Method getCharset = iFile.getClass().getMethod("getCharset", new Class[0]);
            final String charset = (String)getCharset.invoke(iFile, new Object[0]);
            final Method getContents = iFile.getClass().getMethod("getContents", new Class[0]);
            Callable<Reader> readerProvider = new Callable<Reader>(){

                @Override
                public Reader call() throws Exception {
                    InputStream inputStream = (InputStream)getContents.invoke(iFile, new Object[0]);
                    return new InputStreamReader(inputStream, charset);
                }
            };
            return new SourcePropertyOrderer(type, readerProvider);
        }
        catch (Exception e) {
            return null;
        }
    }

    private class BinaryPropertyOrderer
    implements PropertyOrderer {
        private final URI classFileUri;

        BinaryPropertyOrderer(URI classFileUri) {
            this.classFileUri = classFileUri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> determinePropertyOrder() throws IOException {
            InputStream inputStream = null;
            try {
                URL classFileUrl = this.classFileUri.toURL();
                inputStream = classFileUrl.openStream();
                AbstractMethodLister lister = new AbstractMethodLister(inputStream);
                List<String> list = lister.abstractNoArgMethods();
                return list;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    private class SourcePropertyOrderer
    implements PropertyOrderer {
        private final TypeElement type;
        private final Callable<Reader> readerProvider;

        SourcePropertyOrderer(TypeElement type, Callable<Reader> readerProvider) {
            this.type = type;
            this.readerProvider = readerProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> determinePropertyOrder() throws IOException {
            Reader sourceReader;
            try {
                sourceReader = this.readerProvider.call();
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
            try {
                String packageName = TypeSimplifier.packageNameOf(this.type);
                String className = this.type.getQualifiedName().toString();
                AbstractMethodExtractor extractor = new AbstractMethodExtractor();
                JavaTokenizer tokenizer = new JavaTokenizer(sourceReader);
                Map<String, List<String>> methodOrders = extractor.abstractMethods(tokenizer, packageName);
                if (methodOrders.containsKey(className)) {
                    List<String> list = methodOrders.get(className);
                    return list;
                }
                List<String> list = Collections.emptyList();
                return list;
            }
            finally {
                sourceReader.close();
            }
        }
    }

    private static interface PropertyOrderer {
        public List<String> determinePropertyOrder() throws IOException;
    }

    private static class EclipseIFile {
        private final File file;

        EclipseIFile(ProcessingEnvironment processingEnv, TypeElement element) {
            Filer filer = processingEnv.getFiler();
            Element topLevel = element;
            while (topLevel.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
                topLevel = topLevel.getEnclosingElement();
            }
            try {
                FileObject resource = filer.getResource(StandardLocation.SOURCE_PATH, processingEnv.getElementUtils().getPackageOf(element).getQualifiedName(), topLevel.getSimpleName() + ".java");
                this.file = new File(resource.toUri());
                if (!this.file.canRead()) {
                    processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot find source code in file " + this.file, element);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getCharset() {
            return Charset.defaultCharset().name();
        }

        public InputStream getContents() throws IOException {
            return new FileInputStream(this.file);
        }

        public URI getRawLocationURI() {
            return this.file.toURI();
        }
    }

    private static class EclipseProcessingEnvironment
    implements ProcessingEnvironment {
        private final ProcessingEnvironment processingEnv;

        EclipseProcessingEnvironment(ProcessingEnvironment processingEnv) {
            this.processingEnv = processingEnv;
        }

        public EclipseIFile getEnclosingIFile(Element element) {
            return new EclipseIFile(this.processingEnv, (TypeElement)element);
        }

        @Override
        public Map<String, String> getOptions() {
            return this.processingEnv.getOptions();
        }

        @Override
        public Messager getMessager() {
            return this.processingEnv.getMessager();
        }

        @Override
        public Filer getFiler() {
            return this.processingEnv.getFiler();
        }

        @Override
        public Elements getElementUtils() {
            return this.processingEnv.getElementUtils();
        }

        @Override
        public Types getTypeUtils() {
            return this.processingEnv.getTypeUtils();
        }

        @Override
        public SourceVersion getSourceVersion() {
            return this.processingEnv.getSourceVersion();
        }

        @Override
        public Locale getLocale() {
            return this.processingEnv.getLocale();
        }
    }
}

