/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.common;

import com.google.auto.common.MoreElements;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

public final class MoreTypes {
    private static final Equivalence<TypeMirror> TYPE_EQUIVALENCE = new Equivalence<TypeMirror>(){

        protected boolean doEquivalent(TypeMirror a, TypeMirror b) {
            return MoreTypes.equal(a, b);
        }

        protected int doHash(TypeMirror t) {
            return MoreTypes.hash(t);
        }
    };
    private static final TypeVisitor<Boolean, TypeMirror> EQUAL_VISITOR = new SimpleTypeVisitor6<Boolean, TypeMirror>(){

        @Override
        protected Boolean defaultAction(TypeMirror a, TypeMirror b) {
            return a.getKind().equals((Object)b.getKind());
        }

        @Override
        public Boolean visitArray(ArrayType a, TypeMirror m) {
            if (m.getKind().equals((Object)TypeKind.ARRAY)) {
                ArrayType b = (ArrayType)m;
                return MoreTypes.equal(a.getComponentType(), b.getComponentType());
            }
            return false;
        }

        @Override
        public Boolean visitDeclared(DeclaredType a, TypeMirror m) {
            if (m.getKind().equals((Object)TypeKind.DECLARED)) {
                DeclaredType b = (DeclaredType)m;
                return ((Object)a.asElement()).equals(b.asElement()) && MoreTypes.equal(a.getEnclosingType(), a.getEnclosingType()) && MoreTypes.equalLists(a.getTypeArguments(), b.getTypeArguments());
            }
            return false;
        }

        @Override
        public Boolean visitError(ErrorType a, TypeMirror m) {
            return a.equals(m);
        }

        @Override
        public Boolean visitExecutable(ExecutableType a, TypeMirror m) {
            if (m.getKind().equals((Object)TypeKind.EXECUTABLE)) {
                ExecutableType b = (ExecutableType)m;
                return MoreTypes.equalLists(a.getParameterTypes(), b.getParameterTypes()) && MoreTypes.equal(a.getReturnType(), b.getReturnType()) && MoreTypes.equalLists(a.getThrownTypes(), b.getThrownTypes()) && MoreTypes.equalLists(a.getTypeVariables(), b.getTypeVariables());
            }
            return false;
        }

        @Override
        public Boolean visitTypeVariable(TypeVariable a, TypeMirror m) {
            if (m.getKind().equals((Object)TypeKind.TYPEVAR)) {
                TypeVariable b = (TypeVariable)m;
                return MoreTypes.equal(a.getUpperBound(), b.getUpperBound()) && MoreTypes.equal(a.getLowerBound(), b.getLowerBound());
            }
            return false;
        }

        @Override
        public Boolean visitWildcard(WildcardType a, TypeMirror m) {
            if (m.getKind().equals((Object)TypeKind.WILDCARD)) {
                WildcardType b = (WildcardType)m;
                return MoreTypes.equal(a.getExtendsBound(), b.getExtendsBound()) && MoreTypes.equal(a.getSuperBound(), b.getSuperBound());
            }
            return false;
        }

        @Override
        public Boolean visitUnknown(TypeMirror a, TypeMirror p) {
            throw new UnsupportedOperationException();
        }
    };
    private static final int HASH_SEED = 17;
    private static final int HASH_MULTIPLIER = 31;
    private static final TypeVisitor<Integer, Void> HASH_VISITOR = new SimpleTypeVisitor6<Integer, Void>(){

        int hashKind(int seed, TypeMirror t) {
            int result = seed * 31;
            return result += t.getKind().hashCode();
        }

        @Override
        protected Integer defaultAction(TypeMirror e, Void p) {
            return this.hashKind(17, e);
        }

        @Override
        public Integer visitArray(ArrayType t, Void v) {
            int result = this.hashKind(17, t);
            result *= 31;
            return result += t.getComponentType().accept(this, null).intValue();
        }

        @Override
        public Integer visitDeclared(DeclaredType t, Void v) {
            int result = this.hashKind(17, t);
            result *= 31;
            result += ((Object)t.asElement()).hashCode();
            result *= 31;
            result += t.getEnclosingType().accept(this, null).intValue();
            result *= 31;
            return result += MoreTypes.hashList(t.getTypeArguments());
        }

        @Override
        public Integer visitExecutable(ExecutableType t, Void p) {
            int result = this.hashKind(17, t);
            result *= 31;
            result += MoreTypes.hashList(t.getParameterTypes());
            result *= 31;
            result += t.getReturnType().accept(this, null).intValue();
            result *= 31;
            result += MoreTypes.hashList(t.getThrownTypes());
            result *= 31;
            return result += MoreTypes.hashList(t.getTypeVariables());
        }

        @Override
        public Integer visitTypeVariable(TypeVariable t, Void p) {
            int result = this.hashKind(17, t);
            result *= 31;
            result += t.getLowerBound().accept(this, null).intValue();
            result *= 31;
            return result += t.getUpperBound().accept(this, null).intValue();
        }

        @Override
        public Integer visitWildcard(WildcardType t, Void p) {
            int result = this.hashKind(17, t);
            result *= 31;
            result += t.getExtendsBound() == null ? 0 : t.getExtendsBound().accept(this, null);
            result *= 31;
            return result += t.getSuperBound() == null ? 0 : t.getSuperBound().accept(this, null);
        }

        @Override
        public Integer visitUnknown(TypeMirror t, Void p) {
            throw new UnsupportedOperationException();
        }
    };

    public static Equivalence<TypeMirror> equivalence() {
        return TYPE_EQUIVALENCE;
    }

    static boolean equal(TypeMirror a, TypeMirror b) {
        return a == b || a != null && b != null && a.accept(EQUAL_VISITOR, b) != false;
    }

    private static boolean equalLists(List<? extends TypeMirror> a, List<? extends TypeMirror> b) {
        int size = a.size();
        if (size != b.size()) {
            return false;
        }
        Iterator<? extends TypeMirror> aIterator = a.iterator();
        Iterator<? extends TypeMirror> bIterator = b.iterator();
        while (aIterator.hasNext()) {
            TypeMirror nextMirrorB;
            if (!bIterator.hasNext()) {
                return false;
            }
            TypeMirror nextMirrorA = aIterator.next();
            if (MoreTypes.equal(nextMirrorA, nextMirrorB = bIterator.next())) continue;
            return false;
        }
        return !aIterator.hasNext();
    }

    static int hashList(List<? extends TypeMirror> mirrors) {
        int result = 17;
        for (TypeMirror typeMirror : mirrors) {
            result *= 31;
            result += MoreTypes.hash(typeMirror);
        }
        return result;
    }

    static int hash(TypeMirror mirror) {
        return mirror == null ? 0 : mirror.accept(HASH_VISITOR, null);
    }

    public static ImmutableSet<TypeElement> referencedTypes(TypeMirror type) {
        Preconditions.checkNotNull((Object)type);
        ImmutableSet.Builder elements = ImmutableSet.builder();
        type.accept(new SimpleTypeVisitor6<Void, ImmutableSet.Builder<TypeElement>>(){

            @Override
            public Void visitArray(ArrayType t, ImmutableSet.Builder<TypeElement> p) {
                t.getComponentType().accept(this, p);
                return null;
            }

            @Override
            public Void visitDeclared(DeclaredType t, ImmutableSet.Builder<TypeElement> p) {
                p.add((Object)MoreElements.asType(t.asElement()));
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    typeMirror.accept(this, p);
                }
                return null;
            }

            @Override
            public Void visitTypeVariable(TypeVariable t, ImmutableSet.Builder<TypeElement> p) {
                t.getLowerBound().accept(this, p);
                t.getUpperBound().accept(this, p);
                return null;
            }

            @Override
            public Void visitWildcard(WildcardType t, ImmutableSet.Builder<TypeElement> p) {
                TypeMirror superBound;
                TypeMirror extendsBound = t.getExtendsBound();
                if (extendsBound != null) {
                    extendsBound.accept(this, p);
                }
                if ((superBound = t.getSuperBound()) != null) {
                    superBound.accept(this, p);
                }
                return null;
            }
        }, elements);
        return elements.build();
    }

    public static TypeElement asTypeElement(Types types, TypeMirror mirror) {
        Preconditions.checkNotNull((Object)types);
        Preconditions.checkNotNull((Object)mirror);
        Element element = types.asElement(mirror);
        Preconditions.checkArgument((element != null ? 1 : 0) != 0);
        return element.accept(new SimpleElementVisitor6<TypeElement, Void>(){

            @Override
            protected TypeElement defaultAction(Element e, Void p) {
                throw new IllegalArgumentException();
            }

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }
        }, null);
    }

    public static ImmutableSet<TypeElement> asTypeElements(Types types, Iterable<? extends TypeMirror> mirrors) {
        Preconditions.checkNotNull((Object)types);
        Preconditions.checkNotNull(mirrors);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (TypeMirror typeMirror : mirrors) {
            builder.add((Object)MoreTypes.asTypeElement(types, typeMirror));
        }
        return builder.build();
    }

    private MoreTypes() {
    }
}

