/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.ObjectParser;
import com.google.auth.ServiceAccountSigner;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.CredentialFormatException;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IamUtils;
import com.google.auth.oauth2.IdToken;
import com.google.auth.oauth2.IdTokenProvider;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.QuotaProjectIdProvider;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.UserCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ImpersonatedCredentials
extends GoogleCredentials
implements ServiceAccountSigner,
IdTokenProvider,
QuotaProjectIdProvider {
    private static final long serialVersionUID = -2133257318957488431L;
    private static final String RFC3339 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final int TWELVE_HOURS_IN_SECONDS = 43200;
    private static final int DEFAULT_LIFETIME_IN_SECONDS = 3600;
    private static final String CLOUD_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private static final String IAM_ACCESS_TOKEN_ENDPOINT = "https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:generateAccessToken";
    private GoogleCredentials sourceCredentials;
    private String targetPrincipal;
    private List<String> delegates;
    private List<String> scopes;
    private int lifetime;
    private String quotaProjectId;
    private final String transportFactoryClassName;
    private transient HttpTransportFactory transportFactory;

    public static ImpersonatedCredentials create(GoogleCredentials sourceCredentials, String targetPrincipal, List<String> delegates, List<String> scopes, int lifetime, HttpTransportFactory transportFactory) {
        return ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setTargetPrincipal(targetPrincipal).setDelegates(delegates).setScopes(scopes).setLifetime(lifetime).setHttpTransportFactory(transportFactory).build();
    }

    public static ImpersonatedCredentials create(GoogleCredentials sourceCredentials, String targetPrincipal, List<String> delegates, List<String> scopes, int lifetime, HttpTransportFactory transportFactory, String quotaProjectId) {
        return ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setTargetPrincipal(targetPrincipal).setDelegates(delegates).setScopes(scopes).setLifetime(lifetime).setHttpTransportFactory(transportFactory).setQuotaProjectId(quotaProjectId).build();
    }

    public static ImpersonatedCredentials create(GoogleCredentials sourceCredentials, String targetPrincipal, List<String> delegates, List<String> scopes, int lifetime) {
        return ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setTargetPrincipal(targetPrincipal).setDelegates(delegates).setScopes(scopes).setLifetime(lifetime).build();
    }

    static String extractTargetPrincipal(String serviceAccountImpersonationUrl) {
        int startIndex = serviceAccountImpersonationUrl.lastIndexOf(47);
        int endIndex = serviceAccountImpersonationUrl.indexOf(":generateAccessToken");
        if (startIndex != -1 && endIndex != -1 && startIndex < endIndex) {
            return serviceAccountImpersonationUrl.substring(startIndex + 1, endIndex);
        }
        throw new IllegalArgumentException("Unable to determine target principal from service account impersonation URL.");
    }

    public String getAccount() {
        return this.targetPrincipal;
    }

    @Override
    public String getQuotaProjectId() {
        return this.quotaProjectId;
    }

    @VisibleForTesting
    List<String> getDelegates() {
        return this.delegates;
    }

    @VisibleForTesting
    List<String> getScopes() {
        return this.scopes;
    }

    public GoogleCredentials getSourceCredentials() {
        return this.sourceCredentials;
    }

    int getLifetime() {
        return this.lifetime;
    }

    public void setTransportFactory(HttpTransportFactory httpTransportFactory) {
        this.transportFactory = httpTransportFactory;
    }

    public byte[] sign(byte[] toSign) {
        return IamUtils.sign(this.getAccount(), this.sourceCredentials, this.transportFactory.create(), toSign, ImmutableMap.of((Object)"delegates", this.delegates));
    }

    static ImpersonatedCredentials fromJson(Map<String, Object> json, HttpTransportFactory transportFactory) throws IOException {
        GoogleCredentials sourceCredentials;
        String targetPrincipal;
        String quotaProjectId;
        String sourceCredentialsType;
        Map sourceCredentialsJson;
        Preconditions.checkNotNull(json);
        Preconditions.checkNotNull((Object)transportFactory);
        List delegates = null;
        try {
            String serviceAccountImpersonationUrl = (String)json.get("service_account_impersonation_url");
            if (json.containsKey("delegates")) {
                delegates = (List)json.get("delegates");
            }
            sourceCredentialsJson = (Map)json.get("source_credentials");
            sourceCredentialsType = (String)sourceCredentialsJson.get("type");
            quotaProjectId = (String)json.get("quota_project_id");
            targetPrincipal = ImpersonatedCredentials.extractTargetPrincipal(serviceAccountImpersonationUrl);
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            throw new CredentialFormatException("An invalid input stream was provided.", e);
        }
        if ("authorized_user".equals(sourceCredentialsType)) {
            sourceCredentials = UserCredentials.fromJson(sourceCredentialsJson, transportFactory);
        } else if ("service_account".equals(sourceCredentialsType)) {
            sourceCredentials = ServiceAccountCredentials.fromJson(sourceCredentialsJson, transportFactory);
        } else {
            throw new IOException(String.format("A credential of type %s is not supported as source credential for impersonation.", sourceCredentialsType));
        }
        return ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setTargetPrincipal(targetPrincipal).setDelegates(delegates).setScopes(new ArrayList<String>()).setLifetime(3600).setHttpTransportFactory(transportFactory).setQuotaProjectId(quotaProjectId).build();
    }

    @Override
    public boolean createScopedRequired() {
        return this.scopes == null || this.scopes.isEmpty();
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> scopes) {
        return this.toBuilder().setScopes((List)scopes).setLifetime(this.lifetime).setDelegates(this.delegates).setHttpTransportFactory(this.transportFactory).setQuotaProjectId(this.quotaProjectId).build();
    }

    @Override
    protected Map<String, List<String>> getAdditionalHeaders() {
        Map<String, List<String>> headers = super.getAdditionalHeaders();
        if (this.quotaProjectId != null) {
            return ImpersonatedCredentials.addQuotaProjectIdToRequestMetadata(this.quotaProjectId, headers);
        }
        return headers;
    }

    private ImpersonatedCredentials(Builder builder) {
        this.sourceCredentials = builder.getSourceCredentials();
        this.targetPrincipal = builder.getTargetPrincipal();
        this.delegates = builder.getDelegates();
        this.scopes = builder.getScopes();
        this.lifetime = builder.getLifetime();
        this.transportFactory = (HttpTransportFactory)MoreObjects.firstNonNull((Object)builder.getHttpTransportFactory(), (Object)ImpersonatedCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.quotaProjectId = builder.quotaProjectId;
        this.transportFactoryClassName = this.transportFactory.getClass().getName();
        if (this.delegates == null) {
            this.delegates = new ArrayList<String>();
        }
        if (this.scopes == null) {
            throw new IllegalStateException("Scopes cannot be null");
        }
        if (this.lifetime > 43200) {
            throw new IllegalStateException("lifetime must be less than or equal to 43200");
        }
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        if (this.sourceCredentials.getAccessToken() == null) {
            this.sourceCredentials = this.sourceCredentials.createScoped(Arrays.asList(CLOUD_PLATFORM_SCOPE));
        }
        try {
            this.sourceCredentials.refreshIfExpired();
        }
        catch (IOException e) {
            throw new IOException("Unable to refresh sourceCredentials", e);
        }
        HttpTransport httpTransport = this.transportFactory.create();
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        HttpCredentialsAdapter adapter = new HttpCredentialsAdapter(this.sourceCredentials);
        HttpRequestFactory requestFactory = httpTransport.createRequestFactory();
        String endpointUrl = String.format(IAM_ACCESS_TOKEN_ENDPOINT, this.targetPrincipal);
        GenericUrl url = new GenericUrl(endpointUrl);
        ImmutableMap body = ImmutableMap.of((Object)"delegates", this.delegates, (Object)"scope", this.scopes, (Object)"lifetime", (Object)(this.lifetime + "s"));
        JsonHttpContent requestContent = new JsonHttpContent(parser.getJsonFactory(), (Object)body);
        HttpRequest request = requestFactory.buildPostRequest(url, (HttpContent)requestContent);
        adapter.initialize(request);
        request.setParser((ObjectParser)parser);
        HttpResponse response = null;
        try {
            response = request.execute();
        }
        catch (IOException e) {
            throw new IOException("Error requesting access token", e);
        }
        GenericData responseData = (GenericData)response.parseAs(GenericData.class);
        response.disconnect();
        String accessToken = OAuth2Utils.validateString((Map<String, Object>)responseData, "accessToken", "Expected to find an accessToken");
        String expireTime = OAuth2Utils.validateString((Map<String, Object>)responseData, "expireTime", "Expected to find an expireTime");
        SimpleDateFormat format = new SimpleDateFormat(RFC3339);
        try {
            Date date = format.parse(expireTime);
            return new AccessToken(accessToken, date);
        }
        catch (ParseException pe) {
            throw new IOException("Error parsing expireTime: " + pe.getMessage());
        }
    }

    @Override
    public IdToken idTokenWithAudience(String targetAudience, List<IdTokenProvider.Option> options) throws IOException {
        boolean includeEmail = options != null && options.contains((Object)IdTokenProvider.Option.INCLUDE_EMAIL);
        return IamUtils.getIdToken(this.getAccount(), this.sourceCredentials, this.transportFactory.create(), targetAudience, includeEmail, ImmutableMap.of((Object)"delegates", this.delegates));
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceCredentials, this.targetPrincipal, this.delegates, this.scopes, this.lifetime, this.quotaProjectId});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sourceCredentials", (Object)this.sourceCredentials).add("targetPrincipal", (Object)this.targetPrincipal).add("delegates", this.delegates).add("scopes", this.scopes).add("lifetime", this.lifetime).add("transportFactoryClassName", (Object)this.transportFactoryClassName).add("quotaProjectId", (Object)this.quotaProjectId).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ImpersonatedCredentials)) {
            return false;
        }
        ImpersonatedCredentials other = (ImpersonatedCredentials)obj;
        return Objects.equals((Object)this.sourceCredentials, (Object)other.sourceCredentials) && Objects.equals(this.targetPrincipal, other.targetPrincipal) && Objects.equals(this.delegates, other.delegates) && Objects.equals(this.scopes, other.scopes) && Objects.equals(this.lifetime, other.lifetime) && Objects.equals(this.transportFactoryClassName, other.transportFactoryClassName) && Objects.equals(this.quotaProjectId, other.quotaProjectId);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this.sourceCredentials, this.targetPrincipal);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends GoogleCredentials.Builder {
        private GoogleCredentials sourceCredentials;
        private String targetPrincipal;
        private List<String> delegates;
        private List<String> scopes;
        private int lifetime = 3600;
        private HttpTransportFactory transportFactory;
        private String quotaProjectId;

        protected Builder() {
        }

        protected Builder(GoogleCredentials sourceCredentials, String targetPrincipal) {
            this.sourceCredentials = sourceCredentials;
            this.targetPrincipal = targetPrincipal;
        }

        public Builder setSourceCredentials(GoogleCredentials sourceCredentials) {
            this.sourceCredentials = sourceCredentials;
            return this;
        }

        public GoogleCredentials getSourceCredentials() {
            return this.sourceCredentials;
        }

        public Builder setTargetPrincipal(String targetPrincipal) {
            this.targetPrincipal = targetPrincipal;
            return this;
        }

        public String getTargetPrincipal() {
            return this.targetPrincipal;
        }

        public Builder setDelegates(List<String> delegates) {
            this.delegates = delegates;
            return this;
        }

        public List<String> getDelegates() {
            return this.delegates;
        }

        public Builder setScopes(List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public Builder setLifetime(int lifetime) {
            this.lifetime = lifetime == 0 ? 3600 : lifetime;
            return this;
        }

        public int getLifetime() {
            return this.lifetime;
        }

        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        public HttpTransportFactory getHttpTransportFactory() {
            return this.transportFactory;
        }

        public Builder setQuotaProjectId(String quotaProjectId) {
            this.quotaProjectId = quotaProjectId;
            return this;
        }

        @Override
        public ImpersonatedCredentials build() {
            return new ImpersonatedCredentials(this);
        }
    }
}

