/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.JsonFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class CloudShellCredentials
extends GoogleCredentials {
    private static final int ACCESS_TOKEN_INDEX = 2;
    private static final int READ_TIMEOUT_MS = 5000;
    protected static final String GET_AUTH_TOKEN_REQUEST = "2\n[]";
    private final int authPort;
    private final JsonFactory jsonFactory;

    public CloudShellCredentials(int authPort) {
        this.authPort = authPort;
        this.jsonFactory = OAuth2Utils.JSON_FACTORY;
    }

    protected int getAuthPort() {
        return this.authPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessToken refreshAccessToken() throws IOException {
        AccessToken token;
        Socket socket = new Socket("localhost", this.getAuthPort());
        socket.setSoTimeout(5000);
        try {
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            out.println(GET_AUTH_TOKEN_REQUEST);
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            input.readLine();
            Collection messageArray = this.jsonFactory.createJsonParser((Reader)input).parseArray(LinkedList.class, String.class);
            String accessToken = (String)((List)messageArray).get(2);
            token = new AccessToken(accessToken, null);
        }
        finally {
            socket.close();
        }
        return token;
    }
}

