/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.appengine;

import com.google.appengine.api.appidentity.AppIdentityService;
import com.google.appengine.api.appidentity.AppIdentityServiceFactory;
import com.google.auth.ServiceAccountSigner;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;

public class AppEngineCredentials
extends GoogleCredentials
implements ServiceAccountSigner {
    private static final long serialVersionUID = -2627708355455064660L;
    private final String appIdentityServiceClassName;
    private final Collection<String> scopes;
    private final boolean scopesRequired;
    private transient AppIdentityService appIdentityService;

    private AppEngineCredentials(Collection<String> scopes, AppIdentityService appIdentityService) {
        this.scopes = scopes == null ? ImmutableSet.of() : ImmutableList.copyOf(scopes);
        this.appIdentityService = appIdentityService != null ? appIdentityService : AppIdentityServiceFactory.getAppIdentityService();
        this.appIdentityServiceClassName = this.appIdentityService.getClass().getName();
        this.scopesRequired = this.scopes.isEmpty();
    }

    public AccessToken refreshAccessToken() throws IOException {
        if (this.createScopedRequired()) {
            throw new IOException("AppEngineCredentials requires createScoped call before use.");
        }
        AppIdentityService.GetAccessTokenResult accessTokenResponse = this.appIdentityService.getAccessToken(this.scopes);
        String accessToken = accessTokenResponse.getAccessToken();
        Date expirationTime = accessTokenResponse.getExpirationTime();
        return new AccessToken(accessToken, expirationTime);
    }

    public boolean createScopedRequired() {
        return this.scopesRequired;
    }

    public GoogleCredentials createScoped(Collection<String> scopes) {
        return new AppEngineCredentials(scopes, this.appIdentityService);
    }

    public String getAccount() {
        return this.appIdentityService.getServiceAccountName();
    }

    public byte[] sign(byte[] toSign) {
        return this.appIdentityService.signForApp(toSign).getSignature();
    }

    public int hashCode() {
        return Objects.hash(this.scopes, this.scopesRequired, this.appIdentityServiceClassName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("scopes", this.scopes).add("scopesRequired", this.scopesRequired).add("appIdentityServiceClassName", (Object)this.appIdentityServiceClassName).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AppEngineCredentials)) {
            return false;
        }
        AppEngineCredentials other = (AppEngineCredentials)((Object)obj);
        return this.scopesRequired == other.scopesRequired && Objects.equals(this.scopes, other.scopes) && Objects.equals(this.appIdentityServiceClassName, other.appIdentityServiceClassName);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.appIdentityService = (AppIdentityService)AppEngineCredentials.newInstance((String)this.appIdentityServiceClassName);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends GoogleCredentials.Builder {
        private Collection<String> scopes;
        private AppIdentityService appIdentityService;

        protected Builder() {
        }

        protected Builder(AppEngineCredentials credentials) {
            this.scopes = credentials.scopes;
            this.appIdentityService = credentials.appIdentityService;
        }

        @CanIgnoreReturnValue
        public Builder setScopes(Collection<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAppIdentityService(AppIdentityService appIdentityService) {
            this.appIdentityService = appIdentityService;
            return this;
        }

        public Collection<String> getScopes() {
            return this.scopes;
        }

        public AppIdentityService getAppIdentityService() {
            return this.appIdentityService;
        }

        public AppEngineCredentials build() {
            return new AppEngineCredentials(this.scopes, this.appIdentityService);
        }
    }
}

