/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.ar.sceneform.collision.Box;
import com.google.ar.sceneform.math.Matrix;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.DpToMetersViewSizer;
import com.google.ar.sceneform.rendering.IRenderableInternalData;
import com.google.ar.sceneform.rendering.R;
import com.google.ar.sceneform.rendering.RenderViewToExternalTexture;
import com.google.ar.sceneform.rendering.Renderable;
import com.google.ar.sceneform.rendering.Renderer;
import com.google.ar.sceneform.rendering.ResourceManager;
import com.google.ar.sceneform.rendering.ThreadPools;
import com.google.ar.sceneform.rendering.ViewRenderableInternalData;
import com.google.ar.sceneform.rendering.ViewSizer;
import com.google.ar.sceneform.resources.ResourceRegistry;
import com.google.ar.sceneform.utilities.AndroidPreconditions;
import com.google.ar.sceneform.utilities.Preconditions;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;

@RequiresApi(api=24)
public class ViewRenderable
extends Renderable {
    private static final String TAG = ViewRenderable.class.getSimpleName();
    @Nullable
    private ViewRenderableInternalData viewRenderableData;
    private final View view;
    private final Matrix viewScaleMatrix = new Matrix();
    private ViewSizer viewSizer;
    private VerticalAlignment verticalAlignment = VerticalAlignment.BOTTOM;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
    @Nullable
    private Renderer renderer;
    private boolean isInitialized;
    private final RenderViewToExternalTexture.OnViewSizeChangedListener onViewSizeChangedListener = (width, height) -> {
        if (this.isInitialized) {
            this.updateSuggestedCollisionShapeAsync();
        }
    };

    public View getView() {
        return this.view;
    }

    @Override
    public ViewRenderable makeCopy() {
        return new ViewRenderable(this);
    }

    ViewRenderable(Builder builder, View view) {
        super(builder);
        Preconditions.checkNotNull((Object)view, (Object)"Parameter \"view\" was null.");
        this.view = view;
        this.viewSizer = builder.viewSizer;
        this.horizontalAlignment = builder.horizontalAlignment;
        this.verticalAlignment = builder.verticalAlignment;
        RenderViewToExternalTexture renderView = new RenderViewToExternalTexture(view.getContext(), view);
        renderView.addOnViewSizeChangedListener(this.onViewSizeChangedListener);
        this.viewRenderableData = new ViewRenderableInternalData(renderView);
        this.viewRenderableData.retain();
        this.collisionShape = new Box(Vector3.zero());
    }

    ViewRenderable(ViewRenderable other) {
        super(other);
        this.view = other.view;
        this.viewSizer = other.viewSizer;
        this.horizontalAlignment = other.horizontalAlignment;
        this.verticalAlignment = other.verticalAlignment;
        this.viewRenderableData = (ViewRenderableInternalData)((Object)Preconditions.checkNotNull((Object)((Object)other.viewRenderableData)));
        this.viewRenderableData.retain();
        this.viewRenderableData.getRenderView().addOnViewSizeChangedListener(this.onViewSizeChangedListener);
    }

    public ViewSizer getSizer() {
        return this.viewSizer;
    }

    public void setSizer(ViewSizer viewSizer) {
        Preconditions.checkNotNull((Object)viewSizer, (Object)"Parameter \"viewSizer\" was null.");
        this.viewSizer = viewSizer;
        this.updateSuggestedCollisionShape();
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.updateSuggestedCollisionShape();
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.updateSuggestedCollisionShape();
    }

    @Override
    public Matrix getFinalModelMatrix(Matrix originalMatrix) {
        Preconditions.checkNotNull((Object)originalMatrix, (Object)"Parameter \"originalMatrix\" was null.");
        Vector3 size = this.viewSizer.getSize(this.view);
        this.viewScaleMatrix.makeScale(new Vector3(size.x, size.y, 1.0f));
        this.viewScaleMatrix.setTranslation(new Vector3(this.getOffsetRatioForAlignment(this.horizontalAlignment) * size.x, this.getOffsetRatioForAlignment(this.verticalAlignment) * size.y, 0.0f));
        Matrix.multiply((Matrix)originalMatrix, (Matrix)this.viewScaleMatrix, (Matrix)this.viewScaleMatrix);
        return this.viewScaleMatrix;
    }

    @Override
    void prepareForDraw() {
        if (this.getId().isEmpty()) {
            return;
        }
        ViewRenderableInternalData data = (ViewRenderableInternalData)((Object)Preconditions.checkNotNull((Object)((Object)this.viewRenderableData)));
        RenderViewToExternalTexture renderViewToExternalTexture = data.getRenderView();
        if (!renderViewToExternalTexture.isAttachedToWindow() || !renderViewToExternalTexture.isLaidOut()) {
            return;
        }
        boolean hasDrawnToSurfaceTexture = renderViewToExternalTexture.hasDrawnToSurfaceTexture();
        if (!hasDrawnToSurfaceTexture) {
            return;
        }
        if (!this.isInitialized) {
            this.getMaterial().setExternalTexture("viewTexture", renderViewToExternalTexture.getExternalTexture());
            this.updateSuggestedCollisionShape();
            this.isInitialized = true;
        }
        if (this.renderer != null && this.renderer.isFrontFaceWindingInverted()) {
            this.getMaterial().setFloat2("offsetUv", 1.0f, 0.0f);
        }
        super.prepareForDraw();
    }

    @Override
    void attachToRenderer(Renderer renderer) {
        ((ViewRenderableInternalData)((Object)Preconditions.checkNotNull((Object)((Object)this.viewRenderableData)))).getRenderView().attachView(renderer.getViewAttachmentManager());
        this.renderer = renderer;
    }

    @Override
    void detatchFromRenderer() {
        ((ViewRenderableInternalData)((Object)Preconditions.checkNotNull((Object)((Object)this.viewRenderableData)))).getRenderView().detachView();
        this.renderer = null;
    }

    private void updateSuggestedCollisionShapeAsync() {
        this.view.post(this::updateSuggestedCollisionShape);
    }

    private void updateSuggestedCollisionShape() {
        if (this.getId().isEmpty()) {
            return;
        }
        Box box = (Box)this.collisionShape;
        if (box == null) {
            return;
        }
        IRenderableInternalData renderableData = this.getRenderableData();
        Vector3 viewSize = this.viewSizer.getSize(this.view);
        Vector3 size = renderableData.getSizeAabb();
        size.x *= viewSize.x;
        size.y *= viewSize.y;
        Vector3 center = renderableData.getCenterAabb();
        center.x *= viewSize.x;
        center.y *= viewSize.y;
        center.x += this.getOffsetRatioForAlignment(this.horizontalAlignment) * size.x;
        center.y += this.getOffsetRatioForAlignment(this.verticalAlignment) * size.y;
        box.setSize(size);
        box.setCenter(center);
    }

    private float getOffsetRatioForAlignment(HorizontalAlignment horizontalAlignment) {
        IRenderableInternalData data = this.getRenderableData();
        Vector3 centerAabb = data.getCenterAabb();
        Vector3 extentsAabb = data.getExtentsAabb();
        switch (horizontalAlignment) {
            case LEFT: {
                return -centerAabb.x + extentsAabb.x;
            }
            case CENTER: {
                return -centerAabb.x;
            }
            case RIGHT: {
                return -centerAabb.x - extentsAabb.x;
            }
        }
        String string = String.valueOf((Object)horizontalAlignment);
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length()).append("Invalid HorizontalAlignment: ").append(string).toString());
    }

    private float getOffsetRatioForAlignment(VerticalAlignment verticalAlignment) {
        IRenderableInternalData data = this.getRenderableData();
        Vector3 centerAabb = data.getCenterAabb();
        Vector3 extentsAabb = data.getExtentsAabb();
        switch (verticalAlignment) {
            case BOTTOM: {
                return -centerAabb.y + extentsAabb.y;
            }
            case CENTER: {
                return -centerAabb.y;
            }
            case TOP: {
                return -centerAabb.y - extentsAabb.y;
            }
        }
        String string = String.valueOf((Object)verticalAlignment);
        throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Invalid VerticalAlignment: ").append(string).toString());
    }

    protected void finalize() throws Throwable {
        try {
            ThreadPools.getMainExecutor().execute(() -> this.dispose());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error while Finalizing View Renderable.", (Throwable)e);
        }
        finally {
            super.finalize();
        }
    }

    void dispose() {
        AndroidPreconditions.checkUiThread();
        ViewRenderableInternalData viewRenderableData = this.viewRenderableData;
        if (viewRenderableData != null) {
            viewRenderableData.getRenderView().removeOnViewSizeChangedListener(this.onViewSizeChangedListener);
            viewRenderableData.release();
            this.viewRenderableData = null;
        }
    }

    public static Builder builder() {
        AndroidPreconditions.checkMinAndroidApiLevel();
        return new Builder();
    }

    public static final class Builder
    extends Renderable.Builder<ViewRenderable, Builder> {
        private static final int DEFAULT_DP_TO_METERS = 250;
        @Nullable
        private View view;
        private ViewSizer viewSizer = new DpToMetersViewSizer(250);
        private VerticalAlignment verticalAlignment = VerticalAlignment.BOTTOM;
        private HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
        private OptionalInt resourceId = OptionalInt.empty();

        private Builder() {
        }

        public Builder setView(Context context, View view) {
            this.view = view;
            this.context = context;
            this.registryId = view;
            return this;
        }

        public Builder setView(Context context, int resourceId) {
            this.resourceId = OptionalInt.of(resourceId);
            this.context = context;
            this.registryId = null;
            return this;
        }

        public Builder setSizer(ViewSizer viewSizer) {
            Preconditions.checkNotNull((Object)viewSizer, (Object)"Parameter \"viewSizer\" was null.");
            this.viewSizer = viewSizer;
            return this;
        }

        public Builder setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            return this;
        }

        public Builder setVerticalAlignment(VerticalAlignment verticalAlignment) {
            this.verticalAlignment = verticalAlignment;
            return this;
        }

        @Override
        public CompletableFuture<ViewRenderable> build() {
            if (!this.hasSource().booleanValue() && this.context != null) {
                this.setSource(this.context, R.raw.sceneform_view_renderable);
            }
            this.registryId = this.view;
            return super.build();
        }

        @Override
        protected ViewRenderable makeRenderable() {
            if (this.view != null) {
                return new ViewRenderable(this, this.view);
            }
            return new ViewRenderable(this, this.inflateViewFromResourceId());
        }

        @Override
        protected Class<ViewRenderable> getRenderableClass() {
            return ViewRenderable.class;
        }

        @Override
        protected ResourceRegistry<ViewRenderable> getRenderableRegistry() {
            return ResourceManager.getInstance().getViewRenderableRegistry();
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        @Override
        protected void checkPreconditions() {
            boolean hasView;
            super.checkPreconditions();
            boolean bl = hasView = this.resourceId.isPresent() || this.view != null;
            if (!hasView) {
                throw new AssertionError((Object)"ViewRenderable must have a source.");
            }
            if (this.resourceId.isPresent() && this.view != null) {
                throw new AssertionError((Object)"ViewRenderable must have a resourceId or a view as a source. This one has both.");
            }
        }

        private View inflateViewFromResourceId() {
            if (this.context == null) {
                throw new AssertionError((Object)"Context cannot be null");
            }
            FrameLayout dummy = new FrameLayout(this.context);
            return LayoutInflater.from((Context)this.context).inflate(this.resourceId.getAsInt(), (ViewGroup)dummy, false);
        }
    }

    public static enum VerticalAlignment {
        BOTTOM,
        CENTER,
        TOP;

    }

    public static enum HorizontalAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

