/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.Nullable;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.Color;

public class Vertex {
    private final Vector3 position = Vector3.zero();
    @Nullable
    private Vector3 normal;
    @Nullable
    private UvCoordinate uvCoordinate;
    @Nullable
    private Color color;

    public void setPosition(Vector3 position) {
        this.position.set(position);
    }

    public Vector3 getPosition() {
        return this.position;
    }

    public void setNormal(@Nullable Vector3 normal) {
        this.normal = normal;
    }

    @Nullable
    public Vector3 getNormal() {
        return this.normal;
    }

    public void setUvCoordinate(@Nullable UvCoordinate uvCoordinate) {
        this.uvCoordinate = uvCoordinate;
    }

    @Nullable
    public UvCoordinate getUvCoordinate() {
        return this.uvCoordinate;
    }

    public void setColor(@Nullable Color color) {
        this.color = color;
    }

    @Nullable
    public Color getColor() {
        return this.color;
    }

    private Vertex(Builder builder) {
        this.position.set(builder.position);
        this.normal = builder.normal;
        this.uvCoordinate = builder.uvCoordinate;
        this.color = builder.color;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Vector3 position = Vector3.zero();
        @Nullable
        private Vector3 normal;
        @Nullable
        private UvCoordinate uvCoordinate;
        @Nullable
        private Color color;

        public Builder setPosition(Vector3 position) {
            this.position.set(position);
            return this;
        }

        public Builder setNormal(@Nullable Vector3 normal) {
            this.normal = normal;
            return this;
        }

        public Builder setUvCoordinate(@Nullable UvCoordinate uvCoordinate) {
            this.uvCoordinate = uvCoordinate;
            return this;
        }

        public Builder setColor(@Nullable Color color) {
            this.color = color;
            return this;
        }

        public Vertex build() {
            return new Vertex(this);
        }
    }

    public static final class UvCoordinate {
        public float x;
        public float y;

        public UvCoordinate(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

