/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.Nullable;
import com.google.android.filament.Texture;
import com.google.ar.core.annotations.UsedByNative;
import com.google.ar.sceneform.rendering.EngineInstance;
import com.google.ar.sceneform.rendering.IEngine;
import com.google.ar.sceneform.rendering.Texture;
import com.google.ar.sceneform.resources.SharedReference;
import com.google.ar.sceneform.utilities.AndroidPreconditions;

@UsedByNative(value="material_java_wrappers.h")
public class TextureInternalData
extends SharedReference {
    @Nullable
    private Texture filamentTexture;
    private final Texture.Sampler sampler;

    @UsedByNative(value="material_java_wrappers.h")
    public TextureInternalData(Texture filamentTexture, Texture.Sampler sampler) {
        this.filamentTexture = filamentTexture;
        this.sampler = sampler;
    }

    Texture getFilamentTexture() {
        if (this.filamentTexture == null) {
            throw new IllegalStateException("Filament Texture is null.");
        }
        return this.filamentTexture;
    }

    Texture.Sampler getSampler() {
        return this.sampler;
    }

    protected void onDispose() {
        AndroidPreconditions.checkUiThread();
        IEngine engine = EngineInstance.getEngine();
        Texture filamentTexture = this.filamentTexture;
        this.filamentTexture = null;
        if (filamentTexture != null && engine != null && engine.isValid()) {
            engine.destroyTexture(filamentTexture);
        }
    }
}

