/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.RequiresApi;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.Material;
import com.google.ar.sceneform.rendering.ModelRenderable;
import com.google.ar.sceneform.rendering.RenderableDefinition;
import com.google.ar.sceneform.rendering.Vertex;
import com.google.ar.sceneform.utilities.AndroidPreconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

@RequiresApi(api=24)
public final class ShapeFactory {
    private static final String TAG = ShapeFactory.class.getSimpleName();
    private static final int COORDS_PER_TRIANGLE = 3;

    public static ModelRenderable makeCube(Vector3 size, Vector3 center, Material material) {
        ModelRenderable result;
        AndroidPreconditions.checkMinAndroidApiLevel();
        Vector3 extents = size.scaled(0.5f);
        Vector3 p0 = Vector3.add((Vector3)center, (Vector3)new Vector3(-extents.x, -extents.y, extents.z));
        Vector3 p1 = Vector3.add((Vector3)center, (Vector3)new Vector3(extents.x, -extents.y, extents.z));
        Vector3 p2 = Vector3.add((Vector3)center, (Vector3)new Vector3(extents.x, -extents.y, -extents.z));
        Vector3 p3 = Vector3.add((Vector3)center, (Vector3)new Vector3(-extents.x, -extents.y, -extents.z));
        Vector3 p4 = Vector3.add((Vector3)center, (Vector3)new Vector3(-extents.x, extents.y, extents.z));
        Vector3 p5 = Vector3.add((Vector3)center, (Vector3)new Vector3(extents.x, extents.y, extents.z));
        Vector3 p6 = Vector3.add((Vector3)center, (Vector3)new Vector3(extents.x, extents.y, -extents.z));
        Vector3 p7 = Vector3.add((Vector3)center, (Vector3)new Vector3(-extents.x, extents.y, -extents.z));
        Vector3 up = Vector3.up();
        Vector3 down = Vector3.down();
        Vector3 front = Vector3.forward();
        Vector3 back = Vector3.back();
        Vector3 left = Vector3.left();
        Vector3 right = Vector3.right();
        Vertex.UvCoordinate uv00 = new Vertex.UvCoordinate(0.0f, 0.0f);
        Vertex.UvCoordinate uv10 = new Vertex.UvCoordinate(1.0f, 0.0f);
        Vertex.UvCoordinate uv01 = new Vertex.UvCoordinate(0.0f, 1.0f);
        Vertex.UvCoordinate uv11 = new Vertex.UvCoordinate(1.0f, 1.0f);
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(Arrays.asList(Vertex.builder().setPosition(p0).setNormal(down).setUvCoordinate(uv01).build(), Vertex.builder().setPosition(p1).setNormal(down).setUvCoordinate(uv11).build(), Vertex.builder().setPosition(p2).setNormal(down).setUvCoordinate(uv10).build(), Vertex.builder().setPosition(p3).setNormal(down).setUvCoordinate(uv00).build(), Vertex.builder().setPosition(p7).setNormal(left).setUvCoordinate(uv01).build(), Vertex.builder().setPosition(p4).setNormal(left).setUvCoordinate(uv11).build(), Vertex.builder().setPosition(p0).setNormal(left).setUvCoordinate(uv10).build(), Vertex.builder().setPosition(p3).setNormal(left).setUvCoordinate(uv00).build(), Vertex.builder().setPosition(p4).setNormal(front).setUvCoordinate(uv01).build(), Vertex.builder().setPosition(p5).setNormal(front).setUvCoordinate(uv11).build(), Vertex.builder().setPosition(p1).setNormal(front).setUvCoordinate(uv10).build(), Vertex.builder().setPosition(p0).setNormal(front).setUvCoordinate(uv00).build(), Vertex.builder().setPosition(p6).setNormal(back).setUvCoordinate(uv01).build(), Vertex.builder().setPosition(p7).setNormal(back).setUvCoordinate(uv11).build(), Vertex.builder().setPosition(p3).setNormal(back).setUvCoordinate(uv10).build(), Vertex.builder().setPosition(p2).setNormal(back).setUvCoordinate(uv00).build(), Vertex.builder().setPosition(p5).setNormal(right).setUvCoordinate(uv01).build(), Vertex.builder().setPosition(p6).setNormal(right).setUvCoordinate(uv11).build(), Vertex.builder().setPosition(p2).setNormal(right).setUvCoordinate(uv10).build(), Vertex.builder().setPosition(p1).setNormal(right).setUvCoordinate(uv00).build(), Vertex.builder().setPosition(p7).setNormal(up).setUvCoordinate(uv01).build(), Vertex.builder().setPosition(p6).setNormal(up).setUvCoordinate(uv11).build(), Vertex.builder().setPosition(p5).setNormal(up).setUvCoordinate(uv10).build(), Vertex.builder().setPosition(p4).setNormal(up).setUvCoordinate(uv00).build()));
        int numSides = 6;
        int verticesPerSide = 4;
        int trianglesPerSide = 2;
        ArrayList<Integer> triangleIndices = new ArrayList<Integer>(36);
        for (int i = 0; i < 6; ++i) {
            triangleIndices.add(3 + 4 * i);
            triangleIndices.add(1 + 4 * i);
            triangleIndices.add(0 + 4 * i);
            triangleIndices.add(3 + 4 * i);
            triangleIndices.add(2 + 4 * i);
            triangleIndices.add(1 + 4 * i);
        }
        RenderableDefinition.Submesh submesh = RenderableDefinition.Submesh.builder().setTriangleIndices(triangleIndices).setMaterial(material).build();
        RenderableDefinition renderableDefinition = RenderableDefinition.builder().setVertices(vertices).setSubmeshes(Arrays.asList(submesh)).build();
        CompletableFuture future = ((ModelRenderable.Builder)ModelRenderable.builder().setSource(renderableDefinition)).build();
        try {
            result = (ModelRenderable)future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new AssertionError("Error creating renderable.", ex);
        }
        if (result == null) {
            throw new AssertionError((Object)"Error creating renderable.");
        }
        return result;
    }

    public static ModelRenderable makeSphere(float radius, Vector3 center, Material material) {
        ModelRenderable result;
        AndroidPreconditions.checkMinAndroidApiLevel();
        int stacks = 24;
        int slices = 24;
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(602);
        float pi = (float)Math.PI;
        float doublePi = pi * 2.0f;
        for (int stack = 0; stack <= 24; ++stack) {
            float phi = pi * (float)stack / 24.0f;
            float sinPhi = (float)Math.sin(phi);
            float cosPhi = (float)Math.cos(phi);
            for (int slice = 0; slice <= 24; ++slice) {
                float theta = doublePi * (float)(slice == 24 ? 0 : slice) / 24.0f;
                float sinTheta = (float)Math.sin(theta);
                float cosTheta = (float)Math.cos(theta);
                Vector3 position = new Vector3(sinPhi * cosTheta, cosPhi, sinPhi * sinTheta).scaled(radius);
                Vector3 normal = position.normalized();
                position = Vector3.add((Vector3)position, (Vector3)center);
                Vertex.UvCoordinate uvCoordinate = new Vertex.UvCoordinate(1.0f - (float)slice / 24.0f, 1.0f - (float)stack / 24.0f);
                Vertex vertex = Vertex.builder().setPosition(position).setNormal(normal).setUvCoordinate(uvCoordinate).build();
                vertices.add(vertex);
            }
        }
        int numFaces = vertices.size();
        int numTriangles = numFaces * 2;
        int numIndices = numTriangles * 3;
        ArrayList<Integer> triangleIndices = new ArrayList<Integer>(numIndices);
        int v = 0;
        for (int stack = 0; stack < 24; ++stack) {
            for (int slice = 0; slice < 24; ++slice) {
                boolean topCap = stack == 0;
                boolean bottomCap = stack == 23;
                int next = slice + 1;
                if (!topCap) {
                    triangleIndices.add(v + slice);
                    triangleIndices.add(v + next);
                    triangleIndices.add(v + slice + 24 + 1);
                }
                if (bottomCap) continue;
                triangleIndices.add(v + next);
                triangleIndices.add(v + next + 24 + 1);
                triangleIndices.add(v + slice + 24 + 1);
            }
            v += 25;
        }
        RenderableDefinition.Submesh submesh = RenderableDefinition.Submesh.builder().setTriangleIndices(triangleIndices).setMaterial(material).build();
        RenderableDefinition renderableDefinition = RenderableDefinition.builder().setVertices(vertices).setSubmeshes(Arrays.asList(submesh)).build();
        CompletableFuture future = ((ModelRenderable.Builder)ModelRenderable.builder().setSource(renderableDefinition)).build();
        try {
            result = (ModelRenderable)future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new AssertionError("Error creating renderable.", ex);
        }
        if (result == null) {
            throw new AssertionError((Object)"Error creating renderable.");
        }
        return result;
    }

    public static ModelRenderable makeCylinder(float radius, float height, Vector3 center, Material material) {
        ModelRenderable result;
        AndroidPreconditions.checkMinAndroidApiLevel();
        int numberOfSides = 24;
        float halfHeight = height / 2.0f;
        float thetaIncrement = 0.2617994f;
        float theta = 0.0f;
        float uStep = 0.041666668f;
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(100);
        ArrayList<Vertex> lowerCapVertices = new ArrayList<Vertex>(25);
        ArrayList<Vertex> upperCapVertices = new ArrayList<Vertex>(25);
        ArrayList<Vertex> upperEdgeVertices = new ArrayList<Vertex>(25);
        for (int side = 0; side <= 24; ++side) {
            float cosTheta = (float)Math.cos(theta);
            float sinTheta = (float)Math.sin(theta);
            Vector3 lowerPosition = new Vector3(radius * cosTheta, -halfHeight, radius * sinTheta);
            Vector3 normal = new Vector3(lowerPosition.x, 0.0f, lowerPosition.z).normalized();
            lowerPosition = Vector3.add((Vector3)lowerPosition, (Vector3)center);
            Vertex.UvCoordinate uvCoordinate = new Vertex.UvCoordinate(uStep * (float)side, 0.0f);
            Vertex vertex = Vertex.builder().setPosition(lowerPosition).setNormal(normal).setUvCoordinate(uvCoordinate).build();
            vertices.add(vertex);
            vertex = Vertex.builder().setPosition(lowerPosition).setNormal(Vector3.down()).setUvCoordinate(new Vertex.UvCoordinate((cosTheta + 1.0f) / 2.0f, (sinTheta + 1.0f) / 2.0f)).build();
            lowerCapVertices.add(vertex);
            Vector3 upperPosition = new Vector3(radius * cosTheta, halfHeight, radius * sinTheta);
            normal = new Vector3(upperPosition.x, 0.0f, upperPosition.z).normalized();
            upperPosition = Vector3.add((Vector3)upperPosition, (Vector3)center);
            uvCoordinate = new Vertex.UvCoordinate(uStep * (float)side, 1.0f);
            vertex = Vertex.builder().setPosition(upperPosition).setNormal(normal).setUvCoordinate(uvCoordinate).build();
            upperEdgeVertices.add(vertex);
            vertex = Vertex.builder().setPosition(upperPosition).setNormal(Vector3.up()).setUvCoordinate(new Vertex.UvCoordinate((cosTheta + 1.0f) / 2.0f, (sinTheta + 1.0f) / 2.0f)).build();
            upperCapVertices.add(vertex);
            theta += 0.2617994f;
        }
        vertices.addAll(upperEdgeVertices);
        int lowerCenterIndex = vertices.size();
        vertices.add(Vertex.builder().setPosition(Vector3.add((Vector3)center, (Vector3)new Vector3(0.0f, -halfHeight, 0.0f))).setNormal(Vector3.down()).setUvCoordinate(new Vertex.UvCoordinate(0.5f, 0.5f)).build());
        vertices.addAll(lowerCapVertices);
        int upperCenterIndex = vertices.size();
        vertices.add(Vertex.builder().setPosition(Vector3.add((Vector3)center, (Vector3)new Vector3(0.0f, halfHeight, 0.0f))).setNormal(Vector3.up()).setUvCoordinate(new Vertex.UvCoordinate(0.5f, 0.5f)).build());
        vertices.addAll(upperCapVertices);
        ArrayList<Integer> triangleIndices = new ArrayList<Integer>();
        for (int side = 0; side < 24; ++side) {
            int bottomLeft = side;
            int bottomRight = side + 1;
            int topLeft = side + 24 + 1;
            int topRight = side + 24 + 2;
            triangleIndices.add(bottomLeft);
            triangleIndices.add(topRight);
            triangleIndices.add(bottomRight);
            triangleIndices.add(bottomLeft);
            triangleIndices.add(topLeft);
            triangleIndices.add(topRight);
            triangleIndices.add(lowerCenterIndex);
            triangleIndices.add(lowerCenterIndex + side + 1);
            triangleIndices.add(lowerCenterIndex + side + 2);
            triangleIndices.add(upperCenterIndex);
            triangleIndices.add(upperCenterIndex + side + 2);
            triangleIndices.add(upperCenterIndex + side + 1);
        }
        RenderableDefinition.Submesh submesh = RenderableDefinition.Submesh.builder().setTriangleIndices(triangleIndices).setMaterial(material).build();
        RenderableDefinition renderableDefinition = RenderableDefinition.builder().setVertices(vertices).setSubmeshes(Arrays.asList(submesh)).build();
        CompletableFuture future = ((ModelRenderable.Builder)ModelRenderable.builder().setSource(renderableDefinition)).build();
        try {
            result = (ModelRenderable)future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new AssertionError("Error creating renderable.", ex);
        }
        if (result == null) {
            throw new AssertionError((Object)"Error creating renderable.");
        }
        return result;
    }
}

