/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.Nullable;
import com.google.ar.sceneform.collision.Box;
import com.google.ar.sceneform.collision.CollisionShape;
import com.google.ar.sceneform.collision.Sphere;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.schemas.sceneform.SceneformBundleDef;
import com.google.ar.schemas.sceneform.SuggestedCollisionShapeDef;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class SceneformBundle {
    private static final String TAG = SceneformBundle.class.getSimpleName();
    public static final float RCB_MAJOR_VERSION = 0.54f;
    public static final int RCB_MINOR_VERSION = 2;
    private static final char[] RCB_SIGNATURE = new char[]{'R', 'B', 'U', 'N'};
    private static final int SIGNATURE_OFFSET = 4;

    @Nullable
    public static SceneformBundleDef tryLoadSceneformBundle(ByteBuffer buffer) throws VersionException {
        if (SceneformBundle.isSceneformBundle(buffer)) {
            buffer.rewind();
            SceneformBundleDef bundle = SceneformBundleDef.getRootAsSceneformBundleDef((ByteBuffer)buffer);
            float majorVersion = bundle.version().majorVersion();
            int minorVersion = bundle.version().minorVersion();
            if (0.54f < bundle.version().majorVersion()) {
                throw new VersionException(new StringBuilder(140).append("Sceneform bundle (.sfb) version not supported, max version supported is 0.54.X. Version requested for loading is ").append(majorVersion).append(".").append(minorVersion).toString());
            }
            return bundle;
        }
        return null;
    }

    public static CollisionShape readCollisionGeometry(SceneformBundleDef rcb) throws IOException {
        SuggestedCollisionShapeDef shape = rcb.suggestedCollisionShape();
        int type = shape.type();
        switch (type) {
            case 0: {
                Box box = new Box();
                box.setCenter(new Vector3(shape.center().x(), shape.center().y(), shape.center().z()));
                box.setSize(new Vector3(shape.size().x(), shape.size().y(), shape.size().z()));
                return box;
            }
            case 1: {
                Sphere sphere = new Sphere();
                sphere.setCenter(new Vector3(shape.center().x(), shape.center().y(), shape.center().z()));
                sphere.setRadius(shape.size().x());
                return sphere;
            }
        }
        throw new IOException("Invalid collisionCollisionGeometry type.");
    }

    public static boolean isSceneformBundle(ByteBuffer buffer) {
        for (int i = 0; i < RCB_SIGNATURE.length; ++i) {
            if (buffer.get(4 + i) == RCB_SIGNATURE[i]) continue;
            return false;
        }
        return true;
    }

    static class VersionException
    extends Exception {
        public VersionException(String message) {
            super(message);
        }
    }
}

