/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.google.android.filament.Entity;
import com.google.android.filament.EntityManager;
import com.google.android.filament.RenderableManager;
import com.google.android.filament.TransformManager;
import com.google.ar.sceneform.common.TransformProvider;
import com.google.ar.sceneform.math.Matrix;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.EngineInstance;
import com.google.ar.sceneform.rendering.IEngine;
import com.google.ar.sceneform.rendering.IRenderableInternalData;
import com.google.ar.sceneform.rendering.ModelRenderable;
import com.google.ar.sceneform.rendering.Renderable;
import com.google.ar.sceneform.rendering.Renderer;
import com.google.ar.sceneform.rendering.ResourceManager;
import com.google.ar.sceneform.rendering.SkeletonRig;
import com.google.ar.sceneform.utilities.AndroidPreconditions;
import com.google.ar.sceneform.utilities.ChangeId;
import com.google.ar.sceneform.utilities.Preconditions;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class RenderableInstance {
    private static final String TAG = RenderableInstance.class.getSimpleName();
    private final TransformProvider transformProvider;
    private final Renderable renderable;
    @Nullable
    private Renderer attachedRenderer;
    @Entity
    private int entity = 0;
    @Entity
    private int childEntity = 0;
    int renderableId = 0;
    @Nullable
    private SkinningModifier skinningModifier;
    @Nullable
    private Matrix cachedRelativeTransform;
    @Nullable
    private Matrix cachedRelativeTransformInverse;

    public RenderableInstance(TransformProvider transformProvider, Renderable renderable) {
        Preconditions.checkNotNull((Object)transformProvider, (Object)"Parameter \"transformProvider\" was null.");
        Preconditions.checkNotNull((Object)renderable, (Object)"Parameter \"renderable\" was null.");
        this.transformProvider = transformProvider;
        this.renderable = renderable;
        this.entity = RenderableInstance.createFilamentEntity(EngineInstance.getEngine());
        Matrix relativeTransform = this.getRelativeTransform();
        if (relativeTransform != null) {
            this.childEntity = RenderableInstance.createFilamentChildEntity(EngineInstance.getEngine(), this.entity, relativeTransform);
        }
        this.createGltfModelInstance();
        ResourceManager.getInstance().getRenderableInstanceCleanupRegistry().register(this, new CleanupCallback(this.entity, this.childEntity));
    }

    void createGltfModelInstance() {
    }

    public Renderable getRenderable() {
        return this.renderable;
    }

    @Entity
    public int getEntity() {
        return this.entity;
    }

    @Entity
    public int getRenderedEntity() {
        return this.childEntity == 0 ? this.entity : this.childEntity;
    }

    void setModelMatrix(TransformManager transformManager, @Size(min=16L) float[] transform) {
        int instance = transformManager.getInstance(this.entity);
        transformManager.setTransform(instance, transform);
    }

    public Matrix getWorldModelMatrix() {
        return this.renderable.getFinalModelMatrix(this.transformProvider.getWorldModelMatrix());
    }

    public void setSkinningModifier(@Nullable SkinningModifier skinningModifier) {
        this.skinningModifier = skinningModifier;
    }

    @Nullable
    public SkeletonRig getSkeletonRig() {
        if (this.renderable instanceof ModelRenderable) {
            return ((ModelRenderable)this.renderable).getSkeletonRig();
        }
        return null;
    }

    public void prepareForDraw() {
        this.renderable.prepareForDraw();
        ChangeId changeId = this.renderable.getId();
        if (changeId.checkChanged(this.renderableId)) {
            this.renderable.getRenderableData().buildInstanceData(this.renderable, this.getSkeletonRig(), this.getRenderedEntity());
            this.renderableId = changeId.get();
            this.updateSkinning(true);
        } else {
            this.updateSkinning(false);
        }
    }

    public void attachToRenderer(Renderer renderer) {
        renderer.addInstance(this);
        this.attachedRenderer = renderer;
        this.renderable.attachToRenderer(renderer);
    }

    public void detachFromRenderer() {
        if (this.attachedRenderer != null) {
            this.attachedRenderer.removeInstance(this);
            this.renderable.detatchFromRenderer();
        }
    }

    @Nullable
    public Matrix getRelativeTransform() {
        if (this.cachedRelativeTransform != null) {
            return this.cachedRelativeTransform;
        }
        IRenderableInternalData renderableData = this.renderable.getRenderableData();
        float scale = renderableData.getTransformScale();
        Vector3 offset = renderableData.getTransformOffset();
        if (scale == 1.0f && Vector3.equals((Vector3)offset, (Vector3)Vector3.zero())) {
            return null;
        }
        this.cachedRelativeTransform = new Matrix();
        this.cachedRelativeTransform.makeScale(scale);
        this.cachedRelativeTransform.setTranslation(offset);
        return this.cachedRelativeTransform;
    }

    @Nullable
    public Matrix getRelativeTransformInverse() {
        if (this.cachedRelativeTransformInverse != null) {
            return this.cachedRelativeTransformInverse;
        }
        Matrix relativeTransform = this.getRelativeTransform();
        if (relativeTransform == null) {
            return null;
        }
        this.cachedRelativeTransformInverse = new Matrix();
        Matrix.invert((Matrix)relativeTransform, (Matrix)this.cachedRelativeTransformInverse);
        return this.cachedRelativeTransformInverse;
    }

    private void updateSkinning(boolean force) {
        if (!(this.renderable instanceof ModelRenderable)) {
            return;
        }
        ModelRenderable modelRenderable = (ModelRenderable)this.renderable;
        SkeletonRig skeleton = this.getSkeletonRig();
        if (skeleton == null) {
            return;
        }
        if (force || skeleton.isAnimating(modelRenderable) || this.skinningModifier != null && this.skinningModifier.isModifiedSinceLastRender()) {
            int numBones = skeleton.getMaterialBoneCount();
            RenderableManager renderableManager = EngineInstance.getEngine().getRenderableManager();
            int renderableInstance = renderableManager.getInstance(this.getRenderedEntity());
            FloatBuffer boneTransforms = skeleton.getMaterialBoneTransformsBuffer();
            if (this.skinningModifier != null) {
                boneTransforms = this.skinningModifier.modifyMaterialBoneTransformsBuffer(boneTransforms);
            }
            renderableManager.setBonesAsMatrices(renderableInstance, (Buffer)boneTransforms, numBones, 0);
        }
    }

    void setBlendOrderAt(int index, int blendOrder) {
        RenderableManager renderableManager = EngineInstance.getEngine().getRenderableManager();
        int renderableInstance = renderableManager.getInstance(this.getRenderedEntity());
        renderableManager.setBlendOrderAt(renderableInstance, index, blendOrder);
    }

    @Entity
    private static int createFilamentEntity(IEngine engine) {
        EntityManager entityManager = EntityManager.get();
        int entity = entityManager.create();
        TransformManager transformManager = engine.getTransformManager();
        transformManager.create(entity);
        return entity;
    }

    @Entity
    private static int createFilamentChildEntity(IEngine engine, @Entity int entity, Matrix relativeTransform) {
        EntityManager entityManager = EntityManager.get();
        int childEntity = entityManager.create();
        TransformManager transformManager = engine.getTransformManager();
        transformManager.create(childEntity, transformManager.getInstance(entity), relativeTransform.data);
        return childEntity;
    }

    private static final class CleanupCallback
    implements Runnable {
        private final int childEntity;
        private final int entity;

        CleanupCallback(int childEntity, int entity) {
            this.childEntity = childEntity;
            this.entity = entity;
        }

        @Override
        public void run() {
            AndroidPreconditions.checkUiThread();
            IEngine engine = EngineInstance.getEngine();
            if (engine == null || !engine.isValid()) {
                return;
            }
            RenderableManager renderableManager = engine.getRenderableManager();
            if (this.childEntity != 0) {
                renderableManager.destroy(this.childEntity);
            }
            if (this.entity != 0) {
                renderableManager.destroy(this.entity);
            }
        }
    }

    public static interface SkinningModifier {
        public FloatBuffer modifyMaterialBoneTransformsBuffer(FloatBuffer var1);

        public boolean isModifiedSinceLastRender();
    }
}

