/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.ar.sceneform.collision.Box;
import com.google.ar.sceneform.collision.CollisionShape;
import com.google.ar.sceneform.common.TransformProvider;
import com.google.ar.sceneform.math.Matrix;
import com.google.ar.sceneform.rendering.FutureHelper;
import com.google.ar.sceneform.rendering.IRenderableInternalData;
import com.google.ar.sceneform.rendering.LoadGltfListener;
import com.google.ar.sceneform.rendering.LoadRenderableFromSfbTask;
import com.google.ar.sceneform.rendering.Material;
import com.google.ar.sceneform.rendering.RenderableDefinition;
import com.google.ar.sceneform.rendering.RenderableInstance;
import com.google.ar.sceneform.rendering.RenderableInternalData;
import com.google.ar.sceneform.rendering.Renderer;
import com.google.ar.sceneform.resources.ResourceRegistry;
import com.google.ar.sceneform.utilities.AndroidPreconditions;
import com.google.ar.sceneform.utilities.ChangeId;
import com.google.ar.sceneform.utilities.LoadHelper;
import com.google.ar.sceneform.utilities.Preconditions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public abstract class Renderable {
    private final IRenderableInternalData renderableData;
    private final ArrayList<Material> materialBindings = new ArrayList();
    private final ArrayList<String> materialNames = new ArrayList();
    private int renderPriority = 4;
    private boolean isShadowCaster = true;
    private boolean isShadowReceiver = true;
    @Nullable
    protected CollisionShape collisionShape;
    private final ChangeId changeId = new ChangeId();
    public static final int RENDER_PRIORITY_DEFAULT = 4;
    public static final int RENDER_PRIORITY_FIRST = 0;
    public static final int RENDER_PRIORITY_LAST = 7;
    private static final long DEFAULT_MAX_STALE_CACHE = TimeUnit.DAYS.toSeconds(14L);

    protected Renderable(Builder<? extends Renderable, ? extends Builder<?, ?>> builder) {
        Preconditions.checkNotNull(builder, (Object)"Parameter \"builder\" was null.");
        this.renderableData = ((Builder)builder).isGltf ? this.createRenderableInternalGltfData() : new RenderableInternalData();
        if (((Builder)builder).definition != null) {
            this.updateFromDefinition(((Builder)builder).definition);
        }
    }

    protected Renderable(Renderable other) {
        if (other.getId().isEmpty()) {
            throw new AssertionError((Object)"Cannot copy uninitialized Renderable.");
        }
        this.renderableData = other.renderableData;
        Preconditions.checkState((other.materialNames.size() == other.materialBindings.size() ? 1 : 0) != 0);
        for (int i = 0; i < other.materialBindings.size(); ++i) {
            Material otherMaterial = other.materialBindings.get(i);
            this.materialBindings.add(otherMaterial.makeCopy());
            this.materialNames.add(other.materialNames.get(i));
        }
        this.renderPriority = other.renderPriority;
        this.isShadowCaster = other.isShadowCaster;
        this.isShadowReceiver = other.isShadowReceiver;
        if (other.collisionShape != null) {
            this.collisionShape = other.collisionShape.makeCopy();
        }
        this.changeId.update();
    }

    @Nullable
    public CollisionShape getCollisionShape() {
        return this.collisionShape;
    }

    public void setCollisionShape(@Nullable CollisionShape collisionShape) {
        this.collisionShape = collisionShape;
        this.changeId.update();
    }

    public Material getMaterial() {
        return this.getMaterial(0);
    }

    public Material getMaterial(int submeshIndex) {
        if (submeshIndex < this.materialBindings.size()) {
            return this.materialBindings.get(submeshIndex);
        }
        throw this.makeSubmeshOutOfRangeException(submeshIndex);
    }

    public void setMaterial(Material material) {
        this.setMaterial(0, material);
    }

    public void setMaterial(int submeshIndex, Material material) {
        if (submeshIndex >= this.materialBindings.size()) {
            throw this.makeSubmeshOutOfRangeException(submeshIndex);
        }
        this.materialBindings.set(submeshIndex, material);
        this.changeId.update();
    }

    public String getSubmeshName(int submeshIndex) {
        Preconditions.checkState((this.materialNames.size() == this.materialBindings.size() ? 1 : 0) != 0);
        if (submeshIndex >= 0 && submeshIndex < this.materialNames.size()) {
            return this.materialNames.get(submeshIndex);
        }
        throw this.makeSubmeshOutOfRangeException(submeshIndex);
    }

    public int getRenderPriority() {
        return this.renderPriority;
    }

    public void setRenderPriority(@IntRange(from=0L, to=7L) int renderPriority) {
        this.renderPriority = Math.min(7, Math.max(0, renderPriority));
        this.changeId.update();
    }

    public boolean isShadowCaster() {
        return this.isShadowCaster;
    }

    public void setShadowCaster(boolean isShadowCaster) {
        this.isShadowCaster = isShadowCaster;
        this.changeId.update();
    }

    public boolean isShadowReceiver() {
        return this.isShadowReceiver;
    }

    public void setShadowReceiver(boolean isShadowReceiver) {
        this.isShadowReceiver = isShadowReceiver;
        this.changeId.update();
    }

    public int getSubmeshCount() {
        return this.renderableData.getMeshes().size();
    }

    public ChangeId getId() {
        return this.changeId;
    }

    public RenderableInstance createInstance(TransformProvider transformProvider) {
        return new RenderableInstance(transformProvider, this);
    }

    public void updateFromDefinition(RenderableDefinition definition) {
        Preconditions.checkState((!definition.getSubmeshes().isEmpty() ? 1 : 0) != 0);
        this.changeId.update();
        definition.applyDefinitionToData(this.renderableData, this.materialBindings, this.materialNames);
        this.collisionShape = new Box(this.renderableData.getSizeAabb(), this.renderableData.getCenterAabb());
    }

    public abstract Renderable makeCopy();

    IRenderableInternalData getRenderableData() {
        return this.renderableData;
    }

    ArrayList<Material> getMaterialBindings() {
        return this.materialBindings;
    }

    ArrayList<String> getMaterialNames() {
        return this.materialNames;
    }

    void prepareForDraw() {
    }

    void attachToRenderer(Renderer renderer) {
    }

    void detatchFromRenderer() {
    }

    public Matrix getFinalModelMatrix(Matrix originalMatrix) {
        Preconditions.checkNotNull((Object)originalMatrix, (Object)"Parameter \"originalMatrix\" was null.");
        return originalMatrix;
    }

    private IllegalArgumentException makeSubmeshOutOfRangeException(int submeshIndex) {
        int n = this.getSubmeshCount();
        return new IllegalArgumentException(new StringBuilder(96).append("submeshIndex (").append(submeshIndex).append(") is out of range. It must be less than the submeshCount (").append(n).append(").").toString());
    }

    private IRenderableInternalData createRenderableInternalGltfData() {
        return null;
    }

    static abstract class Builder<T extends Renderable, B extends Builder<T, B>> {
        @Nullable
        protected Object registryId = null;
        @Nullable
        protected Context context = null;
        @Nullable
        private Uri sourceUri = null;
        @Nullable
        private Callable<InputStream> inputStreamCreator = null;
        @Nullable
        private RenderableDefinition definition = null;
        private boolean isGltf = false;
        @Nullable
        private LoadGltfListener loadGltfListener;
        @Nullable
        private Function<String, Uri> uriResolver = null;
        @Nullable
        private byte[] materialsBytes = null;

        protected Builder() {
        }

        public B setSource(Context context, Callable<InputStream> inputStreamCreator) {
            Preconditions.checkNotNull(inputStreamCreator);
            this.sourceUri = null;
            this.inputStreamCreator = inputStreamCreator;
            this.context = context;
            return this.getSelf();
        }

        public B setSource(Context context, Uri sourceUri) {
            return this.setRemoteSourceHelper(context, sourceUri, true);
        }

        public B setSource(Context context, Uri sourceUri, boolean enableCaching) {
            return null;
        }

        public B setSource(Context context, int resource) {
            Uri uri;
            this.inputStreamCreator = LoadHelper.fromResource((Context)context, (int)resource);
            this.context = context;
            this.sourceUri = uri = LoadHelper.resourceToUri((Context)context, (int)resource);
            this.registryId = uri;
            return this.getSelf();
        }

        public B setSource(RenderableDefinition definition) {
            this.definition = definition;
            this.registryId = null;
            this.sourceUri = null;
            return this.getSelf();
        }

        public B setRegistryId(@Nullable Object registryId) {
            this.registryId = registryId;
            return this.getSelf();
        }

        public Boolean hasSource() {
            return this.sourceUri != null || this.inputStreamCreator != null || this.definition != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public CompletableFuture<T> build() {
            ResourceRegistry<T> registry;
            CompletableFuture renderableFuture;
            try {
                this.checkPreconditions();
            }
            catch (Throwable failedPrecondition) {
                CompletableFuture result = new CompletableFuture();
                result.completeExceptionally(failedPrecondition);
                String string = String.valueOf(this.registryId);
                FutureHelper.logOnException(this.getRenderableClass().getSimpleName(), result, new StringBuilder(39 + String.valueOf(string).length()).append("Unable to load Renderable registryId='").append(string).append("'").toString());
                return result;
            }
            Object registryId = this.registryId;
            if (registryId != null && (renderableFuture = (registry = this.getRenderableRegistry()).get(registryId)) != null) {
                return renderableFuture.thenApply(renderable -> (Renderable)this.getRenderableClass().cast(renderable.makeCopy()));
            }
            T renderable2 = this.makeRenderable();
            if (this.definition != null) {
                return CompletableFuture.completedFuture(renderable2);
            }
            Callable<InputStream> inputStreamCreator = this.inputStreamCreator;
            if (inputStreamCreator == null) {
                CompletableFuture result = new CompletableFuture();
                result.completeExceptionally((Throwable)((Object)new AssertionError((Object)"Input Stream Creator is null.")));
                String string = String.valueOf(registryId);
                FutureHelper.logOnException(this.getRenderableClass().getSimpleName(), result, new StringBuilder(39 + String.valueOf(string).length()).append("Unable to load Renderable registryId='").append(string).append("'").toString());
                return result;
            }
            CompletableFuture<T> result = null;
            if (this.isGltf) {
                if (this.context == null) throw new AssertionError((Object)"Gltf Renderable.Builder must have a valid context.");
                result = this.loadRenderableFromGltf(this.context, renderable2, this.materialsBytes);
            } else {
                LoadRenderableFromSfbTask<T> loader = new LoadRenderableFromSfbTask<T>(renderable2, this.sourceUri);
                result = loader.downloadAndProcessRenderable(inputStreamCreator);
            }
            if (registryId != null) {
                ResourceRegistry<T> registry2 = this.getRenderableRegistry();
                registry2.register(registryId, result);
            }
            String string = String.valueOf(registryId);
            FutureHelper.logOnException(this.getRenderableClass().getSimpleName(), result, new StringBuilder(39 + String.valueOf(string).length()).append("Unable to load Renderable registryId='").append(string).append("'").toString());
            return result.thenApply(resultRenderable -> (Renderable)this.getRenderableClass().cast(resultRenderable.makeCopy()));
        }

        protected void checkPreconditions() {
            AndroidPreconditions.checkUiThread();
            if (!this.hasSource().booleanValue()) {
                throw new AssertionError((Object)"ModelRenderable must have a source.");
            }
        }

        private B setRemoteSourceHelper(Context context, Uri sourceUri, boolean enableCaching) {
            Preconditions.checkNotNull((Object)sourceUri);
            this.sourceUri = sourceUri;
            this.context = context;
            this.registryId = sourceUri;
            if (enableCaching) {
                this.setCachingEnabled(context);
            }
            HashMap<String, String> connectionProperties = new HashMap<String, String>();
            if (!enableCaching) {
                connectionProperties.put("Cache-Control", "no-cache");
            } else {
                long l = DEFAULT_MAX_STALE_CACHE;
                connectionProperties.put("Cache-Control", new StringBuilder(30).append("max-stale=").append(l).toString());
            }
            this.inputStreamCreator = LoadHelper.fromUri((Context)context, (Uri)((Uri)Preconditions.checkNotNull((Object)this.sourceUri)), connectionProperties);
            return this.getSelf();
        }

        private CompletableFuture<T> loadRenderableFromGltf(@NonNull Context context, T renderable, @Nullable byte[] materialsBytes) {
            return null;
        }

        private void setCachingEnabled(Context context) {
        }

        protected abstract T makeRenderable();

        protected abstract Class<T> getRenderableClass();

        protected abstract ResourceRegistry<T> getRenderableRegistry();

        protected abstract B getSelf();
    }
}

