/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.util.Log;
import com.google.ar.core.Frame;
import com.google.ar.core.HitResult;
import com.google.ar.core.Plane;
import com.google.ar.core.Pose;
import com.google.ar.core.Trackable;
import com.google.ar.core.TrackingState;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.Material;
import com.google.ar.sceneform.rendering.PlaneVisualizer;
import com.google.ar.sceneform.rendering.R;
import com.google.ar.sceneform.rendering.Renderer;
import com.google.ar.sceneform.rendering.Texture;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class PlaneRenderer {
    private static final String TAG = PlaneRenderer.class.getSimpleName();
    public static final String MATERIAL_TEXTURE = "texture";
    public static final String MATERIAL_UV_SCALE = "uvScale";
    public static final String MATERIAL_COLOR = "color";
    public static final String MATERIAL_SPOTLIGHT_RADIUS = "radius";
    private static final String MATERIAL_SPOTLIGHT_FOCUS_POINT = "focusPoint";
    private static final float BASE_UV_SCALE = 8.0f;
    private static final float DEFAULT_TEXTURE_WIDTH = 293.0f;
    private static final float DEFAULT_TEXTURE_HEIGHT = 513.0f;
    private static final float SPOTLIGHT_RADIUS = 0.5f;
    private final Renderer renderer;
    private final Map<Plane, PlaneVisualizer> visualizerMap = new HashMap<Plane, PlaneVisualizer>();
    private CompletableFuture<Material> planeMaterialFuture;
    private Material shadowMaterial;
    private boolean isEnabled = true;
    private boolean isVisible = true;
    private boolean isShadowReceiver = true;
    private final Map<Plane, Material> materialOverrides = new HashMap<Plane, Material>();
    private float lastPlaneHitDistance = 4.0f;

    public void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            for (PlaneVisualizer visualizer : this.visualizerMap.values()) {
                visualizer.setEnabled(this.isEnabled);
            }
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setShadowReceiver(boolean shadowReceiver) {
        if (this.isShadowReceiver != shadowReceiver) {
            this.isShadowReceiver = shadowReceiver;
            for (PlaneVisualizer visualizer : this.visualizerMap.values()) {
                visualizer.setShadowReceiver(this.isShadowReceiver);
            }
        }
    }

    public boolean isShadowReceiver() {
        return this.isShadowReceiver;
    }

    public void setVisible(boolean visible) {
        if (this.isVisible != visible) {
            this.isVisible = visible;
            for (PlaneVisualizer visualizer : this.visualizerMap.values()) {
                visualizer.setVisible(this.isVisible);
            }
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public CompletableFuture<Material> getMaterial() {
        return this.planeMaterialFuture;
    }

    public PlaneRenderer(Renderer renderer) {
        this.renderer = renderer;
        this.loadPlaneMaterial();
        this.loadShadowMaterial();
    }

    public void update(Frame frame, int viewWidth, int viewHeight) {
        Collection updatedPlanes = frame.getUpdatedTrackables(Plane.class);
        Vector3 focusPoint = this.getFocusPoint(frame, viewWidth, viewHeight);
        Material planeMaterial = this.planeMaterialFuture.getNow(null);
        if (planeMaterial != null) {
            planeMaterial.setFloat3(MATERIAL_SPOTLIGHT_FOCUS_POINT, focusPoint);
            planeMaterial.setFloat(MATERIAL_SPOTLIGHT_RADIUS, 0.5f);
        }
        for (Plane plane : updatedPlanes) {
            PlaneVisualizer planeVisualizer;
            if (this.visualizerMap.containsKey(plane)) {
                planeVisualizer = this.visualizerMap.get(plane);
            } else {
                planeVisualizer = new PlaneVisualizer(plane, this.renderer);
                Material overrideMaterial = this.materialOverrides.get(plane);
                if (overrideMaterial != null) {
                    planeVisualizer.setPlaneMaterial(overrideMaterial);
                } else if (planeMaterial != null) {
                    planeVisualizer.setPlaneMaterial(planeMaterial);
                }
                if (this.shadowMaterial != null) {
                    planeVisualizer.setShadowMaterial(this.shadowMaterial);
                }
                planeVisualizer.setShadowReceiver(this.isShadowReceiver);
                planeVisualizer.setVisible(this.isVisible);
                planeVisualizer.setEnabled(this.isEnabled);
                this.visualizerMap.put(plane, planeVisualizer);
            }
            planeVisualizer.updatePlane();
        }
        Iterator<Map.Entry<Plane, PlaneVisualizer>> iter = this.visualizerMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Plane, PlaneVisualizer> entry = iter.next();
            Plane plane = entry.getKey();
            PlaneVisualizer planeVisualizer = entry.getValue();
            if (plane.getSubsumedBy() == null && plane.getTrackingState() != TrackingState.STOPPED) continue;
            planeVisualizer.release();
            iter.remove();
        }
    }

    private void loadShadowMaterial() {
        ((CompletableFuture)Material.builder().setSource(this.renderer.getContext(), R.raw.sceneform_plane_shadow_material).build().thenAccept(material -> {
            this.shadowMaterial = material;
            for (PlaneVisualizer visualizer : this.visualizerMap.values()) {
                visualizer.setShadowMaterial(this.shadowMaterial);
            }
        })).exceptionally(throwable -> {
            Log.e((String)TAG, (String)"Unable to load plane shadow material.", (Throwable)throwable);
            return null;
        });
    }

    private void loadPlaneMaterial() {
        Texture.Sampler sampler = Texture.Sampler.builder().setMinMagFilter(Texture.Sampler.MagFilter.LINEAR).setWrapMode(Texture.Sampler.WrapMode.REPEAT).build();
        CompletableFuture<Texture> textureFuture = Texture.builder().setSource(this.renderer.getContext(), R.drawable.sceneform_plane).setSampler(sampler).build();
        this.planeMaterialFuture = Material.builder().setSource(this.renderer.getContext(), R.raw.sceneform_plane_material).build().thenCombine(textureFuture, (material, texture) -> {
            material.setTexture(MATERIAL_TEXTURE, (Texture)texture);
            material.setFloat3(MATERIAL_COLOR, 1.0f, 1.0f, 1.0f);
            float widthToHeightRatio = 0.5711501f;
            float scaleX = 8.0f;
            float scaleY = scaleX * widthToHeightRatio;
            material.setFloat2(MATERIAL_UV_SCALE, scaleX, scaleY);
            for (Map.Entry<Plane, PlaneVisualizer> entry : this.visualizerMap.entrySet()) {
                if (this.materialOverrides.containsKey(entry.getKey())) continue;
                entry.getValue().setPlaneMaterial((Material)material);
            }
            return material;
        });
    }

    private Vector3 getFocusPoint(Frame frame, int width, int height) {
        List hits = frame.hitTest((float)(width / 2), (float)(height / 2));
        if (hits != null && !hits.isEmpty()) {
            for (HitResult hit : hits) {
                Trackable trackable = hit.getTrackable();
                Pose hitPose = hit.getHitPose();
                if (!(trackable instanceof Plane) || !((Plane)trackable).isPoseInPolygon(hitPose)) continue;
                Vector3 focusPoint = new Vector3(hitPose.tx(), hitPose.ty(), hitPose.tz());
                this.lastPlaneHitDistance = hit.getDistance();
                return focusPoint;
            }
        }
        Pose cameraPose = frame.getCamera().getPose();
        Vector3 cameraPosition = new Vector3(cameraPose.tx(), cameraPose.ty(), cameraPose.tz());
        float[] zAxis = cameraPose.getZAxis();
        Vector3 backwards = new Vector3(zAxis[0], zAxis[1], zAxis[2]);
        Vector3 focusPoint = Vector3.add((Vector3)cameraPosition, (Vector3)backwards.scaled(-this.lastPlaneHitDistance));
        return focusPoint;
    }
}

