/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import com.google.ar.sceneform.rendering.AnimationData;
import com.google.ar.sceneform.rendering.Renderable;
import com.google.ar.sceneform.rendering.ResourceManager;
import com.google.ar.sceneform.rendering.SkeletonRig;
import com.google.ar.sceneform.resources.ResourceRegistry;
import com.google.ar.sceneform.utilities.AndroidPreconditions;
import java.util.ArrayList;

@RequiresApi(api=24)
public class ModelRenderable
extends Renderable {
    @Nullable
    private ArrayList<AnimationData> animationData = null;
    @Nullable
    private SkeletonRig skeletonRig;

    private ModelRenderable(Builder builder) {
        super(builder);
    }

    private ModelRenderable(ModelRenderable other) {
        super(other);
        this.copyAnimationFrom(other);
    }

    public String getBoneName(int boneIndex) {
        if (this.skeletonRig != null) {
            return this.skeletonRig.getBoneName(boneIndex);
        }
        return "";
    }

    public int getBoneParentIndex(int boneIndex) {
        if (this.skeletonRig != null) {
            return this.skeletonRig.getBoneParentIndex(boneIndex);
        }
        return -1;
    }

    public int getBoneCount() {
        if (this.skeletonRig != null) {
            return this.skeletonRig.getBoneCount();
        }
        return 0;
    }

    private void copyAnimationFrom(ModelRenderable other) {
        if (other.skeletonRig != null) {
            this.skeletonRig = other.skeletonRig.makeCopy();
        }
        if (other.animationData != null) {
            this.animationData = new ArrayList<AnimationData>(other.animationData);
        }
    }

    @Override
    public ModelRenderable makeCopy() {
        return new ModelRenderable(this);
    }

    public static Builder builder() {
        AndroidPreconditions.checkMinAndroidApiLevel();
        return new Builder();
    }

    @Nullable
    SkeletonRig getSkeletonRig() {
        return this.skeletonRig;
    }

    @Nullable
    public AnimationData getAnimationData(String name) {
        if (this.animationData == null) {
            return null;
        }
        for (AnimationData animation : this.animationData) {
            if (!animation.getName().equals(name)) continue;
            return animation;
        }
        return null;
    }

    public AnimationData getAnimationData(int index) {
        if (this.animationData == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.animationData.get(index);
    }

    public int getAnimationDataCount() {
        return this.animationData == null ? 0 : this.animationData.size();
    }

    public void onAnimationEngineUpdated() {
        if (this.skeletonRig != null) {
            this.skeletonRig.updateBoneTransforms();
        }
    }

    void setAnimationData(@Nullable ArrayList<AnimationData> animationData) {
        this.animationData = animationData;
    }

    void setSkeletonRig(@Nullable SkeletonRig skeleton) {
        this.skeletonRig = skeleton;
    }

    public static final class Builder
    extends Renderable.Builder<ModelRenderable, Builder> {
        @Override
        protected ModelRenderable makeRenderable() {
            return new ModelRenderable(this);
        }

        @Override
        protected Class<ModelRenderable> getRenderableClass() {
            return ModelRenderable.class;
        }

        @Override
        protected ResourceRegistry<ModelRenderable> getRenderableRegistry() {
            return ResourceManager.getInstance().getModelRenderableRegistry();
        }

        @Override
        protected Builder getSelf() {
            return this;
        }
    }
}

