/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.Nullable;
import com.google.android.filament.Material;
import com.google.ar.sceneform.rendering.EngineInstance;
import com.google.ar.sceneform.rendering.IEngine;
import com.google.ar.sceneform.rendering.MaterialInternalData;
import com.google.ar.sceneform.utilities.AndroidPreconditions;

class MaterialInternalDataImpl
extends MaterialInternalData {
    @Nullable
    private Material filamentMaterial;

    MaterialInternalDataImpl(Material filamentMaterial) {
        this.filamentMaterial = filamentMaterial;
    }

    @Override
    Material getFilamentMaterial() {
        if (this.filamentMaterial == null) {
            throw new IllegalStateException("Filament Material is null.");
        }
        return this.filamentMaterial;
    }

    protected void onDispose() {
        AndroidPreconditions.checkUiThread();
        IEngine engine = EngineInstance.getEngine();
        Material material = this.filamentMaterial;
        this.filamentMaterial = null;
        if (material != null && engine != null && engine.isValid()) {
            engine.destroyMaterial(material);
        }
    }
}

