/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.content.Context;
import android.support.annotation.RequiresApi;
import com.google.ar.sceneform.rendering.Color;
import com.google.ar.sceneform.rendering.Material;
import com.google.ar.sceneform.rendering.R;
import com.google.ar.sceneform.rendering.Texture;
import java.util.concurrent.CompletableFuture;

@RequiresApi(api=24)
public final class MaterialFactory {
    public static final String MATERIAL_COLOR = "color";
    public static final String MATERIAL_TEXTURE = "texture";
    public static final String MATERIAL_METALLIC = "metallic";
    public static final String MATERIAL_ROUGHNESS = "roughness";
    public static final String MATERIAL_REFLECTANCE = "reflectance";
    private static final float DEFAULT_METALLIC_PROPERTY = 0.0f;
    private static final float DEFAULT_ROUGHNESS_PROPERTY = 0.4f;
    private static final float DEFAULT_REFLECTANCE_PROPERTY = 0.5f;

    public static CompletableFuture<Material> makeOpaqueWithColor(Context context, Color color) {
        CompletableFuture<Material> materialFuture = Material.builder().setSource(context, R.raw.sceneform_opaque_colored_material).build();
        return materialFuture.thenApply(material -> {
            material.setFloat3(MATERIAL_COLOR, color);
            MaterialFactory.applyDefaultPbrParams(material);
            return material;
        });
    }

    public static CompletableFuture<Material> makeTransparentWithColor(Context context, Color color) {
        CompletableFuture<Material> materialFuture = Material.builder().setSource(context, R.raw.sceneform_transparent_colored_material).build();
        return materialFuture.thenApply(material -> {
            material.setFloat4(MATERIAL_COLOR, color);
            MaterialFactory.applyDefaultPbrParams(material);
            return material;
        });
    }

    public static CompletableFuture<Material> makeOpaqueWithTexture(Context context, Texture texture) {
        CompletableFuture<Material> materialFuture = Material.builder().setSource(context, R.raw.sceneform_opaque_textured_material).build();
        return materialFuture.thenApply(material -> {
            material.setTexture(MATERIAL_TEXTURE, texture);
            MaterialFactory.applyDefaultPbrParams(material);
            return material;
        });
    }

    public static CompletableFuture<Material> makeTransparentWithTexture(Context context, Texture texture) {
        CompletableFuture<Material> materialFuture = Material.builder().setSource(context, R.raw.sceneform_transparent_textured_material).build();
        return materialFuture.thenApply(material -> {
            material.setTexture(MATERIAL_TEXTURE, texture);
            MaterialFactory.applyDefaultPbrParams(material);
            return material;
        });
    }

    private static void applyDefaultPbrParams(Material material) {
        material.setFloat(MATERIAL_METALLIC, 0.0f);
        material.setFloat(MATERIAL_ROUGHNESS, 0.4f);
        material.setFloat(MATERIAL_REFLECTANCE, 0.5f);
    }
}

