/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import com.google.android.filament.Material;
import com.google.android.filament.MaterialInstance;
import com.google.ar.sceneform.assets.ModelData;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.Color;
import com.google.ar.sceneform.rendering.EngineInstance;
import com.google.ar.sceneform.rendering.ExternalTexture;
import com.google.ar.sceneform.rendering.FutureHelper;
import com.google.ar.sceneform.rendering.IEngine;
import com.google.ar.sceneform.rendering.MaterialInternalData;
import com.google.ar.sceneform.rendering.MaterialInternalDataGltfImpl;
import com.google.ar.sceneform.rendering.MaterialInternalDataImpl;
import com.google.ar.sceneform.rendering.MaterialParameters;
import com.google.ar.sceneform.rendering.ResourceManager;
import com.google.ar.sceneform.rendering.Texture;
import com.google.ar.sceneform.rendering.ThreadPools;
import com.google.ar.sceneform.resources.ResourceRegistry;
import com.google.ar.sceneform.utilities.AndroidPreconditions;
import com.google.ar.sceneform.utilities.LoadHelper;
import com.google.ar.sceneform.utilities.Preconditions;
import com.google.ar.sceneform.utilities.SceneformBufferUtils;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

@RequiresApi(api=24)
public class Material {
    private static final String TAG = Material.class.getSimpleName();
    private final MaterialParameters materialParameters = new MaterialParameters();
    @Nullable
    private final MaterialInternalData materialData;
    private final IMaterialInstance internalMaterialInstance;

    public Material makeCopy() {
        return new Material(this);
    }

    public void setBoolean(String name, boolean x) {
        this.materialParameters.setBoolean(name, x);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setBoolean2(String name, boolean x, boolean y) {
        this.materialParameters.setBoolean2(name, x, y);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setBoolean3(String name, boolean x, boolean y, boolean z) {
        this.materialParameters.setBoolean3(name, x, y, z);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setBoolean4(String name, boolean x, boolean y, boolean z, boolean w) {
        this.materialParameters.setBoolean4(name, x, y, z, w);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setFloat(String name, float x) {
        this.materialParameters.setFloat(name, x);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setFloat2(String name, float x, float y) {
        this.materialParameters.setFloat2(name, x, y);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setFloat3(String name, float x, float y, float z) {
        this.materialParameters.setFloat3(name, x, y, z);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setFloat3(String name, Vector3 value) {
        this.materialParameters.setFloat3(name, value);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setFloat3(String name, Color color) {
        this.materialParameters.setFloat3(name, color.r, color.g, color.b);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setFloat4(String name, float x, float y, float z, float w) {
        this.materialParameters.setFloat4(name, x, y, z, w);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setFloat4(String name, Color color) {
        this.materialParameters.setFloat4(name, color.r, color.g, color.b, color.a);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setInt(String name, int x) {
        this.materialParameters.setInt(name, x);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setInt2(String name, int x, int y) {
        this.materialParameters.setInt2(name, x, y);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setInt3(String name, int x, int y, int z) {
        this.materialParameters.setInt3(name, x, y, z);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setInt4(String name, int x, int y, int z, int w) {
        this.materialParameters.setInt4(name, x, y, z, w);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setTexture(String name, Texture texture) {
        this.materialParameters.setTexture(name, texture);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    public void setExternalTexture(String name, ExternalTexture externalTexture) {
        this.materialParameters.setExternalTexture(name, externalTexture);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    @Nullable
    public ExternalTexture getExternalTexture(String name) {
        return this.materialParameters.getExternalTexture(name);
    }

    public static Builder builder() {
        AndroidPreconditions.checkMinAndroidApiLevel();
        return new Builder();
    }

    void copyMaterialParameters(MaterialParameters materialParameters) {
        this.materialParameters.copyFrom(materialParameters);
        if (this.internalMaterialInstance.isValidInstance()) {
            this.materialParameters.applyTo(this.internalMaterialInstance.getInstance());
        }
    }

    void copyMaterialParameters(ModelData modelData, int materialIndex) {
        MaterialParameters params = (MaterialParameters)Material.nGetMaterialParameters(modelData.getNativeHandle(), materialIndex);
        this.materialParameters.copyFrom(params);
    }

    private static native Object nGetMaterialParameters(long var0, int var2);

    MaterialInstance getFilamentMaterialInstance() {
        if (!this.internalMaterialInstance.isValidInstance()) {
            throw new AssertionError((Object)"Filament Material Instance is null.");
        }
        return this.internalMaterialInstance.getInstance();
    }

    private Material(MaterialInternalData materialData) {
        this.materialData = materialData;
        materialData.retain();
        this.internalMaterialInstance = materialData instanceof MaterialInternalDataImpl ? new InternalMaterialInstance(materialData.getFilamentMaterial().createInstance()) : new InternalGltfMaterialInstance();
        ResourceManager.getInstance().getMaterialCleanupRegistry().register(this, new CleanupCallback(this.internalMaterialInstance, materialData));
    }

    void updateGltfMaterialInstance(MaterialInstance instance) {
        if (this.internalMaterialInstance instanceof InternalGltfMaterialInstance) {
            ((InternalGltfMaterialInstance)this.internalMaterialInstance).setMaterialInstance(instance);
            this.materialParameters.applyTo(instance);
        }
    }

    private Material(Material other) {
        this(other.materialData);
        this.copyMaterialParameters(other.materialParameters);
    }

    private static final class CleanupCallback
    implements Runnable {
        @Nullable
        private final MaterialInternalData materialInternalData;
        @Nullable
        private final IMaterialInstance materialInstance;

        CleanupCallback(@Nullable IMaterialInstance materialInstance, @Nullable MaterialInternalData materialInternalData) {
            this.materialInstance = materialInstance;
            this.materialInternalData = materialInternalData;
        }

        @Override
        public void run() {
            AndroidPreconditions.checkUiThread();
            if (this.materialInstance != null) {
                this.materialInstance.dispose();
            }
            if (this.materialInternalData != null) {
                this.materialInternalData.release();
            }
        }
    }

    static class InternalGltfMaterialInstance
    implements IMaterialInstance {
        MaterialInstance instance;

        void setMaterialInstance(MaterialInstance instance) {
            this.instance = instance;
        }

        @Override
        public MaterialInstance getInstance() {
            return (MaterialInstance)Preconditions.checkNotNull((Object)this.instance);
        }

        @Override
        public boolean isValidInstance() {
            return this.instance != null;
        }

        @Override
        public void dispose() {
        }
    }

    static class InternalMaterialInstance
    implements IMaterialInstance {
        final MaterialInstance instance;

        public InternalMaterialInstance(MaterialInstance instance) {
            this.instance = instance;
        }

        @Override
        public MaterialInstance getInstance() {
            return this.instance;
        }

        @Override
        public boolean isValidInstance() {
            return this.instance != null;
        }

        @Override
        public void dispose() {
            IEngine engine = EngineInstance.getEngine();
            if (engine != null && engine.isValid()) {
                engine.destroyMaterialInstance(this.instance);
            }
        }
    }

    static interface IMaterialInstance {
        public MaterialInstance getInstance();

        public boolean isValidInstance();

        public void dispose();
    }

    public static final class Builder {
        @Nullable
        ByteBuffer sourceBuffer;
        @Nullable
        private Callable<InputStream> inputStreamCreator;
        com.google.android.filament.Material existingMaterial;
        @Nullable
        private Object registryId;

        private Builder() {
        }

        public Builder setSource(ByteBuffer materialBuffer) {
            Preconditions.checkNotNull((Object)materialBuffer, (Object)"Parameter \"materialBuffer\" was null.");
            this.inputStreamCreator = null;
            this.sourceBuffer = materialBuffer;
            return this;
        }

        public Builder setSource(Context context, Uri sourceUri) {
            Preconditions.checkNotNull((Object)sourceUri, (Object)"Parameter \"sourceUri\" was null.");
            this.registryId = sourceUri;
            this.inputStreamCreator = LoadHelper.fromUri((Context)context, (Uri)sourceUri);
            this.sourceBuffer = null;
            return this;
        }

        public Builder setSource(Context context, int resource) {
            this.registryId = context.getResources().getResourceName(resource);
            this.inputStreamCreator = LoadHelper.fromResource((Context)context, (int)resource);
            this.sourceBuffer = null;
            return this;
        }

        public Builder setSource(Callable<InputStream> inputStreamCreator) {
            Preconditions.checkNotNull(inputStreamCreator, (Object)"Parameter \"sourceInputStreamCallable\" was null.");
            this.inputStreamCreator = inputStreamCreator;
            this.sourceBuffer = null;
            return this;
        }

        public Builder setRegistryId(Object registryId) {
            this.registryId = registryId;
            return this;
        }

        public CompletableFuture<Material> build() {
            CompletableFuture<Material> result;
            Material material2;
            MaterialInternalData materialData;
            ResourceRegistry<Material> registry;
            CompletableFuture materialFuture;
            try {
                this.checkPreconditions();
            }
            catch (Throwable failedPrecondition) {
                CompletableFuture<Material> result2 = new CompletableFuture<Material>();
                result2.completeExceptionally(failedPrecondition);
                String string = String.valueOf(this.registryId);
                FutureHelper.logOnException(TAG, result2, new StringBuilder(37 + String.valueOf(string).length()).append("Unable to load Material registryId='").append(string).append("'").toString());
                return result2;
            }
            Object registryId = this.registryId;
            if (registryId != null && (materialFuture = (registry = ResourceManager.getInstance().getMaterialRegistry()).get(registryId)) != null) {
                return materialFuture.thenApply(material -> material.makeCopy());
            }
            if (this.sourceBuffer != null) {
                materialData = new MaterialInternalDataImpl(this.createFilamentMaterial(this.sourceBuffer));
                material2 = new Material(materialData);
                if (registryId != null) {
                    ResourceRegistry<Material> registry2 = ResourceManager.getInstance().getMaterialRegistry();
                    registry2.register(registryId, CompletableFuture.completedFuture(material2));
                }
                CompletableFuture<Material> result3 = CompletableFuture.completedFuture(material2.makeCopy());
                String string = String.valueOf(registryId);
                FutureHelper.logOnException(TAG, result3, new StringBuilder(37 + String.valueOf(string).length()).append("Unable to load Material registryId='").append(string).append("'").toString());
                return result3;
            }
            if (this.existingMaterial != null) {
                materialData = new MaterialInternalDataGltfImpl(this.existingMaterial);
                material2 = new Material(materialData);
                if (registryId != null) {
                    ResourceRegistry<Material> registry3 = ResourceManager.getInstance().getMaterialRegistry();
                    registry3.register(registryId, CompletableFuture.completedFuture(material2.makeCopy()));
                }
                CompletableFuture<Material> result4 = CompletableFuture.completedFuture(material2);
                String string = String.valueOf(registryId);
                FutureHelper.logOnException(TAG, result4, new StringBuilder(37 + String.valueOf(string).length()).append("Unable to load Material registryId='").append(string).append("'").toString());
                return result4;
            }
            Callable<InputStream> inputStreamCallable = this.inputStreamCreator;
            if (inputStreamCallable == null) {
                result = new CompletableFuture();
                result.completeExceptionally((Throwable)((Object)new AssertionError((Object)"Input Stream Creator is null.")));
                return result;
            }
            result = CompletableFuture.supplyAsync(() -> {
                ByteBuffer byteBuffer;
                try (InputStream inputStream = (InputStream)inputStreamCallable.call();){
                    byteBuffer = SceneformBufferUtils.readStream((InputStream)inputStream);
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
                if (byteBuffer == null) {
                    throw new IllegalStateException("Unable to read data from input stream.");
                }
                return byteBuffer;
            }, ThreadPools.getThreadPoolExecutor()).thenApplyAsync(byteBuffer -> {
                MaterialInternalDataImpl materialData = new MaterialInternalDataImpl(this.createFilamentMaterial((ByteBuffer)byteBuffer));
                Material material = new Material(materialData);
                return material;
            }, ThreadPools.getMainExecutor());
            if (registryId != null) {
                ResourceRegistry<Material> registry4 = ResourceManager.getInstance().getMaterialRegistry();
                registry4.register(registryId, result);
            }
            return result.thenApply(material -> material.makeCopy());
        }

        private void checkPreconditions() {
            AndroidPreconditions.checkUiThread();
            if (!this.hasSource().booleanValue()) {
                throw new AssertionError((Object)"Material must have a source.");
            }
        }

        private Boolean hasSource() {
            return this.inputStreamCreator != null || this.sourceBuffer != null || this.existingMaterial != null;
        }

        private com.google.android.filament.Material createFilamentMaterial(ByteBuffer sourceBuffer) {
            try {
                return new Material.Builder().payload((Buffer)sourceBuffer, sourceBuffer.limit()).build(EngineInstance.getEngine().getFilamentEngine());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to create material from source byte buffer.", e);
            }
        }
    }
}

