/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.net.Uri;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.filament.IndexBuffer;
import com.google.android.filament.TextureSampler;
import com.google.android.filament.VertexBuffer;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.AnimationData;
import com.google.ar.sceneform.rendering.EngineInstance;
import com.google.ar.sceneform.rendering.IEngine;
import com.google.ar.sceneform.rendering.IRenderableInternalData;
import com.google.ar.sceneform.rendering.LullModel;
import com.google.ar.sceneform.rendering.Material;
import com.google.ar.sceneform.rendering.MaterialParameters;
import com.google.ar.sceneform.rendering.ModelRenderable;
import com.google.ar.sceneform.rendering.Renderable;
import com.google.ar.sceneform.rendering.RenderableInternalData;
import com.google.ar.sceneform.rendering.SceneformBundle;
import com.google.ar.sceneform.rendering.SkeletonRig;
import com.google.ar.sceneform.rendering.Texture;
import com.google.ar.sceneform.rendering.ThreadPools;
import com.google.ar.sceneform.utilities.Preconditions;
import com.google.ar.sceneform.utilities.SceneformBufferUtils;
import com.google.ar.schemas.lull.ModelDef;
import com.google.ar.schemas.lull.ModelIndexRange;
import com.google.ar.schemas.lull.ModelInstanceDef;
import com.google.ar.schemas.lull.SkeletonDef;
import com.google.ar.schemas.lull.Vec3;
import com.google.ar.schemas.lull.VertexAttribute;
import com.google.ar.schemas.sceneform.BoolInit;
import com.google.ar.schemas.sceneform.BoolVec2Init;
import com.google.ar.schemas.sceneform.BoolVec3Init;
import com.google.ar.schemas.sceneform.BoolVec4Init;
import com.google.ar.schemas.sceneform.CompiledMaterialDef;
import com.google.ar.schemas.sceneform.IntInit;
import com.google.ar.schemas.sceneform.IntVec2Init;
import com.google.ar.schemas.sceneform.IntVec3Init;
import com.google.ar.schemas.sceneform.IntVec4Init;
import com.google.ar.schemas.sceneform.MaterialDef;
import com.google.ar.schemas.sceneform.ParameterDef;
import com.google.ar.schemas.sceneform.ParameterInitDef;
import com.google.ar.schemas.sceneform.SamplerDef;
import com.google.ar.schemas.sceneform.SamplerInit;
import com.google.ar.schemas.sceneform.ScalarInit;
import com.google.ar.schemas.sceneform.SceneformBundleDef;
import com.google.ar.schemas.sceneform.TransformDef;
import com.google.ar.schemas.sceneform.Vec2Init;
import com.google.ar.schemas.sceneform.Vec3Init;
import com.google.ar.schemas.sceneform.Vec4Init;
import com.google.flatbuffers.Table;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;

class LoadRenderableFromSfbTask<T extends Renderable> {
    private static final String TAG = LoadRenderableFromSfbTask.class.getSimpleName();
    private final T renderable;
    private final RenderableInternalData renderableData;
    @Nullable
    private final Uri renderableUri;
    private ModelDef modelDef;
    private ModelInstanceDef modelInstanceDef;
    private TransformDef transformDef;
    private int meshCount;
    private int textureCount;
    private int vertexCount;
    private int vertexStride;
    private int indexCount;
    private IndexBuffer.Builder.IndexType indexType;
    private ByteBuffer vertexBufferData;
    private ByteBuffer indexBufferData;
    private final ArrayList<ModelTexture> textures = new ArrayList();
    private final ArrayList<Material> compiledMaterials = new ArrayList();
    private final ArrayList<Integer> compiledMaterialIndex = new ArrayList();
    private final ArrayList<MaterialParameters> materialParameters = new ArrayList();
    private final ArrayList<String> materialNames = new ArrayList();
    private static final int BYTES_PER_FLOAT = 4;
    private static final int BYTES_PER_SHORT = 2;
    private static final int BYTES_PER_INT = 4;

    LoadRenderableFromSfbTask(T renderable, @Nullable Uri renderableUri) {
        this.renderable = renderable;
        IRenderableInternalData data = ((Renderable)renderable).getRenderableData();
        if (!(data instanceof RenderableInternalData)) {
            String string = String.valueOf(TAG);
            throw new IllegalStateException(string.length() != 0 ? "Expected task type ".concat(string) : new String("Expected task type "));
        }
        this.renderableData = (RenderableInternalData)data;
        this.renderableUri = renderableUri;
    }

    public CompletableFuture<T> downloadAndProcessRenderable(Callable<InputStream> inputStreamCreator) {
        CompletionStage result = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            ByteBuffer assetData = SceneformBufferUtils.inputStreamToByteBuffer((Callable)inputStreamCreator);
            SceneformBundleDef sfb = this.byteBufferToSfb(assetData);
            this.setCollisionShape(sfb);
            this.loadModel(sfb);
            return sfb;
        }, ThreadPools.getThreadPoolExecutor()).thenComposeAsync(sfb -> {
            this.loadAnimations((SceneformBundleDef)sfb);
            return this.loadTexturesAsync((SceneformBundleDef)sfb);
        }, ThreadPools.getMainExecutor())).thenApplyAsync(sfb -> {
            this.buildMaterialParameters((SceneformBundleDef)sfb);
            return this.setupFilament((SceneformBundleDef)sfb);
        }, ThreadPools.getMainExecutor());
        ((CompletableFuture)result).exceptionally(throwable -> {
            throw new CompletionException((Throwable)throwable);
        });
        return result;
    }

    private void loadAnimations(SceneformBundleDef sfb) {
        if (this.renderable instanceof ModelRenderable && sfb.animationsLength() > 0) {
            ModelRenderable modelRenderable = (ModelRenderable)this.renderable;
            ArrayList<AnimationData> animationData = new ArrayList<AnimationData>();
            for (int i = 0; i < sfb.animationsLength(); ++i) {
                byte[] bytes;
                ByteBuffer byteBuffer = sfb.animations(i).dataAsByteBuffer();
                try {
                    bytes = SceneformBufferUtils.copyByteBufferToArray((ByteBuffer)byteBuffer);
                }
                catch (IOException e) {
                    throw new CompletionException("Failed to create animation data.", e);
                }
                AnimationData data = AnimationData.createInstance(bytes, sfb.animations(i).name());
                if (data == null) continue;
                animationData.add(data);
            }
            modelRenderable.setAnimationData(animationData);
        }
    }

    private SceneformBundleDef byteBufferToSfb(ByteBuffer assetData) {
        try {
            SceneformBundleDef sfb = SceneformBundle.tryLoadSceneformBundle(assetData);
            if (sfb != null) {
                return sfb;
            }
        }
        catch (SceneformBundle.VersionException e) {
            throw new CompletionException(e);
        }
        String string = String.valueOf(this.renderableUri);
        throw new AssertionError((Object)new StringBuilder(20 + String.valueOf(string).length()).append("No RCB file at uri: ").append(string).toString());
    }

    private SceneformBundleDef setCollisionShape(SceneformBundleDef sfb) {
        try {
            ((Renderable)this.renderable).collisionShape = SceneformBundle.readCollisionGeometry(sfb);
            return sfb;
        }
        catch (IOException e) {
            throw new CompletionException("Unable to get collision geometry from sfb", e);
        }
    }

    private SceneformBundleDef loadModel(SceneformBundleDef sfb) {
        this.transformDef = sfb.transform();
        this.modelDef = sfb.model();
        Preconditions.checkNotNull((Object)this.modelDef, (Object)"Model error: ModelDef is invalid.");
        this.modelInstanceDef = this.modelDef.lods(0);
        Preconditions.checkNotNull((Object)this.modelInstanceDef, (Object)"Lull Model error: ModelInstanceDef is invalid.");
        this.buildGeometry();
        return sfb;
    }

    private T setupFilament(SceneformBundleDef sfb) {
        Preconditions.checkNotNull((Object)sfb);
        this.setupFilamentGeometryBuffers();
        this.setupFilamentMaterials(sfb);
        this.setupRenderableData();
        ((Renderable)this.renderable).getId().update();
        return this.renderable;
    }

    private void setupFilamentGeometryBuffers() {
        IEngine engine = EngineInstance.getEngine();
        IndexBuffer indexBuffer = new IndexBuffer.Builder().indexCount(this.indexCount).bufferType(this.indexType).build(engine.getFilamentEngine());
        indexBuffer.setBuffer(engine.getFilamentEngine(), (Buffer)this.indexBufferData);
        this.renderableData.setIndexBuffer(indexBuffer);
        VertexBuffer.Builder vertexBufferBuilder = new VertexBuffer.Builder().vertexCount(this.vertexCount).bufferCount(1);
        int vertexAttributeCount = this.modelInstanceDef.vertexAttributesLength();
        int byteOffset = 0;
        for (int i = 0; i < vertexAttributeCount; ++i) {
            VertexAttribute attribute = this.modelInstanceDef.vertexAttributes(i);
            VertexBuffer.VertexAttribute filamentAttribute = LoadRenderableFromSfbTask.getFilamentVertexAttribute(attribute.usage());
            if (filamentAttribute != null) {
                vertexBufferBuilder.attribute(filamentAttribute, 0, LoadRenderableFromSfbTask.getFilamentAttributeType(attribute.type()), byteOffset, this.vertexStride);
                if (this.isAttributeNormalized(attribute.usage())) {
                    vertexBufferBuilder.normalized(filamentAttribute);
                }
            }
            byteOffset += LoadRenderableFromSfbTask.getVertexAttributeTypeSizeInBytes(attribute.type());
        }
        VertexBuffer vertexBuffer = vertexBufferBuilder.build(engine.getFilamentEngine());
        vertexBuffer.setBufferAt(engine.getFilamentEngine(), 0, (Buffer)this.vertexBufferData);
        this.renderableData.setVertexBuffer(vertexBuffer);
        this.setupAnimation();
    }

    private void setupAnimation() {
        SkeletonDef skeletonDef = this.modelDef.skeleton();
        if (this.renderable instanceof ModelRenderable && skeletonDef.boneTransformsLength() > 0) {
            ModelRenderable modelRenderable = (ModelRenderable)this.renderable;
            modelRenderable.setSkeletonRig(SkeletonRig.createInstance(skeletonDef, this.modelInstanceDef));
        }
    }

    private void setupFilamentMaterials(SceneformBundleDef sfb) {
        int compiledMaterialLength = sfb.compiledMaterialsLength();
        for (int i = 0; i < compiledMaterialLength; ++i) {
            ByteBuffer copy;
            CompiledMaterialDef compiledMaterial = sfb.compiledMaterials(i);
            int materialId = compiledMaterial.compiledMaterialAsByteBuffer().hashCode();
            try {
                copy = SceneformBufferUtils.copyByteBuffer((ByteBuffer)compiledMaterial.compiledMaterialAsByteBuffer());
            }
            catch (IOException e) {
                throw new CompletionException("Failed to create material", e);
            }
            CompletableFuture<Material> materialFuture = Material.builder().setSource(copy).setRegistryId(materialId).build();
            Material material = materialFuture.getNow(null);
            if (material == null) {
                throw new AssertionError((Object)"Material wasn't loaded.");
            }
            this.compiledMaterials.add(material);
        }
    }

    private void setupRenderableData() {
        Vec3 modelMinAabb = this.modelDef.boundingBox().min();
        Vector3 minAabb = new Vector3(modelMinAabb.x(), modelMinAabb.y(), modelMinAabb.z());
        Vec3 modelMaxAabb = this.modelDef.boundingBox().max();
        Vector3 maxAabb = new Vector3(modelMaxAabb.x(), modelMaxAabb.y(), modelMaxAabb.z());
        Vector3 extentsAabb = Vector3.subtract((Vector3)maxAabb, (Vector3)minAabb).scaled(0.5f);
        Vector3 centerAabb = Vector3.add((Vector3)minAabb, (Vector3)extentsAabb);
        this.renderableData.setExtentsAabb(extentsAabb);
        this.renderableData.setCenterAabb(centerAabb);
        if (this.transformDef != null && this.transformDef.scale() != 0.0f) {
            Vec3 modelOffset = this.transformDef.offset();
            Vector3 offset = new Vector3(modelOffset.x(), modelOffset.y(), modelOffset.z());
            this.renderableData.setTransformScale(this.transformDef.scale());
            this.renderableData.setTransformOffset(offset);
        }
        ArrayList<Material> materialBindings = ((Renderable)this.renderable).getMaterialBindings();
        ArrayList<String> renderableMaterialNames = ((Renderable)this.renderable).getMaterialNames();
        materialBindings.clear();
        renderableMaterialNames.clear();
        for (int m = 0; m < this.meshCount; ++m) {
            ModelIndexRange range = this.modelInstanceDef.ranges(m);
            int start = (int)range.start();
            int end = (int)range.end();
            int materialIndex = this.compiledMaterialIndex.get(m);
            Material material = this.compiledMaterials.get(materialIndex).makeCopy();
            MaterialParameters params = this.materialParameters.get(m);
            material.copyMaterialParameters(params);
            RenderableInternalData.MeshData meshData = new RenderableInternalData.MeshData();
            materialBindings.add(material);
            renderableMaterialNames.add(this.materialNames.get(m));
            meshData.indexStart = start;
            meshData.indexEnd = end;
            this.renderableData.getMeshes().add(meshData);
        }
    }

    private void buildGeometry() {
        ByteBuffer vertexData = this.modelInstanceDef.vertexDataAsByteBuffer();
        Preconditions.checkNotNull((Object)vertexData, (Object)"Model Instance geometry data is invalid (vertexData is null).");
        int vertexDataCount = this.modelInstanceDef.vertexDataLength();
        this.meshCount = this.modelInstanceDef.rangesLength();
        int bytesPerVertex = LullModel.getByteCountPerVertex(this.modelInstanceDef);
        this.vertexCount = vertexDataCount / bytesPerVertex;
        if (this.modelInstanceDef.indices32Length() > 0) {
            this.indexCount = this.modelInstanceDef.indices32Length();
            this.indexType = IndexBuffer.Builder.IndexType.UINT;
            this.indexBufferData = ByteBuffer.allocateDirect(this.indexCount * 4);
            this.indexBufferData.put(this.modelInstanceDef.indices32AsByteBuffer());
        } else if (this.modelInstanceDef.indices16Length() > 0) {
            this.indexCount = this.modelInstanceDef.indices16Length();
            this.indexType = IndexBuffer.Builder.IndexType.USHORT;
            this.indexBufferData = ByteBuffer.allocateDirect(this.indexCount * 2);
            this.indexBufferData.put(this.modelInstanceDef.indices16AsByteBuffer());
        } else {
            throw new AssertionError((Object)"Model Instance geometry data is invalid (model has no index data).");
        }
        this.indexBufferData.flip();
        this.vertexBufferData = ByteBuffer.allocateDirect(vertexData.remaining());
        Preconditions.checkNotNull((Object)this.vertexBufferData, (Object)"Failed to allocate geometry for FilamentModel.");
        this.vertexBufferData.put(vertexData);
        this.vertexBufferData.flip();
        this.vertexStride = 0;
        int vertexAttributeCount = this.modelInstanceDef.vertexAttributesLength();
        for (int i = 0; i < vertexAttributeCount; ++i) {
            VertexAttribute attribute = this.modelInstanceDef.vertexAttributes(i);
            this.vertexStride += LoadRenderableFromSfbTask.getVertexAttributeTypeSizeInBytes(attribute.type());
        }
    }

    private CompletableFuture<SceneformBundleDef> loadTexturesAsync(SceneformBundleDef sfb) {
        this.textureCount = sfb.samplersLength();
        CompletableFuture[] textureFutures = new CompletableFuture[this.textureCount];
        for (int t = 0; t < this.textureCount; ++t) {
            SamplerDef samplerDef = sfb.samplers(t);
            ModelTexture texture = new ModelTexture(samplerDef.name());
            this.textures.add(texture);
            CompletableFuture<Texture> textureFuture = null;
            int rawUsage = samplerDef.params().usageType();
            Texture.Usage[] usageValues = Texture.Usage.values();
            if (rawUsage >= usageValues.length) {
                throw new AssertionError((Object)new StringBuilder(34).append("Invalid Texture Usage: ").append(rawUsage).toString());
            }
            Texture.Usage usage = usageValues[rawUsage];
            if (samplerDef.dataLength() == 0) {
                throw new IllegalStateException("Unable to load texture, no sampler definition.");
            }
            ByteBuffer data = samplerDef.dataAsByteBuffer();
            ByteArrayInputStream wrappedInputStream = new ByteArrayInputStream(data.array(), data.arrayOffset(), data.capacity());
            boolean premultiplyAlpha = usage == Texture.Usage.COLOR;
            wrappedInputStream.skip(data.position());
            textureFuture = Texture.builder().setUsage(usage).setSampler(LoadRenderableFromSfbTask.samplerDefToSampler(samplerDef)).setPremultiplied(premultiplyAlpha).setSource(() -> {
                Preconditions.checkNotNull((Object)wrappedInputStream);
                return wrappedInputStream;
            }).build();
            textureFutures[t] = ((CompletableFuture)textureFuture.thenAccept(textureData -> {
                texture.data = textureData;
            })).exceptionally(throwable -> {
                throw new CompletionException("Texture Load Error", (Throwable)throwable);
            });
        }
        CompletableFuture<Void> allTexturesFuture = CompletableFuture.allOf(textureFutures);
        return allTexturesFuture.thenApply(unused -> sfb);
    }

    private static Texture.Sampler samplerDefToSampler(SamplerDef samplerDef) {
        Texture.Sampler.WrapMode wrapModeR = LoadRenderableFromSfbTask.filamentWrapModeToWrapMode(TextureSampler.WrapMode.values()[samplerDef.params().wrapR()]);
        Texture.Sampler.WrapMode wrapModeS = LoadRenderableFromSfbTask.filamentWrapModeToWrapMode(TextureSampler.WrapMode.values()[samplerDef.params().wrapS()]);
        Texture.Sampler.WrapMode wrapModeT = LoadRenderableFromSfbTask.filamentWrapModeToWrapMode(TextureSampler.WrapMode.values()[samplerDef.params().wrapT()]);
        return Texture.Sampler.builder().setMinFilter(LoadRenderableFromSfbTask.samplerDefToMinFilter(samplerDef)).setMagFilter(LoadRenderableFromSfbTask.samplerDefToMagFilter(samplerDef)).setWrapModeR(wrapModeR).setWrapModeS(wrapModeS).setWrapModeT(wrapModeT).build();
    }

    private SceneformBundleDef buildMaterialParameters(SceneformBundleDef sfb) {
        int materialsCount = sfb.materialsLength();
        if (materialsCount == 0) {
            Log.i((String)TAG, (String)"Building materials but the sceneform bundle has no materials");
            return sfb;
        }
        for (int m = 0; m < this.meshCount; ++m) {
            MaterialDef materialDef;
            int materialIndex = m;
            if (materialsCount <= m) {
                materialIndex = materialsCount - 1;
            }
            if ((materialDef = sfb.materials(materialIndex)) == null) {
                int n = m;
                Log.e((String)TAG, (String)new StringBuilder(29).append("Material ").append(n).append(" is null.").toString());
                continue;
            }
            this.compiledMaterialIndex.add(materialDef.compiledIndex());
            ParameterDef parameterCache = new ParameterDef();
            ParameterInitDef parameterInitCache = new ParameterInitDef();
            ScalarInit scalarCache = new ScalarInit();
            Vec2Init vec2Cache = new Vec2Init();
            Vec3Init vec3Cache = new Vec3Init();
            Vec4Init vec4Cache = new Vec4Init();
            BoolInit boolCache = new BoolInit();
            BoolVec2Init bool2Cache = new BoolVec2Init();
            BoolVec3Init bool3Cache = new BoolVec3Init();
            BoolVec4Init bool4Cache = new BoolVec4Init();
            IntInit intCache = new IntInit();
            IntVec2Init int2Cache = new IntVec2Init();
            IntVec3Init int3Cache = new IntVec3Init();
            IntVec4Init int4Cache = new IntVec4Init();
            SamplerInit samplerCache = new SamplerInit();
            MaterialParameters materialParameters = new MaterialParameters();
            int paramCount = materialDef.parametersLength();
            block18: for (int i = 0; i < paramCount; ++i) {
                materialDef.parameters(parameterCache, i);
                parameterCache.initialValue(parameterInitCache);
                String id = parameterCache.id();
                byte parameterType = parameterInitCache.initType();
                switch (parameterType) {
                    case 1: {
                        continue block18;
                    }
                    case 2: {
                        parameterInitCache.init((Table)scalarCache);
                        materialParameters.setFloat(id, scalarCache.value());
                        continue block18;
                    }
                    case 6: {
                        parameterInitCache.init((Table)vec2Cache);
                        materialParameters.setFloat2(id, vec2Cache.x(), vec2Cache.y());
                        continue block18;
                    }
                    case 3: {
                        parameterInitCache.init((Table)vec3Cache);
                        materialParameters.setFloat3(id, vec3Cache.x(), vec3Cache.y(), vec3Cache.z());
                        continue block18;
                    }
                    case 4: {
                        parameterInitCache.init((Table)vec4Cache);
                        materialParameters.setFloat4(id, vec4Cache.x(), vec4Cache.y(), vec4Cache.z(), vec4Cache.w());
                        continue block18;
                    }
                    case 7: {
                        parameterInitCache.init((Table)boolCache);
                        materialParameters.setBoolean(id, boolCache.value());
                        continue block18;
                    }
                    case 8: {
                        parameterInitCache.init((Table)bool2Cache);
                        materialParameters.setBoolean2(id, bool2Cache.x(), bool2Cache.y());
                        continue block18;
                    }
                    case 9: {
                        parameterInitCache.init((Table)bool3Cache);
                        materialParameters.setBoolean3(id, bool3Cache.x(), bool3Cache.y(), bool3Cache.z());
                        continue block18;
                    }
                    case 10: {
                        parameterInitCache.init((Table)bool4Cache);
                        materialParameters.setBoolean4(id, bool4Cache.x(), bool4Cache.y(), bool4Cache.z(), bool4Cache.w());
                        continue block18;
                    }
                    case 11: {
                        parameterInitCache.init((Table)intCache);
                        materialParameters.setInt(id, intCache.value());
                        continue block18;
                    }
                    case 12: {
                        parameterInitCache.init((Table)int2Cache);
                        materialParameters.setInt2(id, int2Cache.x(), int2Cache.y());
                        continue block18;
                    }
                    case 13: {
                        parameterInitCache.init((Table)int3Cache);
                        materialParameters.setInt3(id, int3Cache.x(), int3Cache.y(), int3Cache.z());
                        continue block18;
                    }
                    case 14: {
                        parameterInitCache.init((Table)int4Cache);
                        materialParameters.setInt4(id, int4Cache.x(), int4Cache.y(), int4Cache.z(), int4Cache.w());
                        continue block18;
                    }
                    case 5: {
                        parameterInitCache.init((Table)samplerCache);
                        String path = samplerCache.path();
                        Texture texture = this.getTextureByName(path);
                        if (texture == null) continue block18;
                        materialParameters.setTexture(id, texture);
                        continue block18;
                    }
                    case 16: {
                        continue block18;
                    }
                    default: {
                        String string = String.valueOf(id);
                        Log.e((String)TAG, (String)(string.length() != 0 ? "Unknown parameter type: ".concat(string) : new String("Unknown parameter type: ")));
                    }
                }
            }
            this.materialParameters.add(materialParameters);
            String materialName = materialDef.name();
            this.materialNames.add(materialName != null ? materialName : "");
        }
        return sfb;
    }

    @Nullable
    private Texture getTextureByName(String name) {
        for (int t = 0; t < this.textureCount; ++t) {
            if (!Objects.equals(name, this.textures.get((int)t).name)) continue;
            return this.textures.get((int)t).data;
        }
        return null;
    }

    private static int getVertexAttributeTypeSizeInBytes(int attributeType) {
        int sizeInBytes = 0;
        switch (attributeType) {
            case 0: {
                sizeInBytes = 0;
                break;
            }
            case 1: {
                sizeInBytes = 4;
                break;
            }
            case 2: {
                sizeInBytes = 8;
                break;
            }
            case 3: {
                sizeInBytes = 12;
                break;
            }
            case 4: {
                sizeInBytes = 16;
                break;
            }
            case 5: {
                sizeInBytes = 4;
                break;
            }
            case 6: {
                sizeInBytes = 8;
                break;
            }
            case 7: {
                sizeInBytes = 4;
                break;
            }
            default: {
                throw new AssertionError((Object)new StringBuilder(50).append("Unsupported VertexAttributeType value: ").append(attributeType).toString());
            }
        }
        return sizeInBytes;
    }

    private boolean isAttributeNormalized(int attributeUsage) {
        return attributeUsage == 2 || attributeUsage == 8;
    }

    @Nullable
    private static VertexBuffer.VertexAttribute getFilamentVertexAttribute(int attributeUsage) {
        VertexBuffer.VertexAttribute filamentAttribute;
        switch (attributeUsage) {
            case 1: {
                filamentAttribute = VertexBuffer.VertexAttribute.POSITION;
                break;
            }
            case 2: {
                filamentAttribute = VertexBuffer.VertexAttribute.COLOR;
                break;
            }
            case 3: {
                filamentAttribute = VertexBuffer.VertexAttribute.UV0;
                break;
            }
            case 6: {
                filamentAttribute = VertexBuffer.VertexAttribute.TANGENTS;
                break;
            }
            case 7: {
                filamentAttribute = VertexBuffer.VertexAttribute.BONE_INDICES;
                break;
            }
            case 8: {
                filamentAttribute = VertexBuffer.VertexAttribute.BONE_WEIGHTS;
                break;
            }
            default: {
                filamentAttribute = null;
            }
        }
        return filamentAttribute;
    }

    private static VertexBuffer.AttributeType getFilamentAttributeType(int attributeType) {
        VertexBuffer.AttributeType filamentAttributeType;
        switch (attributeType) {
            case 1: {
                filamentAttributeType = VertexBuffer.AttributeType.FLOAT;
                break;
            }
            case 2: {
                filamentAttributeType = VertexBuffer.AttributeType.FLOAT2;
                break;
            }
            case 3: {
                filamentAttributeType = VertexBuffer.AttributeType.FLOAT3;
                break;
            }
            case 4: {
                filamentAttributeType = VertexBuffer.AttributeType.FLOAT4;
                break;
            }
            case 5: {
                filamentAttributeType = VertexBuffer.AttributeType.USHORT2;
                break;
            }
            case 6: {
                filamentAttributeType = VertexBuffer.AttributeType.USHORT4;
                break;
            }
            case 7: {
                filamentAttributeType = VertexBuffer.AttributeType.UBYTE4;
                break;
            }
            default: {
                throw new AssertionError((Object)new StringBuilder(50).append("Unsupported VertexAttributeType value: ").append(attributeType).toString());
            }
        }
        return filamentAttributeType;
    }

    private static Texture.Sampler.MagFilter samplerDefToMagFilter(SamplerDef samplerDef) {
        TextureSampler.MagFilter filamentMagFilter = TextureSampler.MagFilter.values()[samplerDef.params().magFilter()];
        switch (filamentMagFilter) {
            case NEAREST: {
                return Texture.Sampler.MagFilter.NEAREST;
            }
            case LINEAR: {
                return Texture.Sampler.MagFilter.LINEAR;
            }
        }
        throw new IllegalArgumentException("Invalid MagFilter");
    }

    private static Texture.Sampler.MinFilter samplerDefToMinFilter(SamplerDef samplerDef) {
        TextureSampler.MinFilter filamentMinFilter = TextureSampler.MinFilter.values()[samplerDef.params().minFilter()];
        switch (filamentMinFilter) {
            case NEAREST: {
                return Texture.Sampler.MinFilter.NEAREST;
            }
            case LINEAR: {
                return Texture.Sampler.MinFilter.LINEAR;
            }
            case NEAREST_MIPMAP_NEAREST: {
                return Texture.Sampler.MinFilter.NEAREST_MIPMAP_NEAREST;
            }
            case LINEAR_MIPMAP_NEAREST: {
                return Texture.Sampler.MinFilter.LINEAR_MIPMAP_NEAREST;
            }
            case NEAREST_MIPMAP_LINEAR: {
                return Texture.Sampler.MinFilter.NEAREST_MIPMAP_LINEAR;
            }
            case LINEAR_MIPMAP_LINEAR: {
                return Texture.Sampler.MinFilter.LINEAR_MIPMAP_LINEAR;
            }
        }
        throw new IllegalArgumentException("Invalid MinFilter");
    }

    private static Texture.Sampler.WrapMode filamentWrapModeToWrapMode(TextureSampler.WrapMode wrapMode) {
        switch (wrapMode) {
            case CLAMP_TO_EDGE: {
                return Texture.Sampler.WrapMode.CLAMP_TO_EDGE;
            }
            case REPEAT: {
                return Texture.Sampler.WrapMode.REPEAT;
            }
            case MIRRORED_REPEAT: {
                return Texture.Sampler.WrapMode.MIRRORED_REPEAT;
            }
        }
        throw new IllegalArgumentException("Invalid WrapMode");
    }

    private static class ModelTexture {
        String name;
        @Nullable
        Texture data;

        ModelTexture(String name) {
            this.name = name;
            this.data = null;
        }
    }
}

