/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.Image;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.filament.IndirectLight;
import com.google.android.filament.Texture;
import com.google.ar.sceneform.math.Matrix;
import com.google.ar.sceneform.math.Quaternion;
import com.google.ar.sceneform.rendering.Color;
import com.google.ar.sceneform.rendering.EngineInstance;
import com.google.ar.sceneform.rendering.FutureHelper;
import com.google.ar.sceneform.rendering.IEngine;
import com.google.ar.sceneform.rendering.SceneformBundle;
import com.google.ar.sceneform.rendering.ThreadPools;
import com.google.ar.sceneform.utilities.AndroidPreconditions;
import com.google.ar.sceneform.utilities.ChangeId;
import com.google.ar.sceneform.utilities.EnvironmentalHdrParameters;
import com.google.ar.sceneform.utilities.LoadHelper;
import com.google.ar.sceneform.utilities.Preconditions;
import com.google.ar.sceneform.utilities.SceneformBufferUtils;
import com.google.ar.schemas.lull.Vec3;
import com.google.ar.schemas.sceneform.LightingCubeDef;
import com.google.ar.schemas.sceneform.LightingCubeFaceDef;
import com.google.ar.schemas.sceneform.LightingDef;
import com.google.ar.schemas.sceneform.SceneformBundleDef;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;

public class LightProbe {
    private static final String TAG = LightProbe.class.getSimpleName();
    private static final int CUBEMAP_MIN_WIDTH = 4;
    private static final int CUBEMAP_FACE_COUNT = 6;
    private static final int RGBM_BYTES_PER_PIXEL = 4;
    private static final int FLOATS_PER_VECTOR = 3;
    private static final int SH_ORDER = 3;
    private static final int BYTES_PER_FLOAT16 = 2;
    private static final int RGBA_BYTES_PER_PIXEL = 8;
    private static final int RGB_BYTES_PER_PIXEL = 6;
    private static final int RGB_CHANNEL_COUNT = 3;
    private static final float LIGHT_ESTIMATE_SCALE = 1.8f;
    private static final float LIGHT_ESTIMATE_OFFSET = 0.0f;
    private static final int SH_VECTORS_FOR_THIRD_ORDER = 9;
    private static final int[] FACE_TO_FILAMENT_MAPPING = new int[]{3, 0, 4, 1, 5, 2};
    private static final int EXPECTED_SPHERICAL_HARMONICS_LENGTH = 27;
    private static final float[] ENVIRONMENTAL_HDR_TO_FILAMENT_SH_COEFFIECIENTS = new float[]{0.282095f, -0.325735f, 0.325735f, -0.325735f, 0.273137f, -0.273137f, 0.078848f, -0.273137f, 0.136569f};
    private static final int[] ENVIRONMENTAL_HDR_TO_FILAMENT_SH_INDEX_MAP = new int[]{0, 1, 2, 3, 4, 5, 7, 6, 8};
    private ByteBuffer cubemapBuffer = ByteBuffer.allocate(10000);
    @Nullable
    private Texture reflectCubemap = null;
    private final Color colorCorrection = new Color(1.0f, 1.0f, 1.0f);
    private final Color ambientColor = new Color();
    private float[] irradianceData;
    @Nullable
    private String name = null;
    private ChangeId changeId = new ChangeId();
    private float intensity;
    private float lightEstimate = 1.0f;
    @Nullable
    private Quaternion rotation;

    public static Builder builder() {
        return new Builder();
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void setRotation(@Nullable Quaternion rotation) {
        this.rotation = rotation;
    }

    @Nullable
    public Quaternion getRotation() {
        return this.rotation;
    }

    int getId() {
        return this.changeId.get();
    }

    public boolean isReady() {
        return !this.changeId.isEmpty();
    }

    @Nullable
    IndirectLight buildIndirectLight() {
        Preconditions.checkNotNull((Object)this.irradianceData, (Object)"\"irradianceData\" was null.");
        Preconditions.checkState((this.irradianceData.length >= 3 ? 1 : 0) != 0, (Object)"\"irradianceData\" does not have enough components to store a vector");
        if (this.reflectCubemap == null) {
            throw new IllegalStateException("reflectCubemap is null.");
        }
        this.irradianceData[0] = this.ambientColor.r * this.colorCorrection.r;
        this.irradianceData[1] = this.ambientColor.g * this.colorCorrection.g;
        this.irradianceData[2] = this.ambientColor.b * this.colorCorrection.b;
        IndirectLight indirectLight = new IndirectLight.Builder().reflections(this.reflectCubemap).irradiance(3, this.irradianceData).intensity(this.intensity * this.lightEstimate).build(EngineInstance.getEngine().getFilamentEngine());
        if (this.rotation != null) {
            indirectLight.setRotation(LightProbe.quaternionToRotationMatrix(this.rotation));
        }
        if (indirectLight == null) {
            throw new IllegalStateException("Light Probe is invalid.");
        }
        return indirectLight;
    }

    private LightProbe(Builder builder) {
        this.intensity = builder.intensity;
        this.rotation = builder.rotation;
        this.name = builder.name;
    }

    private void buildFilamentResource(LightingDef lightingDef) {
        this.dispose();
        this.changeId.update();
        if (lightingDef == null) {
            throw new IllegalStateException("buildFilamentResource called but no resource is available to load.");
        }
        Texture cubemap = LightProbe.loadReflectCubemapFromLightingDef(lightingDef);
        if (cubemap == null) {
            throw new IllegalStateException("Load reflection cubemap failed.");
        }
        this.setCubeMapFromTexture(cubemap);
        int shVectorCount = lightingDef.shCoefficientsLength();
        if (shVectorCount < 9) {
            throw new IllegalStateException("Too few SH vectors for the current Order (3).");
        }
        int requiredFloatCount = shVectorCount * 3;
        if (this.irradianceData == null || this.irradianceData.length != requiredFloatCount) {
            this.irradianceData = new float[requiredFloatCount];
        }
        for (int v = 0; v < shVectorCount; ++v) {
            Vec3 shVector = lightingDef.shCoefficients(v);
            this.irradianceData[v * 3 + 0] = shVector.x() / (float)Math.PI;
            this.irradianceData[v * 3 + 1] = shVector.y() / (float)Math.PI;
            this.irradianceData[v * 3 + 2] = shVector.z() / (float)Math.PI;
        }
        this.ambientColor.set(this.irradianceData[0], this.irradianceData[1], this.irradianceData[2]);
    }

    protected void finalize() throws Throwable {
        try {
            ThreadPools.getMainExecutor().execute(() -> this.dispose());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error while Finalizing Light Probe.", (Throwable)e);
        }
        finally {
            super.finalize();
        }
    }

    public void dispose() {
        AndroidPreconditions.checkUiThread();
        this.setCubeMapFromTexture(null);
        this.changeId = new ChangeId();
    }

    private void setCubeMapFromTexture(Texture nextCubemap) {
        Texture prevTexture = this.reflectCubemap;
        IEngine engine = EngineInstance.getEngine();
        if (prevTexture != null && engine != null && engine.isValid()) {
            engine.destroyTexture(prevTexture);
        }
        this.reflectCubemap = nextCubemap;
    }

    public void setEnvironmentalHdrSphericalHarmonics(float[] sphericalHarmonics, float exposure, EnvironmentalHdrParameters environmentalHdrParameters) {
        float scaleFactor = environmentalHdrParameters.getAmbientShScaleForFilament() / (exposure * environmentalHdrParameters.getReflectionScaleForFilament());
        if (sphericalHarmonics.length != 27) {
            throw new RuntimeException("Expected 27 spherical Harmonics coefficients");
        }
        if (this.irradianceData == null || this.irradianceData.length != sphericalHarmonics.length) {
            this.irradianceData = new float[27];
        }
        for (int srcIndex = 0; srcIndex < 9; ++srcIndex) {
            int destIndex = ENVIRONMENTAL_HDR_TO_FILAMENT_SH_INDEX_MAP[srcIndex];
            this.irradianceData[destIndex * 3] = sphericalHarmonics[srcIndex * 3] * ENVIRONMENTAL_HDR_TO_FILAMENT_SH_COEFFIECIENTS[destIndex] * scaleFactor;
            this.irradianceData[destIndex * 3 + 1] = sphericalHarmonics[srcIndex * 3 + 1] * ENVIRONMENTAL_HDR_TO_FILAMENT_SH_COEFFIECIENTS[destIndex] * scaleFactor;
            this.irradianceData[destIndex * 3 + 2] = sphericalHarmonics[srcIndex * 3 + 2] * ENVIRONMENTAL_HDR_TO_FILAMENT_SH_COEFFIECIENTS[destIndex] * scaleFactor;
        }
        this.ambientColor.set(this.irradianceData[0], this.irradianceData[1], this.irradianceData[2]);
        this.colorCorrection.set(new Color(1.0f, 1.0f, 1.0f));
        this.lightEstimate = environmentalHdrParameters.getReflectionScaleForFilament();
        this.intensity = 1.0f;
    }

    public void setLightEstimate(Color colorCorrection, float estimate) {
        this.lightEstimate = Math.min(estimate * 1.8f + 0.0f, 1.0f);
        this.colorCorrection.set(colorCorrection);
    }

    private CompletableFuture<LightingDef> loadInBackground(Callable<InputStream> inputStreamCreator) {
        return CompletableFuture.supplyAsync(() -> {
            LightingDef lightingDef;
            SceneformBundleDef rcb;
            if (inputStreamCreator == null) {
                throw new IllegalArgumentException("Invalid source.");
            }
            ByteBuffer assetData = null;
            try (InputStream inputStream = (InputStream)inputStreamCreator.call();){
                assetData = SceneformBufferUtils.readStream((InputStream)inputStream);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
            if (assetData == null) {
                throw new AssertionError((Object)"The Sceneform bundle containing the Light Probe could not be loaded.");
            }
            try {
                rcb = SceneformBundle.tryLoadSceneformBundle(assetData);
            }
            catch (SceneformBundle.VersionException e) {
                throw new CompletionException(e);
            }
            if (rcb == null) {
                throw new AssertionError((Object)"The Sceneform bundle containing the Light Probe could not be loaded.");
            }
            int lightingDefsLength = rcb.lightingDefsLength();
            if (lightingDefsLength < 1) {
                throw new IllegalStateException("Content does not contain any Light Probe data.");
            }
            int lightProbeIndex = -1;
            if (this.name != null) {
                for (int i = 0; i < lightingDefsLength; ++i) {
                    LightingDef lightingDef2 = rcb.lightingDefs(i);
                    if (!lightingDef2.name().equals(this.name)) continue;
                    lightProbeIndex = i;
                    break;
                }
                if (lightProbeIndex < 0) {
                    String i = this.name;
                    throw new IllegalArgumentException(new StringBuilder(41 + String.valueOf(i).length()).append("Light Probe asset \"").append(i).append("\" not found in bundle.").toString());
                }
            } else {
                lightProbeIndex = 0;
            }
            if ((lightingDef = rcb.lightingDefs(lightProbeIndex)) == null) {
                throw new IllegalStateException("LightingDef is invalid.");
            }
            return lightingDef;
        }, ThreadPools.getThreadPoolExecutor());
    }

    public void setCubeMap(Image[] cubemapImageArray) {
        if (cubemapImageArray.length != 6) {
            int n = cubemapImageArray.length;
            throw new IllegalArgumentException(new StringBuilder(44).append("Unexpected cubemap array length: ").append(n).toString());
        }
        int width = cubemapImageArray[0].getWidth();
        int height = cubemapImageArray[0].getHeight();
        int bufferCapacity = width * height * 6 * 3 * 2;
        if (this.cubemapBuffer.capacity() < bufferCapacity) {
            this.cubemapBuffer = ByteBuffer.allocate(bufferCapacity);
        } else {
            this.cubemapBuffer.clear();
        }
        int[] faceOffsets = new int[6];
        for (int i = 0; i < 6; ++i) {
            faceOffsets[i] = this.cubemapBuffer.position();
            Image.Plane[] planes = cubemapImageArray[i].getPlanes();
            if (planes.length != 1) {
                int n = planes.length;
                throw new IllegalArgumentException(new StringBuilder(63).append("Unexpected number of Planes in cubemap Image array: ").append(n).toString());
            }
            Image.Plane currentPlane = planes[0];
            if (currentPlane.getPixelStride() != 8) {
                int n = currentPlane.getPixelStride();
                throw new IllegalArgumentException(new StringBuilder(68).append("Unexpected pixel stride in cubemap data: expected 8, got ").append(n).toString());
            }
            if (currentPlane.getRowStride() != width * 8) {
                int n = width * 8;
                int n2 = currentPlane.getRowStride();
                throw new IllegalArgumentException(new StringBuilder(76).append("Unexpected row stride in cubemap data: expected ").append(n).append(", got ").append(n2).toString());
            }
            ByteBuffer rgbaBuffer = currentPlane.getBuffer();
            while (rgbaBuffer.hasRemaining()) {
                for (int byt = 0; byt < 8; ++byt) {
                    byte b = rgbaBuffer.get();
                    if (byt >= 6) continue;
                    this.cubemapBuffer.put(b);
                }
            }
        }
        this.cubemapBuffer.flip();
        IEngine engine = EngineInstance.getEngine();
        int levels = (int)(1.0 + Math.log(width) / Math.log(2.0));
        Texture cubemapTexture = new Texture.Builder().width(width).height(height).levels(levels).sampler(Texture.Sampler.SAMPLER_CUBEMAP).format(Texture.InternalFormat.R11F_G11F_B10F).build(engine.getFilamentEngine());
        Texture.PixelBufferDescriptor pixelBuf = new Texture.PixelBufferDescriptor((Buffer)this.cubemapBuffer, Texture.Format.RGB, Texture.Type.HALF);
        Texture.PrefilterOptions options = new Texture.PrefilterOptions();
        options.mirror = false;
        cubemapTexture.generatePrefilterMipmap(engine.getFilamentEngine(), pixelBuf, faceOffsets, options);
        this.setCubeMapFromTexture(cubemapTexture);
    }

    private static Texture loadReflectCubemapFromLightingDef(LightingDef lightingDef) {
        Preconditions.checkNotNull((Object)lightingDef, (Object)"Parameter \"lightingDef\" was null.");
        IEngine engine = EngineInstance.getEngine();
        int mipCount = lightingDef.cubeLevelsLength();
        if (mipCount < 1) {
            throw new IllegalStateException("Lighting cubemap has no image data.");
        }
        LightingCubeDef baseLevel = lightingDef.cubeLevels(0);
        LightingCubeFaceDef baseFace = baseLevel.faces(0);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPremultiplied = false;
        options.inScaled = false;
        options.inJustDecodeBounds = true;
        ByteBuffer data = baseFace.dataAsByteBuffer();
        byte[] dataArray = data.array();
        int offset = data.arrayOffset() + data.position();
        int length = data.limit() - data.position();
        BitmapFactory.decodeByteArray((byte[])dataArray, (int)offset, (int)length, (BitmapFactory.Options)options);
        int width = options.outWidth;
        int height = options.outHeight;
        if (width < 4 || height < 4 || width != height) {
            int n = width;
            int n2 = height;
            throw new IllegalStateException(new StringBuilder(66).append("Lighting cubemap has invalid dimensions: ").append(n).append(" x ").append(n2).toString());
        }
        Texture filamentTexture = new Texture.Builder().width(width).height(height).levels(mipCount).format(Texture.InternalFormat.R11F_G11F_B10F).sampler(Texture.Sampler.SAMPLER_CUBEMAP).build(engine.getFilamentEngine());
        int faceSize = width * height * 4;
        int[] faceOffsetsInBytes = new int[6];
        options.inJustDecodeBounds = false;
        for (int m = 0; m < mipCount; ++m) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(faceSize * 6);
            LightingCubeDef level = lightingDef.cubeLevels(m);
            for (int f = 0; f < 6; ++f) {
                int faceLength;
                int faceOffset;
                int sourceFaceIndex = FACE_TO_FILAMENT_MAPPING[f];
                LightingCubeFaceDef face = level.faces(sourceFaceIndex);
                faceOffsetsInBytes[f] = faceSize * f;
                ByteBuffer faceData = face.dataAsByteBuffer();
                byte[] faceDataArray = faceData.array();
                Bitmap faceBitmap = BitmapFactory.decodeByteArray((byte[])faceDataArray, (int)(faceOffset = faceData.arrayOffset() + faceData.position()), (int)(faceLength = faceData.limit() - faceData.position()), (BitmapFactory.Options)options);
                if (faceBitmap.getWidth() != width || faceBitmap.getHeight() != height) {
                    throw new AssertionError((Object)"All cube map textures must have the same size");
                }
                faceBitmap.copyPixelsToBuffer((Buffer)buffer);
            }
            buffer.rewind();
            Texture.PixelBufferDescriptor descriptor = new Texture.PixelBufferDescriptor((Buffer)buffer, Texture.Format.RGB, Texture.Type.UINT_10F_11F_11F_REV);
            filamentTexture.setImage(engine.getFilamentEngine(), m, descriptor, faceOffsetsInBytes);
            faceSize = (width >>= 1) * (height >>= 1) * 4;
        }
        return filamentTexture;
    }

    private static float[] quaternionToRotationMatrix(Quaternion quaternion) {
        Matrix matrix = new Matrix();
        matrix.makeRotation(quaternion);
        float[] floatArray = new float[]{matrix.data[0], matrix.data[1], matrix.data[2], matrix.data[4], matrix.data[5], matrix.data[6], matrix.data[8], matrix.data[9], matrix.data[10]};
        return floatArray;
    }

    public static final class Builder {
        @Nullable
        private Callable<InputStream> inputStreamCreator = null;
        private float intensity = 220.0f;
        @Nullable
        private Quaternion rotation;
        @Nullable
        private String name = null;

        private Builder() {
        }

        public Builder setIntensity(float intensity) {
            this.intensity = intensity;
            return this;
        }

        public Builder setRotation(@Nullable Quaternion rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder setAssetName(String name) {
            this.name = name;
            return this;
        }

        public Builder setSource(Context context, Uri sourceUri) {
            Preconditions.checkNotNull((Object)sourceUri, (Object)"Parameter \"sourceUri\" was null.");
            this.setSource(LoadHelper.fromUri((Context)context, (Uri)sourceUri));
            return this;
        }

        public Builder setSource(Context context, int resource) {
            this.setSource(LoadHelper.fromResource((Context)context, (int)resource));
            return this;
        }

        public Builder setSource(Callable<InputStream> inputStreamCreator) {
            Preconditions.checkNotNull(inputStreamCreator, (Object)"Parameter \"sourceInputStreamCallable\" was null.");
            this.inputStreamCreator = inputStreamCreator;
            return this;
        }

        public CompletableFuture<LightProbe> build() {
            if (this.inputStreamCreator == null) {
                throw new IllegalStateException("Light Probe source is NULL, this should never happen.");
            }
            LightProbe lightProbe = new LightProbe(this);
            CompletionStage result = lightProbe.loadInBackground(this.inputStreamCreator).thenApplyAsync(lightingDef -> {
                lightProbe.buildFilamentResource(lightingDef);
                return lightProbe;
            }, ThreadPools.getMainExecutor());
            if (result == null) {
                throw new IllegalStateException("CompletableFuture result is null.");
            }
            String string = this.name;
            return FutureHelper.logOnException(TAG, result, new StringBuilder(34 + String.valueOf(string).length()).append("Unable to load LightProbe: name='").append(string).append("'").toString());
        }
    }
}

