/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.RequiresApi;
import com.google.android.filament.Colors;
import com.google.ar.sceneform.common.TransformProvider;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.Color;
import com.google.ar.sceneform.rendering.LightInstance;
import com.google.ar.sceneform.utilities.AndroidPreconditions;
import java.util.ArrayList;

@RequiresApi(api=24)
public class Light {
    private static final float MIN_LIGHT_INTENSITY = 1.0E-4f;
    private final Type type;
    private final boolean enableShadows;
    private Vector3 position;
    private Vector3 direction;
    private final Color color;
    private float intensity;
    private float falloffRadius;
    private float spotlightConeInner;
    private float spotlightConeOuter;
    private final ArrayList<LightChangedListener> changedListeners = new ArrayList();

    public static Builder builder(Type type) {
        AndroidPreconditions.checkMinAndroidApiLevel();
        return new Builder(type);
    }

    public void setColor(Color color) {
        this.color.set(color);
        this.fireChangedListeners();
    }

    public void setColorTemperature(float temperature) {
        float[] rgbColor = Colors.cct((float)temperature);
        this.setColor(new Color(rgbColor[0], rgbColor[1], rgbColor[2]));
    }

    public void setIntensity(float intensity) {
        this.intensity = Math.max(intensity, 1.0E-4f);
        this.fireChangedListeners();
    }

    public void setFalloffRadius(float falloffRadius) {
        this.falloffRadius = falloffRadius;
        this.fireChangedListeners();
    }

    public void setInnerConeAngle(float coneInner) {
        this.spotlightConeInner = coneInner;
        this.fireChangedListeners();
    }

    public void setOuterConeAngle(float coneOuter) {
        this.spotlightConeOuter = coneOuter;
        this.fireChangedListeners();
    }

    public Type getType() {
        return this.type;
    }

    public boolean isShadowCastingEnabled() {
        return this.enableShadows;
    }

    public Vector3 getLocalPosition() {
        return new Vector3(this.position);
    }

    public Vector3 getLocalDirection() {
        return new Vector3(this.direction);
    }

    public Color getColor() {
        return new Color(this.color);
    }

    public float getIntensity() {
        return this.intensity;
    }

    public float getFalloffRadius() {
        return this.falloffRadius;
    }

    public float getInnerConeAngle() {
        return this.spotlightConeInner;
    }

    public float getOuterConeAngle() {
        return this.spotlightConeOuter;
    }

    public LightInstance createInstance(TransformProvider transformProvider) {
        LightInstance instance = new LightInstance(this, transformProvider);
        if (instance == null) {
            throw new AssertionError((Object)"Failed to create light instance, result is null.");
        }
        return instance;
    }

    void addChangedListener(LightChangedListener listener) {
        this.changedListeners.add(listener);
    }

    void removeChangedListener(LightChangedListener listener) {
        this.changedListeners.remove(listener);
    }

    private Light(Builder builder) {
        this.type = builder.type;
        this.enableShadows = builder.enableShadows;
        this.position = builder.position;
        this.direction = builder.direction;
        this.color = builder.color;
        this.intensity = builder.intensity;
        this.falloffRadius = builder.falloffRadius;
        this.spotlightConeInner = builder.spotlightConeInner;
        this.spotlightConeOuter = builder.spotlightConeOuter;
    }

    private void fireChangedListeners() {
        for (LightChangedListener listener : this.changedListeners) {
            listener.onChange();
        }
    }

    public static final class Builder {
        private static final float DEFAULT_DIRECTIONAL_INTENSITY = 420.0f;
        private final Type type;
        private boolean enableShadows = false;
        private Vector3 position = new Vector3(0.0f, 0.0f, 0.0f);
        private Vector3 direction = new Vector3(0.0f, 0.0f, -1.0f);
        private Color color = new Color(1.0f, 1.0f, 1.0f);
        private float intensity = 2500.0f;
        private float falloffRadius = 10.0f;
        private float spotlightConeInner = 0.5f;
        private float spotlightConeOuter = 0.6f;

        private Builder(Type type) {
            this.type = type;
            if (type == Type.DIRECTIONAL) {
                this.intensity = 420.0f;
            }
        }

        public Builder setShadowCastingEnabled(boolean enableShadows) {
            this.enableShadows = enableShadows;
            return this;
        }

        public Builder setColor(Color color) {
            this.color = color;
            return this;
        }

        public Builder setColorTemperature(float temperature) {
            float[] rgbColor = Colors.cct((float)temperature);
            this.setColor(new Color(rgbColor[0], rgbColor[1], rgbColor[2]));
            return this;
        }

        public Builder setIntensity(float intensity) {
            this.intensity = intensity;
            return this;
        }

        public Builder setFalloffRadius(float falloffRadius) {
            this.falloffRadius = falloffRadius;
            return this;
        }

        public Builder setInnerConeAngle(float coneInner) {
            this.spotlightConeInner = coneInner;
            return this;
        }

        public Builder setOuterConeAngle(float coneOuter) {
            this.spotlightConeOuter = coneOuter;
            return this;
        }

        public Light build() {
            Light light = new Light(this);
            if (light == null) {
                throw new AssertionError((Object)"Allocating a new light failed.");
            }
            return light;
        }
    }

    static interface LightChangedListener {
        public void onChange();
    }

    public static enum Type {
        POINT,
        DIRECTIONAL,
        SPOTLIGHT,
        FOCUSED_SPOTLIGHT;

    }
}

