/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.media.Image;
import android.support.annotation.Nullable;
import com.google.ar.core.annotations.UsedByReflection;
import com.google.ar.sceneform.rendering.Color;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class EnvironmentalHdrLightEstimate
implements Serializable {
    @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
    @Nullable
    private final float[] sphericalHarmonics;
    @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
    @Nullable
    private final float[] direction;
    @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
    private final float colorR;
    @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
    private final float colorG;
    @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
    private final float colorB;
    @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
    private final float colorA;
    @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
    private final float relativeIntensity;
    @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
    @Nullable
    private final CubeMapImage[] cubeMap;

    public EnvironmentalHdrLightEstimate(@Nullable float[] sphericalHarmonics, @Nullable float[] direction, Color colorCorrection, float relativeIntensity, @Nullable Image[] cubeMap) {
        if (sphericalHarmonics != null) {
            this.sphericalHarmonics = new float[sphericalHarmonics.length];
            System.arraycopy(sphericalHarmonics, 0, this.sphericalHarmonics, 0, sphericalHarmonics.length);
        } else {
            this.sphericalHarmonics = null;
        }
        if (direction != null) {
            this.direction = new float[direction.length];
            System.arraycopy(direction, 0, this.direction, 0, direction.length);
        } else {
            this.direction = null;
        }
        this.colorR = colorCorrection.r;
        this.colorG = colorCorrection.g;
        this.colorB = colorCorrection.b;
        this.colorA = colorCorrection.a;
        this.relativeIntensity = relativeIntensity;
        if (cubeMap != null) {
            this.cubeMap = new CubeMapImage[cubeMap.length];
            for (int i = 0; i < cubeMap.length; ++i) {
                this.cubeMap[i] = new CubeMapImage(cubeMap[i]);
            }
        } else {
            this.cubeMap = null;
        }
    }

    @Nullable
    public float[] getSphericalHarmonics() {
        return this.sphericalHarmonics;
    }

    @Nullable
    public float[] getDirection() {
        return this.direction;
    }

    public Color getColor() {
        return new Color(this.colorR, this.colorG, this.colorB, this.colorA);
    }

    public float getRelativeIntensity() {
        return this.relativeIntensity;
    }

    @Nullable
    public CubeMapImage[] getCubeMap() {
        return this.cubeMap;
    }

    @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
    static class CubeMapImage
    implements Serializable {
        @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
        final int format;
        @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
        final CubeMapPlane[] planes;
        @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
        final int height;
        @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
        final int width;
        @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
        final long timestamp;

        CubeMapImage(Image image) {
            this.format = image.getFormat();
            Image.Plane[] imagePlanes = image.getPlanes();
            this.planes = new CubeMapPlane[imagePlanes.length];
            for (int i = 0; i < imagePlanes.length; ++i) {
                this.planes[i] = new CubeMapPlane(imagePlanes[i]);
            }
            this.height = image.getHeight();
            this.width = image.getWidth();
            this.timestamp = image.getTimestamp();
        }

        @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
        static class CubeMapPlane
        implements Serializable {
            @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
            final int pixelStride;
            @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
            final int rowStride;
            @UsedByReflection(value="EnvironmentalHdrLightEstimate.java")
            final byte[] bytes;

            public CubeMapPlane(Image.Plane plane) {
                ByteBuffer rgbaBuffer = plane.getBuffer();
                this.bytes = new byte[rgbaBuffer.remaining()];
                rgbaBuffer.get(this.bytes);
                this.pixelStride = plane.getPixelStride();
                this.rowStride = plane.getRowStride();
            }
        }
    }
}

