/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.opengl.EGLContext;
import android.support.annotation.Nullable;
import com.google.android.filament.Engine;
import com.google.android.filament.Filament;
import com.google.ar.sceneform.assets.Loader;
import com.google.ar.sceneform.rendering.FilamentEngineWrapper;
import com.google.ar.sceneform.rendering.GLHelper;
import com.google.ar.sceneform.rendering.HeadlessEngineWrapper;
import com.google.ar.sceneform.rendering.IEngine;

public class EngineInstance {
    @Nullable
    private static IEngine engine = null;
    @Nullable
    private static EGLContext glContext = null;
    private static boolean headlessEngine = false;
    private static boolean filamentInitialized = false;

    public static void enableHeadlessEngine() {
        headlessEngine = true;
    }

    public static void disableHeadlessEngine() {
        headlessEngine = false;
    }

    public static boolean isHeadlessMode() {
        return headlessEngine;
    }

    public static IEngine getEngine() {
        if (!headlessEngine) {
            EngineInstance.createEngine();
        } else {
            EngineInstance.createHeadlessEngine();
        }
        if (engine == null) {
            throw new IllegalStateException("Filament Engine creation has failed.");
        }
        return engine;
    }

    public static EGLContext getGlContext() {
        EngineInstance.createEngine();
        if (glContext == null) {
            throw new IllegalStateException("Filament Engine creation has failed.");
        }
        return glContext;
    }

    private static void createEngine() {
        if (engine == null || glContext == null) {
            if (!filamentInitialized) {
                try {
                    Filament.init();
                    filamentInitialized = true;
                }
                catch (UnsatisfiedLinkError err) {
                    if (Loader.loadUnifiedJni()) {
                        filamentInitialized = true;
                    }
                    throw err;
                }
            }
            if ((engine = new FilamentEngineWrapper(Engine.create((Object)(glContext = GLHelper.makeContext())))) == null || glContext == null) {
                throw new IllegalStateException("Filament Engine creation has failed.");
            }
        }
    }

    private static void createHeadlessEngine() {
        if (engine == null) {
            try {
                engine = new HeadlessEngineWrapper();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Filament Engine creation failed due to reflection error", e);
            }
            if (engine == null) {
                throw new IllegalStateException("Filament Engine creation has failed.");
            }
        }
    }

    public static void destroyEngine() {
        if (glContext != null) {
            GLHelper.destroyContext(glContext);
            glContext = null;
        }
        if (engine != null) {
            engine.destroy();
            engine = null;
        }
    }

    public static boolean isEngineDestroyed() {
        return engine == null;
    }
}

