/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import android.support.annotation.ColorInt;
import com.google.android.filament.Colors;

public class Color {
    private static final float INT_COLOR_SCALE = 0.003921569f;
    public float r;
    public float g;
    public float b;
    public float a;

    public Color() {
        this.setWhite();
    }

    public Color(Color color) {
        this.set(color);
    }

    public Color(float r, float g, float b) {
        this.set(r, g, b);
    }

    public Color(float r, float g, float b, float a) {
        this.set(r, g, b, a);
    }

    public Color(@ColorInt int argb) {
        this.set(argb);
    }

    public void set(Color color) {
        this.set(color.r, color.g, color.b, color.a);
    }

    public void set(float r, float g, float b) {
        this.set(r, g, b, 1.0f);
    }

    public void set(float r, float g, float b, float a) {
        this.r = Math.max(0.0f, Math.min(1.0f, r));
        this.g = Math.max(0.0f, Math.min(1.0f, g));
        this.b = Math.max(0.0f, Math.min(1.0f, b));
        this.a = Math.max(0.0f, Math.min(1.0f, a));
    }

    public void set(@ColorInt int argb) {
        int red = android.graphics.Color.red((int)argb);
        int green = android.graphics.Color.green((int)argb);
        int blue = android.graphics.Color.blue((int)argb);
        int alpha = android.graphics.Color.alpha((int)argb);
        float[] linearColor = Colors.toLinear((Colors.RgbType)Colors.RgbType.SRGB, (float)((float)red * 0.003921569f), (float)((float)green * 0.003921569f), (float)((float)blue * 0.003921569f));
        this.r = linearColor[0];
        this.g = linearColor[1];
        this.b = linearColor[2];
        this.a = (float)alpha * 0.003921569f;
    }

    private void setWhite() {
        this.set(1.0f, 1.0f, 1.0f);
    }

    public Color inverseTonemap() {
        Color color = new Color(this.r, this.g, this.b, this.a);
        color.r = Color.inverseTonemap(this.r);
        color.g = Color.inverseTonemap(this.g);
        color.b = Color.inverseTonemap(this.b);
        return color;
    }

    private static float inverseTonemap(float val) {
        return val * -0.155f / (val - 1.019f);
    }
}

