/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.rendering;

import com.google.ar.sceneform.rendering.CleanupItem;
import com.google.ar.sceneform.resources.ResourceHolder;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Iterator;

public class CleanupRegistry<T>
implements ResourceHolder {
    private final HashSet<CleanupItem<T>> cleanupItemHashSet;
    private final ReferenceQueue<T> referenceQueue;

    public CleanupRegistry() {
        this(new HashSet<CleanupItem<T>>(), new ReferenceQueue());
    }

    public CleanupRegistry(HashSet<CleanupItem<T>> cleanupItemHashSet, ReferenceQueue<T> referenceQueue) {
        this.cleanupItemHashSet = cleanupItemHashSet;
        this.referenceQueue = referenceQueue;
    }

    public void register(T trackedObject, Runnable cleanupCallback) {
        this.cleanupItemHashSet.add(new CleanupItem<T>(trackedObject, this.referenceQueue, cleanupCallback));
    }

    public long reclaimReleasedResources() {
        CleanupItem ref = (CleanupItem)this.referenceQueue.poll();
        while (ref != null) {
            if (this.cleanupItemHashSet.contains(ref)) {
                ref.run();
                this.cleanupItemHashSet.remove(ref);
            }
            ref = (CleanupItem)this.referenceQueue.poll();
        }
        return this.cleanupItemHashSet.size();
    }

    public void destroyAllResources() {
        Iterator<CleanupItem<T>> iterator = this.cleanupItemHashSet.iterator();
        while (iterator.hasNext()) {
            CleanupItem<T> ref = iterator.next();
            iterator.remove();
            ref.run();
        }
    }
}

