/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.google.android.filament.Asserts;
import com.google.android.filament.Camera;
import com.google.android.filament.RenderTarget;
import com.google.android.filament.Scene;
import com.google.android.filament.Viewport;

public class View {
    private long mNativeObject;
    private String mName;
    private Scene mScene;
    private Camera mCamera;
    private Viewport mViewport = new Viewport(0, 0, 0, 0);
    private DynamicResolutionOptions mDynamicResolution;
    private RenderQuality mRenderQuality;
    private DepthPrepass mDepthPrepass = DepthPrepass.DEFAULT;
    private AmbientOcclusionOptions mAmbientOcclusionOptions;
    private RenderTarget mRenderTarget;

    View(long nativeView) {
        this.mNativeObject = nativeView;
    }

    public void setName(@NonNull String name) {
        this.mName = name;
        View.nSetName(this.getNativeObject(), name);
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    public void setScene(@Nullable Scene scene) {
        this.mScene = scene;
        View.nSetScene(this.getNativeObject(), scene == null ? 0L : scene.getNativeObject());
    }

    @Nullable
    public Scene getScene() {
        return this.mScene;
    }

    public void setCamera(@Nullable Camera camera) {
        this.mCamera = camera;
        View.nSetCamera(this.getNativeObject(), camera == null ? 0L : camera.getNativeObject());
    }

    @Nullable
    public Camera getCamera() {
        return this.mCamera;
    }

    public void setViewport(@NonNull Viewport viewport) {
        this.mViewport = viewport;
        View.nSetViewport(this.getNativeObject(), this.mViewport.left, this.mViewport.bottom, this.mViewport.width, this.mViewport.height);
    }

    @NonNull
    public Viewport getViewport() {
        return this.mViewport;
    }

    public void setClearColor(float r, float g, float b, float a) {
        View.nSetClearColor(this.getNativeObject(), r, g, b, a);
    }

    @NonNull
    @Size(min=4L)
    public float[] getClearColor(@NonNull @Size(min=4L) float[] out) {
        out = Asserts.assertFloat4(out);
        View.nGetClearColor(this.getNativeObject(), out);
        return out;
    }

    public void setClearTargets(boolean color, boolean depth, boolean stencil) {
        View.nSetClearTargets(this.getNativeObject(), color, depth, stencil);
    }

    public void setVisibleLayers(@IntRange(from=0L, to=255L) int select, @IntRange(from=0L, to=255L) int values) {
        View.nSetVisibleLayers(this.getNativeObject(), select & 0xFF, values & 0xFF);
    }

    public void setShadowsEnabled(boolean enabled) {
        View.nSetShadowsEnabled(this.getNativeObject(), enabled);
    }

    public void setRenderTarget(@Nullable RenderTarget target) {
        this.mRenderTarget = target;
        View.nSetRenderTarget(this.getNativeObject(), target != null ? target.getNativeObject() : 0L);
    }

    @Nullable
    public RenderTarget getRenderTarget() {
        return this.mRenderTarget;
    }

    public void setSampleCount(int count) {
        View.nSetSampleCount(this.getNativeObject(), count);
    }

    public int getSampleCount() {
        return View.nGetSampleCount(this.getNativeObject());
    }

    public void setAntiAliasing(@NonNull AntiAliasing type) {
        View.nSetAntiAliasing(this.getNativeObject(), type.ordinal());
    }

    @NonNull
    public AntiAliasing getAntiAliasing() {
        return AntiAliasing.values()[View.nGetAntiAliasing(this.getNativeObject())];
    }

    public void setToneMapping(@NonNull ToneMapping type) {
        View.nSetToneMapping(this.getNativeObject(), type.ordinal());
    }

    @NonNull
    public ToneMapping getToneMapping() {
        return ToneMapping.values()[View.nGetToneMapping(this.getNativeObject())];
    }

    public void setDithering(@NonNull Dithering dithering) {
        View.nSetDithering(this.getNativeObject(), dithering.ordinal());
    }

    @NonNull
    public Dithering getDithering() {
        return Dithering.values()[View.nGetDithering(this.getNativeObject())];
    }

    public void setDynamicResolutionOptions(@NonNull DynamicResolutionOptions options) {
        this.mDynamicResolution = options;
        View.nSetDynamicResolutionOptions(this.getNativeObject(), options.enabled, options.homogeneousScaling, options.targetFrameTimeMilli, options.headRoomRatio, options.scaleRate, options.minScale, options.maxScale, options.history);
    }

    @NonNull
    public DynamicResolutionOptions getDynamicResolutionOptions() {
        if (this.mDynamicResolution == null) {
            this.mDynamicResolution = new DynamicResolutionOptions();
        }
        return this.mDynamicResolution;
    }

    public void setRenderQuality(@NonNull RenderQuality renderQuality) {
        this.mRenderQuality = renderQuality;
        View.nSetRenderQuality(this.getNativeObject(), renderQuality.hdrColorBuffer.ordinal());
    }

    @NonNull
    public RenderQuality getRenderQuality() {
        if (this.mRenderQuality == null) {
            this.mRenderQuality = new RenderQuality();
        }
        return this.mRenderQuality;
    }

    @NonNull
    public DepthPrepass getDepthPrepass() {
        return this.mDepthPrepass;
    }

    public void setDepthPrepass(@NonNull DepthPrepass depthPrepass) {
        this.mDepthPrepass = depthPrepass;
        View.nSetDepthPrepass(this.getNativeObject(), depthPrepass.value);
    }

    public boolean isPostProcessingEnabled() {
        return View.nIsPostProcessingEnabled(this.getNativeObject());
    }

    public void setPostProcessingEnabled(boolean enabled) {
        View.nSetPostProcessingEnabled(this.getNativeObject(), enabled);
    }

    public boolean isFrontFaceWindingInverted() {
        return View.nIsFrontFaceWindingInverted(this.getNativeObject());
    }

    public void setFrontFaceWindingInverted(boolean inverted) {
        View.nSetFrontFaceWindingInverted(this.getNativeObject(), inverted);
    }

    public void setDynamicLightingOptions(float zLightNear, float zLightFar) {
        View.nSetDynamicLightingOptions(this.getNativeObject(), zLightNear, zLightFar);
    }

    public void setAmbientOcclusion(@NonNull AmbientOcclusion ao) {
        View.nSetAmbientOcclusion(this.getNativeObject(), ao.ordinal());
    }

    @NonNull
    public AmbientOcclusion getAmbientOcclusion() {
        return AmbientOcclusion.values()[View.nGetAmbientOcclusion(this.getNativeObject())];
    }

    public void setAmbientOcclusionOptions(@NonNull AmbientOcclusionOptions options) {
        this.mAmbientOcclusionOptions = options;
        View.nSetAmbientOcclusionOptions(this.getNativeObject(), options.radius, options.bias, options.power, options.resolution, options.intensity);
    }

    @NonNull
    public AmbientOcclusionOptions getAmbientOcclusionOptions() {
        if (this.mAmbientOcclusionOptions == null) {
            this.mAmbientOcclusionOptions = new AmbientOcclusionOptions();
        }
        return this.mAmbientOcclusionOptions;
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed View");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native void nSetName(long var0, String var2);

    private static native void nSetScene(long var0, long var2);

    private static native void nSetCamera(long var0, long var2);

    private static native void nSetViewport(long var0, int var2, int var3, int var4, int var5);

    private static native void nSetClearColor(long var0, float var2, float var3, float var4, float var5);

    private static native void nGetClearColor(long var0, float[] var2);

    private static native void nSetClearTargets(long var0, boolean var2, boolean var3, boolean var4);

    private static native void nSetVisibleLayers(long var0, int var2, int var3);

    private static native void nSetShadowsEnabled(long var0, boolean var2);

    private static native void nSetRenderTarget(long var0, long var2);

    private static native void nSetSampleCount(long var0, int var2);

    private static native int nGetSampleCount(long var0);

    private static native void nSetAntiAliasing(long var0, int var2);

    private static native int nGetAntiAliasing(long var0);

    private static native void nSetToneMapping(long var0, int var2);

    private static native int nGetToneMapping(long var0);

    private static native void nSetDithering(long var0, int var2);

    private static native int nGetDithering(long var0);

    private static native void nSetDynamicResolutionOptions(long var0, boolean var2, boolean var3, float var4, float var5, float var6, float var7, float var8, int var9);

    private static native void nSetRenderQuality(long var0, int var2);

    private static native void nSetDynamicLightingOptions(long var0, float var2, float var3);

    private static native void nSetDepthPrepass(long var0, int var2);

    private static native void nSetPostProcessingEnabled(long var0, boolean var2);

    private static native boolean nIsPostProcessingEnabled(long var0);

    private static native void nSetFrontFaceWindingInverted(long var0, boolean var2);

    private static native boolean nIsFrontFaceWindingInverted(long var0);

    private static native void nSetAmbientOcclusion(long var0, int var2);

    private static native int nGetAmbientOcclusion(long var0);

    private static native void nSetAmbientOcclusionOptions(long var0, float var2, float var3, float var4, float var5, float var6);

    public static enum DepthPrepass {
        DEFAULT(-1),
        DISABLED(0),
        ENABLED(1);

        final int value;

        private DepthPrepass(int value) {
            this.value = value;
        }
    }

    public static enum Dithering {
        NONE,
        TEMPORAL;

    }

    public static enum ToneMapping {
        LINEAR,
        ACES;

    }

    public static enum AntiAliasing {
        NONE,
        FXAA;

    }

    public static enum AmbientOcclusion {
        NONE,
        SSAO;

    }

    public static class RenderQuality {
        public QualityLevel hdrColorBuffer = QualityLevel.HIGH;
    }

    public static enum QualityLevel {
        LOW,
        MEDIUM,
        HIGH,
        ULTRA;

    }

    public static class AmbientOcclusionOptions {
        public float radius = 0.3f;
        public float bias = 0.005f;
        public float power = 0.0f;
        public float resolution = 0.5f;
        public float intensity = 1.0f;
    }

    public static class DynamicResolutionOptions {
        public boolean enabled = false;
        public boolean homogeneousScaling = false;
        public float targetFrameTimeMilli = 16.666666f;
        public float headRoomRatio = 0.0f;
        public float scaleRate = 0.125f;
        public float minScale = 0.5f;
        public float maxScale = 1.0f;
        public int history = 9;
    }
}

