/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import android.support.annotation.NonNull;

public class TextureSampler {
    int mSampler = 0;

    public TextureSampler() {
        this(MinFilter.LINEAR_MIPMAP_LINEAR, MagFilter.LINEAR, WrapMode.REPEAT);
    }

    public TextureSampler(@NonNull MagFilter minMag) {
        this(minMag, WrapMode.CLAMP_TO_EDGE);
    }

    public TextureSampler(@NonNull MagFilter minMag, @NonNull WrapMode wrap) {
        this(TextureSampler.minFilterFromMagFilter(minMag), minMag, wrap);
    }

    public TextureSampler(@NonNull MinFilter min, @NonNull MagFilter mag, @NonNull WrapMode wrap) {
        this(min, mag, wrap, wrap, wrap);
    }

    public TextureSampler(@NonNull MinFilter min, @NonNull MagFilter mag, @NonNull WrapMode s, @NonNull WrapMode t, @NonNull WrapMode r) {
        this.mSampler = TextureSampler.nCreateSampler(min.ordinal(), mag.ordinal(), s.ordinal(), t.ordinal(), r.ordinal());
    }

    public TextureSampler(@NonNull CompareMode mode) {
        this(mode, CompareFunction.LESS_EQUAL);
    }

    public TextureSampler(@NonNull CompareMode mode, @NonNull CompareFunction function) {
        this.mSampler = TextureSampler.nCreateCompareSampler(mode.ordinal(), function.ordinal());
    }

    public MinFilter getMinFilter() {
        return MinFilter.values()[TextureSampler.nGetMinFilter(this.mSampler)];
    }

    public void setMinFilter(MinFilter filter) {
        this.mSampler = TextureSampler.nSetMinFilter(this.mSampler, filter.ordinal());
    }

    public MagFilter getMagFilter() {
        return MagFilter.values()[TextureSampler.nGetMagFilter(this.mSampler)];
    }

    public void setMagFilter(MagFilter filter) {
        this.mSampler = TextureSampler.nSetMagFilter(this.mSampler, filter.ordinal());
    }

    public WrapMode getWrapModeS() {
        return WrapMode.values()[TextureSampler.nGetWrapModeS(this.mSampler)];
    }

    public void setWrapModeS(WrapMode mode) {
        this.mSampler = TextureSampler.nSetWrapModeS(this.mSampler, mode.ordinal());
    }

    public WrapMode getWrapModeT() {
        return WrapMode.values()[TextureSampler.nGetWrapModeT(this.mSampler)];
    }

    public void setWrapModeT(WrapMode mode) {
        this.mSampler = TextureSampler.nSetWrapModeT(this.mSampler, mode.ordinal());
    }

    public WrapMode getWrapModeR() {
        return WrapMode.values()[TextureSampler.nGetWrapModeR(this.mSampler)];
    }

    public void setWrapModeR(WrapMode mode) {
        this.mSampler = TextureSampler.nSetWrapModeR(this.mSampler, mode.ordinal());
    }

    public float getAnisotropy() {
        return TextureSampler.nGetAnisotropy(this.mSampler);
    }

    public void setAnisotropy(float anisotropy) {
        this.mSampler = TextureSampler.nSetAnisotropy(this.mSampler, anisotropy);
    }

    public CompareMode getCompareMode() {
        return CompareMode.values()[TextureSampler.nGetCompareMode(this.mSampler)];
    }

    public void setCompareMode(CompareMode mode) {
        this.mSampler = TextureSampler.nSetCompareMode(this.mSampler, mode.ordinal());
    }

    public CompareFunction getCompareFunction() {
        return CompareFunction.values()[TextureSampler.nGetCompareFunction(this.mSampler)];
    }

    public void setCompareFunction(CompareFunction function) {
        this.mSampler = TextureSampler.nSetCompareFunction(this.mSampler, function.ordinal());
    }

    private static MinFilter minFilterFromMagFilter(@NonNull MagFilter minMag) {
        switch (minMag) {
            case NEAREST: {
                return MinFilter.NEAREST;
            }
        }
        return MinFilter.LINEAR;
    }

    private static native int nCreateSampler(int var0, int var1, int var2, int var3, int var4);

    private static native int nCreateCompareSampler(int var0, int var1);

    private static native int nGetMinFilter(int var0);

    private static native int nSetMinFilter(int var0, int var1);

    private static native int nGetMagFilter(int var0);

    private static native int nSetMagFilter(int var0, int var1);

    private static native int nGetWrapModeS(int var0);

    private static native int nSetWrapModeS(int var0, int var1);

    private static native int nGetWrapModeT(int var0);

    private static native int nSetWrapModeT(int var0, int var1);

    private static native int nGetWrapModeR(int var0);

    private static native int nSetWrapModeR(int var0, int var1);

    private static native int nGetCompareMode(int var0);

    private static native int nSetCompareMode(int var0, int var1);

    private static native int nGetCompareFunction(int var0);

    private static native int nSetCompareFunction(int var0, int var1);

    private static native float nGetAnisotropy(int var0);

    private static native int nSetAnisotropy(int var0, float var1);

    public static enum CompareFunction {
        LESS_EQUAL,
        GREATER_EQUAL,
        LESS,
        GREATER,
        EQUAL,
        NOT_EQUAL,
        ALWAYS,
        NEVER;

    }

    public static enum CompareMode {
        NONE,
        COMPARE_TO_TEXTURE;

    }

    public static enum MagFilter {
        NEAREST,
        LINEAR;

    }

    public static enum MinFilter {
        NEAREST,
        LINEAR,
        NEAREST_MIPMAP_NEAREST,
        LINEAR_MIPMAP_NEAREST,
        NEAREST_MIPMAP_LINEAR,
        LINEAR_MIPMAP_LINEAR;

    }

    public static enum WrapMode {
        CLAMP_TO_EDGE,
        REPEAT,
        MIRRORED_REPEAT;

    }
}

