/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import com.google.android.filament.Engine;
import com.google.android.filament.Platform;
import com.google.android.filament.Texture;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ReadOnlyBufferException;

public class Stream {
    private long mNativeObject;
    private long mNativeEngine;

    Stream(long nativeStream, Engine engine) {
        this.mNativeObject = nativeStream;
        this.mNativeEngine = engine.getNativeObject();
    }

    public StreamType getStreamType() {
        return StreamType.values()[Stream.nGetStreamType(this.getNativeObject())];
    }

    public void setAcquiredImage(Object hwbuffer, Object handler, Runnable callback) {
        Stream.nSetAcquiredImage(this.getNativeObject(), this.mNativeEngine, hwbuffer, handler, callback);
    }

    public void setDimensions(@IntRange(from=0L) int width, @IntRange(from=0L) int height) {
        Stream.nSetDimensions(this.getNativeObject(), width, height);
    }

    public void readPixels(@IntRange(from=0L) int xoffset, @IntRange(from=0L) int yoffset, @IntRange(from=0L) int width, @IntRange(from=0L) int height, @NonNull Texture.PixelBufferDescriptor buffer) {
        if (buffer.storage.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int result = Stream.nReadPixels(this.getNativeObject(), this.mNativeEngine, xoffset, yoffset, width, height, buffer.storage, buffer.storage.remaining(), buffer.left, buffer.top, buffer.type.ordinal(), buffer.alignment, buffer.stride, buffer.format.ordinal(), buffer.handler, buffer.callback);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public long getTimestamp() {
        return Stream.nGetTimestamp(this.getNativeObject());
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed Stream");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native long nCreateBuilder();

    private static native void nDestroyBuilder(long var0);

    private static native void nBuilderStreamSource(long var0, Object var2);

    private static native void nBuilderStream(long var0, long var2);

    private static native void nBuilderWidth(long var0, int var2);

    private static native void nBuilderHeight(long var0, int var2);

    private static native long nBuilderBuild(long var0, long var2);

    private static native int nGetStreamType(long var0);

    private static native void nSetDimensions(long var0, int var2, int var3);

    private static native int nReadPixels(long var0, long var2, int var4, int var5, int var6, int var7, Buffer var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, Object var16, Runnable var17);

    private static native long nGetTimestamp(long var0);

    private static native void nSetAcquiredImage(long var0, long var2, Object var4, Object var5, Runnable var6);

    static /* synthetic */ long access$000() {
        return Stream.nCreateBuilder();
    }

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder = Stream.access$000();

        public Builder() {
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        @NonNull
        public Builder stream(@NonNull Object streamSource) {
            if (Platform.get().validateStreamSource(streamSource)) {
                Stream.nBuilderStreamSource(this.mNativeBuilder, streamSource);
                return this;
            }
            throw new IllegalArgumentException("Invalid stream source: " + streamSource);
        }

        @NonNull
        public Builder stream(long externalTextureId) {
            Stream.nBuilderStream(this.mNativeBuilder, externalTextureId);
            return this;
        }

        @NonNull
        public Builder width(int width) {
            Stream.nBuilderWidth(this.mNativeBuilder, width);
            return this;
        }

        @NonNull
        public Builder height(int height) {
            Stream.nBuilderHeight(this.mNativeBuilder, height);
            return this;
        }

        @NonNull
        public Stream build(@NonNull Engine engine) {
            long nativeStream = Stream.nBuilderBuild(this.mNativeBuilder, engine.getNativeObject());
            if (nativeStream == 0L) {
                throw new IllegalStateException("Couldn't create Stream");
            }
            return new Stream(nativeStream, engine);
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    Stream.nDestroyBuilder(this.mNativeObject);
                }
            }
        }
    }

    public static enum StreamType {
        NATIVE,
        TEXTURE_ID,
        ACQUIRED;

    }
}

