/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import com.google.android.filament.Engine;
import com.google.android.filament.Texture;
import com.google.android.filament.proguard.UsedByReflection;

public class Skybox {
    private long mNativeObject;

    @UsedByReflection(value="KtxLoader.java")
    Skybox(long nativeSkybox) {
        this.mNativeObject = nativeSkybox;
    }

    public void setLayerMask(@IntRange(from=0L, to=255L) int select, @IntRange(from=0L, to=255L) int values) {
        Skybox.nSetLayerMask(this.getNativeObject(), select & 0xFF, values & 0xFF);
    }

    public int getLayerMask() {
        return Skybox.nGetLayerMask(this.getNativeObject());
    }

    public float getIntensity() {
        return Skybox.nGetIntensity(this.getNativeObject());
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed Skybox");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native long nCreateBuilder();

    private static native void nDestroyBuilder(long var0);

    private static native void nBuilderEnvironment(long var0, long var2);

    private static native void nBuilderShowSun(long var0, boolean var2);

    private static native void nBuilderIntensity(long var0, float var2);

    private static native long nBuilderBuild(long var0, long var2);

    private static native void nSetLayerMask(long var0, int var2, int var3);

    private static native int nGetLayerMask(long var0);

    private static native float nGetIntensity(long var0);

    static /* synthetic */ long access$000() {
        return Skybox.nCreateBuilder();
    }

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder = Skybox.access$000();

        public Builder() {
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        @NonNull
        public Builder environment(@NonNull Texture cubemap) {
            Skybox.nBuilderEnvironment(this.mNativeBuilder, cubemap.getNativeObject());
            return this;
        }

        @NonNull
        public Builder showSun(boolean show) {
            Skybox.nBuilderShowSun(this.mNativeBuilder, show);
            return this;
        }

        @NonNull
        public Builder intensity(float envIntensity) {
            Skybox.nBuilderIntensity(this.mNativeBuilder, envIntensity);
            return this;
        }

        @NonNull
        public Skybox build(@NonNull Engine engine) {
            long nativeSkybox = Skybox.nBuilderBuild(this.mNativeBuilder, engine.getNativeObject());
            if (nativeSkybox == 0L) {
                throw new IllegalStateException("Couldn't create Skybox");
            }
            return new Skybox(nativeSkybox);
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    Skybox.nDestroyBuilder(this.mNativeObject);
                }
            }
        }
    }
}

