/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import com.google.android.filament.Engine;
import com.google.android.filament.RenderTarget;
import com.google.android.filament.SwapChain;
import com.google.android.filament.Texture;
import com.google.android.filament.View;
import com.google.android.filament.Viewport;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ReadOnlyBufferException;

public class Renderer {
    private final Engine mEngine;
    private long mNativeObject;
    public static final int MIRROR_FRAME_FLAG_COMMIT = 1;
    public static final int MIRROR_FRAME_FLAG_SET_PRESENTATION_TIME = 2;
    public static final int MIRROR_FRAME_FLAG_CLEAR = 4;

    Renderer(@NonNull Engine engine, long nativeRenderer) {
        this.mEngine = engine;
        this.mNativeObject = nativeRenderer;
    }

    @NonNull
    public Engine getEngine() {
        return this.mEngine;
    }

    public boolean beginFrame(@NonNull SwapChain swapChain) {
        return Renderer.nBeginFrame(this.getNativeObject(), swapChain.getNativeObject());
    }

    public void endFrame() {
        Renderer.nEndFrame(this.getNativeObject());
    }

    public void render(@NonNull View view) {
        Renderer.nRender(this.getNativeObject(), view.getNativeObject());
    }

    public void copyFrame(@NonNull SwapChain dstSwapChain, @NonNull Viewport dstViewport, @NonNull Viewport srcViewport, int flags) {
        Renderer.nCopyFrame(this.getNativeObject(), dstSwapChain.getNativeObject(), dstViewport.left, dstViewport.bottom, dstViewport.width, dstViewport.height, srcViewport.left, srcViewport.bottom, srcViewport.width, srcViewport.height, flags);
    }

    @Deprecated
    public void mirrorFrame(@NonNull SwapChain dstSwapChain, @NonNull Viewport dstViewport, @NonNull Viewport srcViewport, int flags) {
        this.copyFrame(dstSwapChain, dstViewport, srcViewport, flags);
    }

    public void readPixels(@IntRange(from=0L) int xoffset, @IntRange(from=0L) int yoffset, @IntRange(from=0L) int width, @IntRange(from=0L) int height, @NonNull Texture.PixelBufferDescriptor buffer) {
        if (buffer.storage.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int result = Renderer.nReadPixels(this.getNativeObject(), this.mEngine.getNativeObject(), xoffset, yoffset, width, height, buffer.storage, buffer.storage.remaining(), buffer.left, buffer.top, buffer.type.ordinal(), buffer.alignment, buffer.stride, buffer.format.ordinal(), buffer.handler, buffer.callback);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public void readPixels(@NonNull RenderTarget renderTarget, @IntRange(from=0L) int xoffset, @IntRange(from=0L) int yoffset, @IntRange(from=0L) int width, @IntRange(from=0L) int height, @NonNull Texture.PixelBufferDescriptor buffer) {
        if (buffer.storage.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int result = Renderer.nReadPixelsEx(this.getNativeObject(), this.mEngine.getNativeObject(), renderTarget.getNativeObject(), xoffset, yoffset, width, height, buffer.storage, buffer.storage.remaining(), buffer.left, buffer.top, buffer.type.ordinal(), buffer.alignment, buffer.stride, buffer.format.ordinal(), buffer.handler, buffer.callback);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public double getUserTime() {
        return Renderer.nGetUserTime(this.getNativeObject());
    }

    public void resetUserTime() {
        Renderer.nResetUserTime(this.getNativeObject());
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed Renderer");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native boolean nBeginFrame(long var0, long var2);

    private static native void nEndFrame(long var0);

    private static native void nRender(long var0, long var2);

    private static native void nCopyFrame(long var0, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    private static native int nReadPixels(long var0, long var2, int var4, int var5, int var6, int var7, Buffer var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, Object var16, Runnable var17);

    private static native int nReadPixelsEx(long var0, long var2, long var4, int var6, int var7, int var8, int var9, Buffer var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, Object var18, Runnable var19);

    private static native double nGetUserTime(long var0);

    private static native void nResetUserTime(long var0);
}

