/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import android.support.annotation.NonNull;

abstract class Platform {
    private static Platform mCurrentPlatform = null;

    static boolean isAndroid() {
        return "The Android Project".equalsIgnoreCase(System.getProperty("java.vendor"));
    }

    static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    static boolean isMacOS() {
        return System.getProperty("os.name").contains("Mac OS X");
    }

    static boolean isLinux() {
        return System.getProperty("os.name").contains("Linux") && !Platform.isAndroid();
    }

    @NonNull
    static Platform get() {
        if (mCurrentPlatform == null) {
            try {
                if (Platform.isAndroid()) {
                    Class<?> clazz = Class.forName("com.google.android.filament.AndroidPlatform");
                    mCurrentPlatform = (Platform)clazz.newInstance();
                } else {
                    Class<?> clazz = Class.forName("com.google.android.filament.DesktopPlatform");
                    mCurrentPlatform = (Platform)clazz.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mCurrentPlatform == null) {
                mCurrentPlatform = new UnknownPlatform();
            }
        }
        return mCurrentPlatform;
    }

    Platform() {
    }

    abstract void log(String var1);

    abstract void warn(String var1);

    abstract boolean validateStreamSource(Object var1);

    abstract boolean validateSurface(Object var1);

    abstract boolean validateSharedContext(Object var1);

    abstract long getSharedContextNativeHandle(Object var1);

    private static class UnknownPlatform
    extends Platform {
        private UnknownPlatform() {
        }

        @Override
        void log(String message) {
            System.out.println(message);
        }

        @Override
        void warn(String message) {
            System.out.println(message);
        }

        @Override
        boolean validateStreamSource(Object object) {
            return false;
        }

        @Override
        boolean validateSurface(Object object) {
            return false;
        }

        @Override
        boolean validateSharedContext(Object object) {
            return false;
        }

        @Override
        long getSharedContextNativeHandle(Object sharedContext) {
            return 0L;
        }
    }
}

