/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import android.support.annotation.NonNull;
import com.google.android.filament.Camera;
import com.google.android.filament.Entity;
import com.google.android.filament.Fence;
import com.google.android.filament.IndexBuffer;
import com.google.android.filament.IndirectLight;
import com.google.android.filament.LightManager;
import com.google.android.filament.Material;
import com.google.android.filament.MaterialInstance;
import com.google.android.filament.NativeSurface;
import com.google.android.filament.Platform;
import com.google.android.filament.RenderTarget;
import com.google.android.filament.RenderableManager;
import com.google.android.filament.Renderer;
import com.google.android.filament.Scene;
import com.google.android.filament.Skybox;
import com.google.android.filament.Stream;
import com.google.android.filament.SwapChain;
import com.google.android.filament.Texture;
import com.google.android.filament.TransformManager;
import com.google.android.filament.VertexBuffer;
import com.google.android.filament.View;
import com.google.android.filament.proguard.UsedByReflection;

public class Engine {
    private long mNativeObject;
    @NonNull
    private final TransformManager mTransformManager;
    @NonNull
    private final LightManager mLightManager;
    @NonNull
    private final RenderableManager mRenderableManager;

    private Engine(long nativeEngine) {
        this.mNativeObject = nativeEngine;
        this.mTransformManager = new TransformManager(Engine.nGetTransformManager(nativeEngine));
        this.mLightManager = new LightManager(Engine.nGetLightManager(nativeEngine));
        this.mRenderableManager = new RenderableManager(Engine.nGetRenderableManager(nativeEngine));
    }

    @NonNull
    public static Engine create() {
        long nativeEngine = Engine.nCreateEngine(0L, 0L);
        if (nativeEngine == 0L) {
            throw new IllegalStateException("Couldn't create Engine");
        }
        return new Engine(nativeEngine);
    }

    @NonNull
    public static Engine create(@NonNull Backend backend) {
        long nativeEngine = Engine.nCreateEngine(backend.ordinal(), 0L);
        if (nativeEngine == 0L) {
            throw new IllegalStateException("Couldn't create Engine");
        }
        return new Engine(nativeEngine);
    }

    @NonNull
    public static Engine create(@NonNull Object sharedContext) {
        if (Platform.get().validateSharedContext(sharedContext)) {
            long nativeEngine = Engine.nCreateEngine(0L, Platform.get().getSharedContextNativeHandle(sharedContext));
            if (nativeEngine == 0L) {
                throw new IllegalStateException("Couldn't create Engine");
            }
            return new Engine(nativeEngine);
        }
        throw new IllegalArgumentException("Invalid shared context " + sharedContext);
    }

    public boolean isValid() {
        return this.mNativeObject != 0L;
    }

    public void destroy() {
        Engine.nDestroyEngine(this.getNativeObject());
        this.clearNativeObject();
    }

    @NonNull
    public Backend getBackend() {
        return Backend.values()[(int)Engine.nGetBackend(this.getNativeObject())];
    }

    @NonNull
    public SwapChain createSwapChain(@NonNull Object surface) {
        return this.createSwapChain(surface, 0L);
    }

    @NonNull
    public SwapChain createSwapChain(@NonNull Object surface, long flags) {
        if (Platform.get().validateSurface(surface)) {
            long nativeSwapChain = Engine.nCreateSwapChain(this.getNativeObject(), surface, flags);
            if (nativeSwapChain == 0L) {
                throw new IllegalStateException("Couldn't create SwapChain");
            }
            return new SwapChain(nativeSwapChain, surface);
        }
        throw new IllegalArgumentException("Invalid surface " + surface);
    }

    @NonNull
    public SwapChain createSwapChain(int width, int height, long flags) {
        if (width >= 0 && height >= 0) {
            long nativeSwapChain = Engine.nCreateSwapChainHeadless(this.getNativeObject(), width, height, flags);
            if (nativeSwapChain == 0L) {
                throw new IllegalStateException("Couldn't create SwapChain");
            }
            return new SwapChain(nativeSwapChain, null);
        }
        throw new IllegalArgumentException("Invalid parameters");
    }

    @NonNull
    public SwapChain createSwapChainFromNativeSurface(@NonNull NativeSurface surface, long flags) {
        long nativeSwapChain = Engine.nCreateSwapChainFromRawPointer(this.getNativeObject(), surface.getNativeObject(), flags);
        if (nativeSwapChain == 0L) {
            throw new IllegalStateException("Couldn't create SwapChain");
        }
        return new SwapChain(nativeSwapChain, surface);
    }

    public void destroySwapChain(@NonNull SwapChain swapChain) {
        Engine.nDestroySwapChain(this.getNativeObject(), swapChain.getNativeObject());
        swapChain.clearNativeObject();
    }

    @NonNull
    public View createView() {
        long nativeView = Engine.nCreateView(this.getNativeObject());
        if (nativeView == 0L) {
            throw new IllegalStateException("Couldn't create View");
        }
        return new View(nativeView);
    }

    public void destroyView(@NonNull View view) {
        Engine.nDestroyView(this.getNativeObject(), view.getNativeObject());
        view.clearNativeObject();
    }

    @NonNull
    public Renderer createRenderer() {
        long nativeRenderer = Engine.nCreateRenderer(this.getNativeObject());
        if (nativeRenderer == 0L) {
            throw new IllegalStateException("Couldn't create Renderer");
        }
        return new Renderer(this, nativeRenderer);
    }

    public void destroyRenderer(@NonNull Renderer renderer) {
        Engine.nDestroyRenderer(this.getNativeObject(), renderer.getNativeObject());
        renderer.clearNativeObject();
    }

    @NonNull
    public Camera createCamera() {
        long nativeCamera = Engine.nCreateCamera(this.getNativeObject());
        if (nativeCamera == 0L) {
            throw new IllegalStateException("Couldn't create Camera");
        }
        return new Camera(nativeCamera);
    }

    @NonNull
    public Camera createCamera(@Entity int entity) {
        long nativeCamera = Engine.nCreateCameraWithEntity(this.getNativeObject(), entity);
        if (nativeCamera == 0L) {
            throw new IllegalStateException("Couldn't create Camera");
        }
        return new Camera(nativeCamera);
    }

    public void destroyCamera(@NonNull Camera camera) {
        Engine.nDestroyCamera(this.getNativeObject(), camera.getNativeObject());
        camera.clearNativeObject();
    }

    @NonNull
    public Scene createScene() {
        long nativeScene = Engine.nCreateScene(this.getNativeObject());
        if (nativeScene == 0L) {
            throw new IllegalStateException("Couldn't create Scene");
        }
        return new Scene(nativeScene);
    }

    public void destroyScene(@NonNull Scene scene) {
        Engine.nDestroyScene(this.getNativeObject(), scene.getNativeObject());
        scene.clearNativeObject();
    }

    public void destroyStream(@NonNull Stream stream) {
        Engine.nDestroyStream(this.getNativeObject(), stream.getNativeObject());
        stream.clearNativeObject();
    }

    @NonNull
    public Fence createFence() {
        long nativeFence = Engine.nCreateFence(this.getNativeObject());
        if (nativeFence == 0L) {
            throw new IllegalStateException("Couldn't create Fence");
        }
        return new Fence(nativeFence);
    }

    public void destroyFence(@NonNull Fence fence) {
        Engine.nDestroyFence(this.getNativeObject(), fence.getNativeObject());
        fence.clearNativeObject();
    }

    public void destroyIndexBuffer(@NonNull IndexBuffer indexBuffer) {
        Engine.nDestroyIndexBuffer(this.getNativeObject(), indexBuffer.getNativeObject());
        indexBuffer.clearNativeObject();
    }

    public void destroyVertexBuffer(@NonNull VertexBuffer vertexBuffer) {
        Engine.nDestroyVertexBuffer(this.getNativeObject(), vertexBuffer.getNativeObject());
        vertexBuffer.clearNativeObject();
    }

    public void destroyIndirectLight(@NonNull IndirectLight ibl) {
        Engine.nDestroyIndirectLight(this.getNativeObject(), ibl.getNativeObject());
        ibl.clearNativeObject();
    }

    public void destroyMaterial(@NonNull Material material) {
        Engine.nDestroyMaterial(this.getNativeObject(), material.getNativeObject());
        material.clearNativeObject();
    }

    public void destroyMaterialInstance(@NonNull MaterialInstance materialInstance) {
        Engine.nDestroyMaterialInstance(this.getNativeObject(), materialInstance.getNativeObject());
        materialInstance.clearNativeObject();
    }

    public void destroySkybox(@NonNull Skybox skybox) {
        Engine.nDestroySkybox(this.getNativeObject(), skybox.getNativeObject());
        skybox.clearNativeObject();
    }

    public void destroyTexture(@NonNull Texture texture) {
        Engine.nDestroyTexture(this.getNativeObject(), texture.getNativeObject());
        texture.clearNativeObject();
    }

    public void destroyRenderTarget(@NonNull RenderTarget target) {
        Engine.nDestroyRenderTarget(this.getNativeObject(), target.getNativeObject());
        target.clearNativeObject();
    }

    public void destroyEntity(@Entity int entity) {
        Engine.nDestroyEntity(this.getNativeObject(), entity);
    }

    @NonNull
    public TransformManager getTransformManager() {
        return this.mTransformManager;
    }

    @NonNull
    public LightManager getLightManager() {
        return this.mLightManager;
    }

    @NonNull
    public RenderableManager getRenderableManager() {
        return this.mRenderableManager;
    }

    public void flushAndWait() {
        Engine.nFlushAndWait(this.getNativeObject());
    }

    @UsedByReflection(value="TextureHelper.java")
    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed Engine");
        }
        return this.mNativeObject;
    }

    private void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native long nCreateEngine(long var0, long var2);

    private static native void nDestroyEngine(long var0);

    private static native long nGetBackend(long var0);

    private static native long nCreateSwapChain(long var0, Object var2, long var3);

    private static native long nCreateSwapChainHeadless(long var0, int var2, int var3, long var4);

    private static native long nCreateSwapChainFromRawPointer(long var0, long var2, long var4);

    private static native void nDestroySwapChain(long var0, long var2);

    private static native long nCreateView(long var0);

    private static native void nDestroyView(long var0, long var2);

    private static native long nCreateRenderer(long var0);

    private static native void nDestroyRenderer(long var0, long var2);

    private static native long nCreateCamera(long var0);

    private static native long nCreateCameraWithEntity(long var0, int var2);

    private static native void nDestroyCamera(long var0, long var2);

    private static native long nCreateScene(long var0);

    private static native void nDestroyScene(long var0, long var2);

    private static native long nCreateFence(long var0);

    private static native void nDestroyFence(long var0, long var2);

    private static native void nDestroyStream(long var0, long var2);

    private static native void nDestroyIndexBuffer(long var0, long var2);

    private static native void nDestroyVertexBuffer(long var0, long var2);

    private static native void nDestroyIndirectLight(long var0, long var2);

    private static native void nDestroyMaterial(long var0, long var2);

    private static native void nDestroyMaterialInstance(long var0, long var2);

    private static native void nDestroySkybox(long var0, long var2);

    private static native void nDestroyTexture(long var0, long var2);

    private static native void nDestroyRenderTarget(long var0, long var2);

    private static native void nDestroyEntity(long var0, int var2);

    private static native void nFlushAndWait(long var0);

    private static native long nGetTransformManager(long var0);

    private static native long nGetLightManager(long var0);

    private static native long nGetRenderableManager(long var0);

    public static enum Backend {
        DEFAULT,
        OPENGL,
        VULKAN,
        NOOP;

    }
}

