/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import android.support.annotation.NonNull;
import android.support.annotation.Size;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public class Colors {
    private Colors() {
    }

    @NonNull
    @Size(value=3L)
    public static float[] toLinear(@NonNull RgbType type, float r, float g, float b) {
        return Colors.toLinear(type, new float[]{r, g, b});
    }

    @NonNull
    @Size(min=3L)
    public static float[] toLinear(@NonNull RgbType type, @NonNull @Size(min=3L) float[] rgb) {
        return type == RgbType.LINEAR ? rgb : Colors.toLinear(Conversion.ACCURATE, rgb);
    }

    @NonNull
    @Size(value=4L)
    public static float[] toLinear(@NonNull RgbaType type, float r, float g, float b, float a) {
        return Colors.toLinear(type, new float[]{r, g, b, a});
    }

    @NonNull
    @Size(min=4L)
    public static float[] toLinear(@NonNull RgbaType type, @NonNull @Size(min=4L) float[] rgba) {
        switch (type) {
            case SRGB: {
                Colors.toLinear(Conversion.ACCURATE, rgba);
            }
            case LINEAR: {
                float a = rgba[3];
                rgba[0] = rgba[0] * a;
                rgba[1] = rgba[1] * a;
                rgba[2] = rgba[2] * a;
                return rgba;
            }
            case PREMULTIPLIED_SRGB: {
                return Colors.toLinear(Conversion.ACCURATE, rgba);
            }
            case PREMULTIPLIED_LINEAR: {
                return rgba;
            }
        }
        return rgba;
    }

    @NonNull
    public static float[] toLinear(@NonNull Conversion conversion, @NonNull @Size(min=3L) float[] rgb) {
        switch (conversion) {
            case ACCURATE: {
                for (int i = 0; i < 3; ++i) {
                    rgb[i] = rgb[i] <= 0.04045f ? rgb[i] / 12.92f : (float)Math.pow((rgb[i] + 0.055f) / 1.055f, 2.4f);
                }
                break;
            }
            case FAST: {
                for (int i = 0; i < 3; ++i) {
                    rgb[i] = (float)Math.sqrt(rgb[i]);
                }
                break;
            }
        }
        return rgb;
    }

    @NonNull
    @Size(value=3L)
    public static float[] cct(float temperature) {
        float[] color = new float[3];
        Colors.nCct(temperature, color);
        return color;
    }

    @NonNull
    @Size(value=3L)
    public static float[] illuminantD(float temperature) {
        float[] color = new float[3];
        Colors.nIlluminantD(temperature, color);
        return color;
    }

    private static native void nCct(float var0, @NonNull @Size(value=3L) float[] var1);

    private static native void nIlluminantD(float var0, @NonNull @Size(value=3L) float[] var1);

    public static enum Conversion {
        ACCURATE,
        FAST;

    }

    public static enum RgbaType {
        SRGB,
        LINEAR,
        PREMULTIPLIED_SRGB,
        PREMULTIPLIED_LINEAR;

    }

    public static enum RgbType {
        SRGB,
        LINEAR;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.LOCAL_VARIABLE, ElementType.FIELD})
    public static @interface LinearColor {
    }
}

