/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.RetryParametersXml;
import com.google.borg.borgcron.GrocTimeSpecification;
import java.util.ArrayList;
import java.util.List;

public class CronXml {
    private List<Entry> entries = new ArrayList<Entry>();

    public Entry addNewEntry() {
        this.validateLastEntry();
        Entry entry = new Entry();
        this.entries.add(entry);
        return entry;
    }

    public void addEntry(Entry entry) {
        this.validateLastEntry();
        this.entries.add(entry);
        this.validateLastEntry();
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void validateLastEntry() {
        if (this.entries.size() == 0) {
            return;
        }
        Entry last = this.entries.get(this.entries.size() - 1);
        if (last.getUrl() == null) {
            throw new AppEngineConfigException("no URL for cronentry");
        }
        if (last.getSchedule() == null) {
            throw new AppEngineConfigException("no schedule for cronentry " + last.getUrl());
        }
        try {
            GrocTimeSpecification grocTimeSpecification = GrocTimeSpecification.create(last.schedule);
        }
        catch (IllegalArgumentException iae) {
            throw new AppEngineConfigException("schedule " + last.schedule + " failed to parse", iae.getCause());
        }
    }

    public String toYaml() {
        this.validateLastEntry();
        StringBuilder builder = new StringBuilder("cron:\n");
        for (Entry ent : this.entries) {
            RetryParametersXml retryParameters;
            builder.append("- description: '" + ent.getDescription().replace("'", "''") + "'\n");
            builder.append("  url: " + ent.getUrl() + "\n");
            builder.append("  schedule: " + ent.getSchedule() + "\n");
            builder.append("  timezone: " + ent.getTimezone() + "\n");
            String target = ent.getTarget();
            if (target != null) {
                builder.append("  target: " + target + "\n");
            }
            if ((retryParameters = ent.getRetryParameters()) != null) {
                builder.append(retryParameters.toYaml("job"));
            }
            if (ent.getAttemptDeadline() == null) continue;
            builder.append("  attempt_deadline: '").append(ent.getAttemptDeadline()).append("'\n");
        }
        return builder.toString();
    }

    public static class Entry {
        private static final String TZ_GMT = "UTC";
        private String url = null;
        private String desc = "";
        private String tz = "UTC";
        private String schedule = null;
        private String target = null;
        private RetryParametersXml retryParameters = null;
        private String attemptDeadline = null;

        public void setDescription(String description) {
            this.desc = description.replace('\n', ' ');
        }

        public void setUrl(String url) {
            this.url = url.replace('\n', ' ');
        }

        public void setSchedule(String schedule) {
            this.schedule = schedule = schedule.replace('\n', ' ');
        }

        public void setTimezone(String timezone) {
            this.tz = timezone.replace('\n', ' ');
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public void setRetryParameters(RetryParametersXml retryParameters) {
            this.retryParameters = retryParameters;
        }

        public void setAttemptDeadline(String attemptDeadline) {
            this.attemptDeadline = attemptDeadline;
        }

        public String getUrl() {
            return this.url;
        }

        public String getDescription() {
            return this.desc;
        }

        public String getSchedule() {
            return this.schedule;
        }

        public String getTimezone() {
            return this.tz;
        }

        public String getTarget() {
            return this.target;
        }

        public RetryParametersXml getRetryParameters() {
            return this.retryParameters;
        }

        public String getAttemptDeadline() {
            return this.attemptDeadline;
        }
    }
}

