/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AbstractServerConnection;
import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.HttpIoException;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class OAuth2ServerConnection
extends AbstractServerConnection {
    public OAuth2ServerConnection(AppAdminFactory.ConnectOptions options) {
        super(options);
    }

    @Override
    protected void doHandleSendErrors(int status, URL url, HttpURLConnection conn, BufferedReader connReader) throws IOException {
        String reason = conn.getHeaderField("X-OAuth-Error");
        if (status == 401) {
            if ("InvalidOAuthToken".equals(reason)) {
                throw new OAuthInvalidTokenException(this.constructHttpErrorMessage(conn, connReader));
            }
            if ("BadOAuthRequest".equals(reason) || "OAuthError".equals(reason)) {
                throw new OAuthException(this.constructHttpErrorMessage(conn, connReader));
            }
            throw new HttpIoException(this.constructHttpErrorMessage(conn, connReader), status);
        }
        if (status == 403) {
            logger.logp(Level.FINER, "com.google.appengine.tools.admin.OAuth2ServerConnection", "doHandleSendErrors", this.constructHttpErrorMessage(conn, connReader));
        } else if ((status < 500 || status > 600) && status == 302) {
            Map<String, List<String>> headers = conn.getHeaderFields();
            String location = headers.get("Location").get(0);
            logger.logp(Level.FINER, "com.google.appengine.tools.admin.OAuth2ServerConnection", "doHandleSendErrors", new StringBuilder(44 + String.valueOf(location).length()).append("Redirect Location: ").append(location).append(", not following redirect.").toString());
        }
    }

    @Override
    protected void doPostConnect(String method, HttpURLConnection conn, AbstractServerConnection.DataPoster data) {
    }

    @Override
    protected void doPreConnect(String method, HttpURLConnection conn, AbstractServerConnection.DataPoster data) {
        if (this.options.getOauthToken() != null) {
            String string = String.valueOf(this.options.getOauthToken());
            conn.setRequestProperty("Authorization", string.length() != 0 ? "OAuth ".concat(string) : new String("OAuth "));
        }
    }

    public static class OAuthInvalidTokenException
    extends OAuthException {
        public OAuthInvalidTokenException(String s) {
            super(s);
        }

        public OAuthInvalidTokenException(String s, Throwable c) {
            super(s, c);
        }
    }

    public static class OAuthException
    extends IOException {
        public OAuthException(String s) {
            super(s);
        }

        public OAuthException(String s, Throwable c) {
            super(s);
            this.initCause(c);
        }
    }
}

