/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AppAdmin;
import com.google.appengine.tools.admin.AppAdminImpl;
import com.google.appengine.tools.admin.AppVersionUpload;
import com.google.appengine.tools.admin.Application;
import com.google.appengine.tools.admin.ApplicationProcessingOptions;
import com.google.appengine.tools.util.ClientCookieManager;
import com.google.apphosting.utils.config.StagingOptions;
import java.io.File;
import java.io.PrintWriter;

public class AppAdminFactory {
    private ApplicationProcessingOptions appOptions = new ApplicationProcessingOptions();
    private Class<? extends AppVersionUpload> appVersionUploadClass = AppVersionUpload.class;

    public AppAdmin createAppAdmin(ConnectOptions options, Application app, PrintWriter errorWriter) {
        return new AppAdminImpl(options, app, errorWriter, this.appOptions, this.appVersionUploadClass);
    }

    public ApplicationProcessingOptions getAppOptions() {
        return this.appOptions;
    }

    public Class<? extends AppVersionUpload> getAppVersionUploadClass() {
        return this.appVersionUploadClass;
    }

    public void setAppVersionUploadClass(Class<? extends AppVersionUpload> klass) {
        this.appVersionUploadClass = klass;
    }

    public void setJavaExecutable(File java) {
        this.appOptions.setJavaExecutable(java);
    }

    public void setJavaCompiler(File javac) {
        this.appOptions.setJavaCompiler(javac);
    }

    public void setCompileJsps(boolean flag) {
        this.appOptions.setCompileJsps(flag);
    }

    public void setDefaultStagingOptions(StagingOptions opts) {
        this.appOptions.setDefaultStagingOptions(opts);
    }

    public void setStagingOptions(StagingOptions opts) {
        this.appOptions.setStagingOptions(opts);
    }

    public void setBatchMode(boolean flag) {
        this.appOptions.setBatchMode(flag);
    }

    public void setUseAsyncQuickstart(boolean async) {
        this.appOptions.setUseAsyncQuickstart(async);
    }

    @Deprecated
    public void setUseJava8(boolean java8) {
        System.err.println("The method setUseJava8() in AppAdminFactory class is now a no-op.");
    }

    public void setRuntime(String runtime) {
        this.appOptions.setRuntime(runtime);
    }

    public void setAllowAnyRuntime(boolean allowAnyRuntime) {
        this.appOptions.setAllowAnyRuntime(allowAnyRuntime);
    }

    public void setFailOnPrecompilationError(boolean fail) {
        this.appOptions.setFailOnPrecompilationError(fail);
    }

    public void setIgnoreEndpointsFailures(boolean ignore) {
        this.appOptions.setIgnoreEndpointsFailures(ignore);
    }

    public void setQuickstart(boolean enable) {
        this.appOptions.setQuickstart(enable);
    }

    public void setCallerUploadingDispatch(boolean b) {
        this.appOptions.setCallerUploadingDispatch(b);
    }

    public static class ConnectOptions {
        private String userId;
        private String server = "appengine.google.com";
        private String host;
        private String sdkRoot;
        boolean keepUpload;
        private ClientCookieManager cookies;
        private PasswordPrompt passwordPrompt;
        private boolean secure = true;
        private String oauthToken;
        private boolean usePersistedCredentials = true;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public PasswordPrompt getPasswordPrompt() {
            return this.passwordPrompt;
        }

        public void setPasswordPrompt(PasswordPrompt prompt) {
            this.passwordPrompt = prompt;
        }

        public String getServer() {
            return this.server;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setRetainUploadDir(boolean flag) {
            this.keepUpload = flag;
        }

        public boolean getRetainUploadDir() {
            return this.keepUpload;
        }

        public String getSdkRoot() {
            return this.sdkRoot;
        }

        public void setSdkRoot(String sdkRoot) {
            this.sdkRoot = sdkRoot;
        }

        public ClientCookieManager getCookies() {
            return this.cookies;
        }

        public void setCookies(ClientCookieManager cookies) {
            this.cookies = cookies;
        }

        public boolean getSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public void setOauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
        }

        public String getOauthToken() {
            return this.oauthToken;
        }

        public void setUsePersistedCredentials(boolean usePersistedCredentials) {
            this.usePersistedCredentials = usePersistedCredentials;
        }

        public boolean getUsePersistedCredentials() {
            return this.usePersistedCredentials;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectOptions that = (ConnectOptions)o;
            if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
                return false;
            }
            if (this.server != null ? !this.server.equals(that.server) : that.server != null) {
                return false;
            }
            if (this.userId != null ? !this.userId.equals(that.userId) : that.userId != null) {
                return false;
            }
            return !(this.sdkRoot != null ? !this.sdkRoot.equals(that.sdkRoot) : that.sdkRoot != null);
        }

        public int hashCode() {
            int result = this.userId != null ? this.userId.hashCode() : 0;
            result = 31 * result + (this.server != null ? this.server.hashCode() : 0);
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + (this.sdkRoot != null ? this.sdkRoot.hashCode() : 0);
            return result;
        }
    }

    public static interface PasswordPrompt {
        public String getPassword();
    }
}

