/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend.system;

import com.google.appengine.repackaged.com.google.common.flogger.backend.LoggerBackend;
import com.google.appengine.repackaged.com.google.common.flogger.backend.NoOpContextDataProvider;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Platform;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.BackendFactory;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.Clock;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.LoggingContext;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.SimpleBackendFactory;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.StackBasedCallerFinder;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.SystemClock;
import com.google.appengine.repackaged.com.google.common.flogger.context.ContextDataProvider;
import com.google.appengine.repackaged.com.google.common.flogger.context.Tags;
import com.google.appengine.repackaged.com.google.common.flogger.util.StaticMethodCaller;
import java.util.logging.Level;

public class DefaultPlatform
extends Platform {
    private static final String BACKEND_FACTORY = "flogger.backend_factory";
    private static final String LOGGING_CONTEXT = "flogger.logging_context";
    private static final String CLOCK = "flogger.clock";
    private final BackendFactory backendFactory;
    private final ContextDataProvider context;
    private final Clock clock;
    private final Platform.LogCallerFinder callerFinder;

    public DefaultPlatform() {
        BackendFactory factory = StaticMethodCaller.callGetterFromSystemProperty(BACKEND_FACTORY, BackendFactory.class);
        this.backendFactory = factory != null ? factory : SimpleBackendFactory.getInstance();
        ContextDataProvider context = StaticMethodCaller.callGetterFromSystemProperty(LOGGING_CONTEXT, ContextDataProvider.class);
        this.context = context != null ? context : NoOpContextDataProvider.getInstance();
        Clock clock = StaticMethodCaller.callGetterFromSystemProperty(CLOCK, Clock.class);
        this.clock = clock != null ? clock : SystemClock.getInstance();
        this.callerFinder = StackBasedCallerFinder.getInstance();
    }

    DefaultPlatform(BackendFactory factory, LoggingContext context, Clock clock, Platform.LogCallerFinder callerFinder) {
        this.backendFactory = factory;
        this.context = context;
        this.clock = clock;
        this.callerFinder = callerFinder;
    }

    @Override
    protected Platform.LogCallerFinder getCallerFinderImpl() {
        return this.callerFinder;
    }

    @Override
    protected LoggerBackend getBackendImpl(String className) {
        return this.backendFactory.create(className);
    }

    @Override
    protected ContextDataProvider getContextDataProviderImpl() {
        return this.context;
    }

    @Override
    protected boolean shouldForceLoggingImpl(String loggerName, Level level, boolean isEnabled) {
        return this.context.shouldForceLogging(loggerName, level, isEnabled);
    }

    @Override
    protected Tags getInjectedTagsImpl() {
        return this.context.getTags();
    }

    @Override
    protected long getCurrentTimeNanosImpl() {
        return this.clock.getCurrentTimeNanos();
    }

    @Override
    protected String getConfigInfoImpl() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.backendFactory);
        String string3 = String.valueOf(this.clock);
        String string4 = String.valueOf(this.context);
        String string5 = String.valueOf(this.callerFinder);
        return new StringBuilder(71 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("Platform: ").append(string).append("\nBackendFactory: ").append(string2).append("\nClock: ").append(string3).append("\nLoggingContext: ").append(string4).append("\nLogCallerFinder: ").append(string5).append("\n").toString();
    }
}

