/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend.google;

final class ShutdownChecker {
    private static final String LOG_DURING_SHUTDOWN_PROP_NAME = "google.debug_logs.log_to_stderr_during_shutdown";
    private static final String DEFAULT_LOG_DURING_SHUTDOWN_PROP_VALUE = "true";
    private final boolean logDuringShutdown = Boolean.parseBoolean(System.getProperty("google.debug_logs.log_to_stderr_during_shutdown", "true"));
    private boolean isSystemShutdown;
    private static final ShutdownChecker instance = new ShutdownChecker();

    private ShutdownChecker() {
        try {
            if (!ShutdownChecker.isOnForge()) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        ShutdownChecker.this.enterSystemShutdown();
                    }
                });
            }
        }
        catch (Error | RuntimeException e) {
            String string = String.valueOf(e.getClass());
            ShutdownChecker.logToSterr("ShutdownChecker", new StringBuilder(48 + String.valueOf(string).length()).append("Unable to register Flogger shutdown hook due to ").append(string).toString());
        }
    }

    private static boolean isOnForge() {
        return "1".equals(System.getenv("UNITTEST_ON_BORG"));
    }

    private void enterSystemShutdown() {
        if (!this.logDuringShutdown) {
            return;
        }
        ShutdownChecker.logToSterr("enterSystemShutdown", "Flogger entering shutdown mode; will start logging to stderr.");
        this.isSystemShutdown = true;
    }

    public static boolean isInSystemShutdown() {
        return ShutdownChecker.instance.isSystemShutdown;
    }

    private static void logToSterr(String method, String message) {
        System.err.printf("%1$ty%1$tm%1$td %1$tT.%1$tL:I %2$s [%3$s] [%4$s.%5$s] %6$s%n", System.currentTimeMillis(), Thread.currentThread().getId(), Thread.currentThread().getName(), "com.google.appengine.repackaged.com.google.common.flogger.backend.google.ShutdownChecker", method, message);
    }
}

