/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.query;

import com.google.appengine.api.search.query.QueryLexer;
import com.google.appengine.api.search.query.QueryParser;
import com.google.appengine.api.search.query.QueryParserFactory;
import com.google.common.base.Preconditions;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;

public class QueryTreeBuilder {
    private static final ThreadLocal<QueryLexer> LEXER_POOL = new ThreadLocal<QueryLexer>(){

        @Override
        protected QueryLexer initialValue() {
            return new QueryLexer();
        }
    };
    private final QueryParserFactory parserFactory;
    private final CommonTreeAdaptor adaptor = new CommonTreeAdaptor();

    public QueryTreeBuilder() {
        this.parserFactory = new QueryParserFactory();
    }

    public QueryTreeBuilder(QueryParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    public CommonTree parse(String query) throws RecognitionException {
        Preconditions.checkNotNull((Object)query, (Object)"query must not be null");
        ANTLRStringStream stream = new ANTLRStringStream(query);
        QueryLexer lexer = LEXER_POOL.get();
        lexer.setCharStream((CharStream)stream);
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        QueryParser parser = this.parserFactory.newParser(tokens);
        CommonTree tree = parser.query().getTree();
        if (tree.getType() == 11 && tree.getChildCount() == 0) {
            tree = (CommonTree)this.adaptor.nil();
        }
        return tree;
    }
}

