/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class IndexChecker {
    public static String checkName(String indexName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)indexName) ? 1 : 0) != 0, (Object)"Index name null or empty");
        Preconditions.checkArgument((indexName.length() <= 100 ? 1 : 0) != 0, (String)"Index name longer than %s characters: %s", (int)100, (Object)indexName);
        Preconditions.checkArgument((boolean)IndexChecker.isAsciiVisiblePrintable(indexName), (String)"Index name must be ASCII visible printable: %s", (Object)indexName);
        Preconditions.checkArgument((!IndexChecker.isReserved(indexName) ? 1 : 0) != 0, (String)"Index name must not start with !: %s", (Object)indexName);
        return indexName;
    }

    static boolean isAsciiVisiblePrintable(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) >= '!' && str.charAt(i) <= '~') continue;
            return false;
        }
        return true;
    }

    static boolean isReserved(String str) {
        return str.startsWith("!") || str.length() > 3 && str.startsWith("__") && str.endsWith("__");
    }
}

