/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Cursor;
import com.google.appengine.api.search.DeleteException;
import com.google.appengine.api.search.Document;
import com.google.appengine.api.search.FacetResult;
import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.FutureHelper;
import com.google.appengine.api.search.GetException;
import com.google.appengine.api.search.GetRequest;
import com.google.appengine.api.search.GetResponse;
import com.google.appengine.api.search.Index;
import com.google.appengine.api.search.IndexSpec;
import com.google.appengine.api.search.OperationResult;
import com.google.appengine.api.search.PutException;
import com.google.appengine.api.search.PutResponse;
import com.google.appengine.api.search.Query;
import com.google.appengine.api.search.Results;
import com.google.appengine.api.search.Schema;
import com.google.appengine.api.search.ScoredDocument;
import com.google.appengine.api.search.SearchApiHelper;
import com.google.appengine.api.search.SearchException;
import com.google.appengine.api.search.SearchServiceConfig;
import com.google.appengine.api.search.StatusCode;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.DocumentChecker;
import com.google.appengine.api.search.proto.SearchServicePb;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.apphosting.api.search.DocumentPb;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;

class IndexImpl
implements Index {
    private final SearchApiHelper apiHelper;
    private final IndexSpec spec;
    private final Schema schema;
    private final SearchServiceConfig config;
    private final Long storageUsage;
    private final Long storageLimit;

    IndexImpl(SearchApiHelper apiHelper, SearchServiceConfig config, IndexSpec indexSpec) {
        this(apiHelper, config, indexSpec, null, null, null);
    }

    IndexImpl(SearchApiHelper apiHelper, SearchServiceConfig config, IndexSpec indexSpec, Schema schema, Long amount, Long limit) {
        this.apiHelper = (SearchApiHelper)Preconditions.checkNotNull((Object)apiHelper, (Object)"Internal error");
        Preconditions.checkNotNull((Object)config.getNamespace(), (Object)"Internal error");
        this.spec = (IndexSpec)Preconditions.checkNotNull((Object)indexSpec, (Object)"Internal error");
        this.schema = schema;
        this.config = config;
        this.storageUsage = amount;
        this.storageLimit = limit;
    }

    @Override
    public String getName() {
        return this.spec.getName();
    }

    @Override
    public String getNamespace() {
        return this.config.getNamespace();
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    private RuntimeException noStorageInfo() {
        return new UnsupportedOperationException("Storage information is not available");
    }

    @Override
    public long getStorageUsage() {
        if (this.storageUsage == null) {
            throw this.noStorageInfo();
        }
        return this.storageUsage;
    }

    @Override
    public long getStorageLimit() {
        if (this.storageLimit == null) {
            throw this.noStorageInfo();
        }
        return this.storageLimit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.spec.hashCode();
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        result = 31 * result + (this.storageUsage == null ? 0 : this.storageUsage.hashCode());
        result = 31 * result + (this.storageLimit == null ? 0 : this.storageLimit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndexImpl)) {
            return false;
        }
        IndexImpl other = (IndexImpl)obj;
        return Util.equalObjects(this.spec, other.spec) && Util.equalObjects(this.schema, other.schema) && Util.equalObjects(this.storageUsage, other.storageUsage) && Util.equalObjects(this.storageLimit, other.storageLimit);
    }

    public String toString() {
        String storageInfo = this.storageUsage == null || this.storageLimit == null ? "(no storage data)" : String.format(" (%d/%d)", (long)this.storageUsage, (long)this.storageLimit);
        return String.format("IndexImpl{namespace: %s, %s, %s%s}", this.config.getNamespace(), this.spec, this.schema == null ? "(null schema)" : this.schema, storageInfo);
    }

    @Override
    public Future<Void> deleteSchemaAsync() {
        SearchServicePb.DeleteSchemaParams.Builder builder = SearchServicePb.DeleteSchemaParams.newBuilder().addIndexSpec(this.spec.copyToProtocolBuffer(this.config.getNamespace()));
        Future<SearchServicePb.DeleteSchemaResponse.Builder> future = this.apiHelper.makeAsyncDeleteSchemaCall(builder, this.config.getDeadline());
        return new FutureWrapper<SearchServicePb.DeleteSchemaResponse.Builder, Void>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new DeleteException(result);
            }

            @Override
            protected Void wrap(SearchServicePb.DeleteSchemaResponse.Builder key) throws Exception {
                SearchServicePb.DeleteSchemaResponse response = key.build();
                ArrayList<OperationResult> results = new ArrayList<OperationResult>(response.getStatusCount());
                for (SearchServicePb.RequestStatus status : response.getStatusList()) {
                    results.add(new OperationResult(status));
                }
                if (response.getStatusList().size() != 1) {
                    throw new DeleteException(new OperationResult(StatusCode.INTERNAL_ERROR, String.format("Expected 1 removed schema, but got %d", response.getStatusList().size())), results);
                }
                for (OperationResult result : results) {
                    if (result.getCode() == StatusCode.OK) continue;
                    throw new DeleteException(result, results);
                }
                return null;
            }
        };
    }

    @Override
    public Future<Void> deleteAsync(String ... documentIds) {
        return this.deleteAsync(Arrays.asList(documentIds));
    }

    @Override
    public Future<Void> deleteAsync(Iterable<String> documentIds) {
        Preconditions.checkArgument((documentIds != null ? 1 : 0) != 0, (Object)"Delete documents given null collection of document ids");
        SearchServicePb.DeleteDocumentParams.Builder builder = SearchServicePb.DeleteDocumentParams.newBuilder().setIndexSpec(this.spec.copyToProtocolBuffer(this.config.getNamespace()));
        int size = 0;
        for (String documentId : documentIds) {
            ++size;
            builder.addDocId(DocumentChecker.checkDocumentId(documentId));
        }
        if (size > 200) {
            throw new IllegalArgumentException(String.format("number of doc ids, %s, exceeds maximum %s", size, 200));
        }
        final int documentIdsSize = size;
        Future<SearchServicePb.DeleteDocumentResponse.Builder> future = this.apiHelper.makeAsyncDeleteDocumentCall(builder, this.config.getDeadline());
        return new FutureWrapper<SearchServicePb.DeleteDocumentResponse.Builder, Void>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new DeleteException(result);
            }

            @Override
            protected Void wrap(SearchServicePb.DeleteDocumentResponse.Builder key) throws Exception {
                SearchServicePb.DeleteDocumentResponse response = key.build();
                ArrayList<OperationResult> results = new ArrayList<OperationResult>(response.getStatusCount());
                for (SearchServicePb.RequestStatus status : response.getStatusList()) {
                    results.add(new OperationResult(status));
                }
                if (documentIdsSize != response.getStatusList().size()) {
                    throw new DeleteException(new OperationResult(StatusCode.INTERNAL_ERROR, String.format("Expected %d removed documents, but got %d", documentIdsSize, response.getStatusList().size())), results);
                }
                for (OperationResult result : results) {
                    if (result.getCode() == StatusCode.OK) continue;
                    throw new DeleteException(result, results);
                }
                return null;
            }
        };
    }

    @Override
    public Future<PutResponse> putAsync(Document ... documents) {
        return this.putAsync(Arrays.asList(documents));
    }

    @Override
    public Future<PutResponse> putAsync(Document.Builder ... builders) {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (int i = 0; i < builders.length; ++i) {
            documents.add(builders[i].build());
        }
        return this.putAsync(documents);
    }

    @Override
    public Future<PutResponse> putAsync(Iterable<Document> documents) {
        Preconditions.checkNotNull(documents, (Object)"document list cannot be null");
        if (Iterables.isEmpty(documents)) {
            return new FutureHelper.FakeFuture<PutResponse>(new PutResponse(Collections.emptyList(), Collections.emptyList()));
        }
        SearchServicePb.IndexDocumentParams.Builder builder = SearchServicePb.IndexDocumentParams.newBuilder().setIndexSpec(this.spec.copyToProtocolBuffer(this.config.getNamespace()));
        HashMap<String, Document> docMap = new HashMap<String, Document>();
        int size = 0;
        for (Document document : documents) {
            Document other = null;
            if (document.getId() != null) {
                other = docMap.put(document.getId(), document);
            }
            if (other != null && !document.isIdenticalTo(other)) {
                throw new IllegalArgumentException(String.format("Put request with documents with the same ID \"%s\" but different content", document.getId()));
            }
            if (other != null) continue;
            ++size;
            builder.addDocument(((Document)Preconditions.checkNotNull((Object)document, (Object)"document cannot be null")).copyToProtocolBuffer());
        }
        if (size > 200) {
            throw new IllegalArgumentException(String.format("number of documents, %s, exceeds maximum %s", size, 200));
        }
        final int documentsSize = size;
        Future<SearchServicePb.IndexDocumentResponse.Builder> future = this.apiHelper.makeAsyncIndexDocumentCall(builder, this.config.getDeadline());
        return new FutureWrapper<SearchServicePb.IndexDocumentResponse.Builder, PutResponse>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new PutException(result);
            }

            @Override
            protected PutResponse wrap(SearchServicePb.IndexDocumentResponse.Builder key) throws Exception {
                SearchServicePb.IndexDocumentResponse response = key.build();
                List<OperationResult> results = this.newOperationResultList(response);
                if (documentsSize != response.getStatusList().size()) {
                    throw new PutException(new OperationResult(StatusCode.INTERNAL_ERROR, String.format("Expected %d indexed documents, but got %d", documentsSize, response.getStatusList().size())), results, (List<String>)response.getDocIdList());
                }
                for (OperationResult result : results) {
                    if (result.getCode() == StatusCode.OK) continue;
                    throw new PutException(result, results, (List<String>)response.getDocIdList());
                }
                return new PutResponse(results, (List<String>)response.getDocIdList());
            }

            private List<OperationResult> newOperationResultList(SearchServicePb.IndexDocumentResponse response) {
                ArrayList<OperationResult> results = new ArrayList<OperationResult>(response.getStatusCount());
                for (SearchServicePb.RequestStatus status : response.getStatusList()) {
                    results.add(new OperationResult(status));
                }
                return results;
            }
        };
    }

    private Future<Results<ScoredDocument>> executeSearchForResults(SearchServicePb.SearchParams.Builder params) {
        Future<SearchServicePb.SearchResponse.Builder> future = this.apiHelper.makeAsyncSearchCall(params, this.config.getDeadline());
        return new FutureWrapper<SearchServicePb.SearchResponse.Builder, Results<ScoredDocument>>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new SearchException(result);
            }

            @Override
            protected Results<ScoredDocument> wrap(SearchServicePb.SearchResponse.Builder key) throws Exception {
                SearchServicePb.SearchResponse response = key.build();
                SearchServicePb.RequestStatus status = response.getStatus();
                if (status.getCode() != SearchServicePb.SearchServiceError.ErrorCode.OK) {
                    throw new SearchException(new OperationResult(status));
                }
                ArrayList<ScoredDocument> scoredDocs = new ArrayList<ScoredDocument>();
                for (Object result : response.getResultList()) {
                    ArrayList<Field> expressions = new ArrayList<Field>();
                    for (DocumentPb.Field expression : result.getExpressionList()) {
                        expressions.add(Field.newBuilder(expression).build());
                    }
                    ScoredDocument.Builder scoredDocBuilder = ScoredDocument.newBuilder(result.getDocument());
                    for (Double score : result.getScoreList()) {
                        scoredDocBuilder.addScore(score);
                    }
                    for (Field expression : expressions) {
                        scoredDocBuilder.addExpression(expression);
                    }
                    if (result.hasCursor()) {
                        scoredDocBuilder.setCursor(Cursor.newBuilder().build("true:" + result.getCursor()));
                    }
                    scoredDocs.add(scoredDocBuilder.build());
                }
                ArrayList<FacetResult> facetResults = new ArrayList<FacetResult>();
                for (SearchServicePb.FacetResult result : response.getFacetResultList()) {
                    facetResults.add(FacetResult.newBuilder(result).build());
                }
                Results<ScoredDocument> scoredResults = new Results<ScoredDocument>(new OperationResult(status), scoredDocs, response.getMatchedCount(), response.getResultCount(), response.hasCursor() ? Cursor.newBuilder().build("false:" + response.getCursor()) : null, facetResults);
                return scoredResults;
            }
        };
    }

    @Override
    public Future<Results<ScoredDocument>> searchAsync(String query) {
        return this.searchAsync(Query.newBuilder().build((String)Preconditions.checkNotNull((Object)query, (Object)"query cannot be null")));
    }

    @Override
    public Future<Results<ScoredDocument>> searchAsync(Query query) {
        Preconditions.checkNotNull((Object)query, (Object)"query cannot be null");
        return this.executeSearchForResults(query.copyToProtocolBuffer().setIndexSpec(this.spec.copyToProtocolBuffer(this.config.getNamespace())));
    }

    @Override
    public Future<GetResponse<Document>> getRangeAsync(GetRequest.Builder builder) {
        return this.getRangeAsync(builder.build());
    }

    @Override
    public Future<GetResponse<Document>> getRangeAsync(GetRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"list documents request cannot be null");
        SearchServicePb.ListDocumentsParams.Builder params = request.copyToProtocolBuffer().setIndexSpec(this.spec.copyToProtocolBuffer(this.config.getNamespace()));
        Future<SearchServicePb.ListDocumentsResponse.Builder> future = this.apiHelper.makeAsyncListDocumentsCall(params, this.config.getDeadline());
        return new FutureWrapper<SearchServicePb.ListDocumentsResponse.Builder, GetResponse<Document>>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new GetException(result);
            }

            @Override
            protected GetResponse<Document> wrap(SearchServicePb.ListDocumentsResponse.Builder key) throws Exception {
                SearchServicePb.ListDocumentsResponse response = key.build();
                SearchServicePb.RequestStatus status = response.getStatus();
                if (status.getCode() != SearchServicePb.SearchServiceError.ErrorCode.OK) {
                    throw new GetException(new OperationResult(status));
                }
                ArrayList<Document> results = new ArrayList<Document>();
                for (DocumentPb.Document document : response.getDocumentList()) {
                    results.add(Document.newBuilder(document).build());
                }
                return new GetResponse<Document>(results);
            }
        };
    }

    @Override
    public Document get(String documentId) {
        Preconditions.checkNotNull((Object)documentId, (Object)"documentId must not be null");
        GetResponse<Document> response = this.getRange(GetRequest.newBuilder().setStartId(documentId).setLimit(1));
        for (Document document : response) {
            if (!documentId.equals(document.getId())) continue;
            return document;
        }
        return null;
    }

    @Override
    public void deleteSchema() {
        FutureHelper.quietGet(this.deleteSchemaAsync());
    }

    @Override
    public void delete(String ... documentIds) {
        FutureHelper.quietGet(this.deleteAsync(documentIds));
    }

    @Override
    public void delete(Iterable<String> documentIds) {
        FutureHelper.quietGet(this.deleteAsync(documentIds));
    }

    @Override
    public PutResponse put(Document ... documents) {
        return FutureHelper.quietGet(this.putAsync(documents));
    }

    @Override
    public PutResponse put(Document.Builder ... builders) {
        return FutureHelper.quietGet(this.putAsync(builders));
    }

    @Override
    public PutResponse put(Iterable<Document> documents) {
        return FutureHelper.quietGet(this.putAsync(documents));
    }

    @Override
    public Results<ScoredDocument> search(String query) {
        return FutureHelper.quietGet(this.searchAsync(query));
    }

    @Override
    public Results<ScoredDocument> search(Query query) {
        return FutureHelper.quietGet(this.searchAsync(query));
    }

    @Override
    public GetResponse<Document> getRange(GetRequest request) {
        return FutureHelper.quietGet(this.getRangeAsync(request));
    }

    @Override
    public GetResponse<Document> getRange(GetRequest.Builder builder) {
        return this.getRange(builder.build());
    }
}

