/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.quota;

import com.google.appengine.api.quota.QuotaService;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.ApiStats;

class QuotaServiceImpl
implements QuotaService {
    private static final double MCYCLES_PER_SECOND = 1200.0;

    QuotaServiceImpl() {
    }

    private static ApiStats getStats() {
        ApiProxy.Environment env = ApiProxy.getCurrentEnvironment();
        if (env == null) {
            return null;
        }
        return ApiStats.get((ApiProxy.Environment)env);
    }

    @Override
    public boolean supports(QuotaService.DataType type) {
        return QuotaServiceImpl.getStats() != null;
    }

    @Override
    public long getApiTimeInMegaCycles() {
        ApiStats stats = QuotaServiceImpl.getStats();
        return stats == null ? 0L : stats.getApiTimeInMegaCycles();
    }

    @Override
    public long getCpuTimeInMegaCycles() {
        ApiStats stats = QuotaServiceImpl.getStats();
        return stats == null ? 0L : stats.getCpuTimeInMegaCycles();
    }

    @Override
    public long convertCpuSecondsToMegacycles(double cpuSeconds) {
        return (long)(cpuSeconds * 1200.0);
    }

    @Override
    public double convertMegacyclesToCpuSeconds(long megaCycles) {
        return (double)megaCycles / 1200.0;
    }
}

