/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseQueryResultsSource;
import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.IndexTranslator;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.common.collect.Lists;
import com.google.protobuf.MessageLite;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.checkerframework.checker.nullness.qual.Nullable;

class QueryResultsSourceV3
extends BaseQueryResultsSource<DatastoreV3Pb.QueryResult, DatastoreV3Pb.NextRequest, DatastoreV3Pb.QueryResult> {
    private final ApiProxy.ApiConfig apiConfig;

    QueryResultsSourceV3(DatastoreCallbacks callbacks, FetchOptions fetchOptions, Transaction txn, Query query, Future<DatastoreV3Pb.QueryResult> initialQueryResultFuture, ApiProxy.ApiConfig apiConfig) {
        super(callbacks, fetchOptions, txn, query, initialQueryResultFuture);
        this.apiConfig = apiConfig;
    }

    @Override
    public DatastoreV3Pb.NextRequest buildNextCallPrototype(DatastoreV3Pb.QueryResult initialResult) {
        DatastoreV3Pb.NextRequest req = new DatastoreV3Pb.NextRequest();
        req.setCursor(initialResult.getCursor());
        if (initialResult.hasCompiledCursor()) {
            req.setCompile(true);
        }
        return req;
    }

    @Override
    public Future<DatastoreV3Pb.QueryResult> makeNextCall(DatastoreV3Pb.NextRequest reqPrototype, BaseQueryResultsSource.WrappedQueryResult unused, @Nullable Integer fetchCount, Integer offsetOrNull) {
        DatastoreV3Pb.NextRequest req = (DatastoreV3Pb.NextRequest)reqPrototype.clone();
        if (fetchCount != null) {
            req.setCount(fetchCount.intValue());
        }
        if (offsetOrNull != null) {
            req.setOffset(offsetOrNull.intValue());
        }
        return DatastoreApiHelper.makeAsyncCall(this.apiConfig, DatastoreV3Pb.DatastoreService_3.Method.Next, (MessageLite)req, new DatastoreV3Pb.QueryResult());
    }

    @Override
    public BaseQueryResultsSource.WrappedQueryResult wrapResult(DatastoreV3Pb.QueryResult result) {
        return new WrappedQueryResultV3(result);
    }

    @Override
    public BaseQueryResultsSource.WrappedQueryResult wrapInitialResult(DatastoreV3Pb.QueryResult initialResult) {
        return new WrappedQueryResultV3(initialResult);
    }

    private static class WrappedQueryResultV3
    implements BaseQueryResultsSource.WrappedQueryResult {
        private final DatastoreV3Pb.QueryResult res;

        WrappedQueryResultV3(DatastoreV3Pb.QueryResult res) {
            this.res = res;
        }

        @Override
        public List<Entity> getEntities(Collection<Projection> projections) {
            ArrayList entities = Lists.newArrayListWithCapacity((int)this.res.resultSize());
            if (projections.isEmpty()) {
                for (OnestoreEntity.EntityProto entityProto : this.res.results()) {
                    entities.add(EntityTranslator.createFromPb(entityProto));
                }
            } else {
                for (OnestoreEntity.EntityProto entityProto : this.res.results()) {
                    entities.add(EntityTranslator.createFromPb(entityProto, projections));
                }
            }
            return entities;
        }

        @Override
        public List<Cursor> getResultCursors() {
            ArrayList cursors = Lists.newArrayListWithCapacity((int)this.res.resultSize());
            for (DatastoreV3Pb.CompiledCursor compiledCursor : this.res.resultCompiledCursors()) {
                cursors.add(new Cursor(compiledCursor.toByteString()));
            }
            cursors.addAll(Collections.nCopies(this.res.resultSize() - cursors.size(), null));
            return cursors;
        }

        @Override
        public int numSkippedResults() {
            return this.res.getSkippedResults();
        }

        @Override
        public Cursor getSkippedResultsCursor() {
            return this.res.hasSkippedResultsCompiledCursor() ? new Cursor(this.res.getSkippedResultsCompiledCursor().toByteString()) : null;
        }

        @Override
        public boolean hasMoreResults() {
            return this.res.isMoreResults();
        }

        @Override
        public Cursor getEndCursor() {
            return this.res.hasCompiledCursor() ? new Cursor(this.res.getCompiledCursor().toByteString()) : null;
        }

        @Override
        public List<Index> getIndexInfo(Collection<Index> monitoredIndexBuffer) {
            ArrayList indexList = Lists.newArrayListWithCapacity((int)this.res.indexSize());
            for (OnestoreEntity.CompositeIndex indexProtobuf : this.res.indexs()) {
                Index index = IndexTranslator.convertFromPb(indexProtobuf);
                indexList.add(index);
                if (!indexProtobuf.isOnlyUseIfRequired()) continue;
                monitoredIndexBuffer.add(index);
            }
            return indexList;
        }

        @Override
        public boolean madeProgress(BaseQueryResultsSource.WrappedQueryResult previousResult) {
            return true;
        }
    }
}

