/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.IndexComponent;
import com.google.common.collect.Lists;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

class OrderedIndexComponent
implements IndexComponent {
    private final List<OnestoreEntity.Index.Property> matcherProperties;

    public OrderedIndexComponent(List<OnestoreEntity.Index.Property> orderedGroup) {
        this.matcherProperties = orderedGroup;
    }

    @Override
    public boolean matches(List<OnestoreEntity.Index.Property> indexProperties) {
        ListIterator<OnestoreEntity.Index.Property> indexItr = indexProperties.listIterator(indexProperties.size());
        ListIterator<OnestoreEntity.Index.Property> matcherItr = this.matcherProperties.listIterator(this.matcherProperties.size());
        while (indexItr.hasPrevious() && matcherItr.hasPrevious()) {
            if (this.propertySatisfies(matcherItr.previous(), indexItr.previous())) continue;
            return false;
        }
        return !matcherItr.hasPrevious();
    }

    @Override
    public List<OnestoreEntity.Index.Property> preferredIndexProperties() {
        ArrayList indexProps = Lists.newArrayListWithExpectedSize((int)this.matcherProperties.size());
        for (OnestoreEntity.Index.Property prop : this.matcherProperties) {
            if (!prop.hasDirection()) {
                prop = (OnestoreEntity.Index.Property)prop.clone();
                prop.setDirection(OnestoreEntity.Index.Property.Direction.ASCENDING);
            }
            indexProps.add(prop);
        }
        return indexProps;
    }

    @Override
    public int size() {
        return this.matcherProperties.size();
    }

    public String toString() {
        return "OrderedIndexComponent: " + this.matcherProperties;
    }

    private boolean propertySatisfies(OnestoreEntity.Index.Property constraint, OnestoreEntity.Index.Property property) {
        return constraint.equals(property) || !constraint.hasDirection() && constraint.getName().equals(property.getName());
    }
}

