/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.compute.ComputeCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ExponentialBackOff;
import com.google.appengine.api.datastore.AutoValue_CloudDatastoreV1ClientImpl_DatastoreInstanceKey;
import com.google.appengine.api.datastore.CloudDatastoreV1Client;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DatastoreServiceGlobalConfig;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.AllocateIdsResponse;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RollbackResponse;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.datastore.v1.client.Datastore;
import com.google.datastore.v1.client.DatastoreException;
import com.google.datastore.v1.client.DatastoreFactory;
import com.google.datastore.v1.client.DatastoreOptions;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class CloudDatastoreV1ClientImpl
implements CloudDatastoreV1Client {
    private static final Logger logger = Logger.getLogger(CloudDatastoreV1ClientImpl.class.getName());
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private static final Map<DatastoreInstanceKey, Datastore> datastoreInstances = new HashMap<DatastoreInstanceKey, Datastore>();
    final Datastore datastore;
    private final int maxRetries;

    CloudDatastoreV1ClientImpl(Datastore datastore, int maxRetries) {
        this.datastore = (Datastore)Preconditions.checkNotNull((Object)datastore);
        this.maxRetries = maxRetries;
    }

    static synchronized CloudDatastoreV1ClientImpl create(DatastoreServiceConfig config) {
        DatastoreInstanceKey key = DatastoreInstanceKey.create(config);
        Datastore datastore = datastoreInstances.get(key);
        if (datastore == null) {
            DatastoreOptions options;
            Preconditions.checkState((!DatastoreServiceGlobalConfig.getConfig().useApiProxy() ? 1 : 0) != 0);
            String projectId = DatastoreApiHelper.toProjectId(DatastoreServiceGlobalConfig.getConfig().configuredAppId());
            try {
                options = CloudDatastoreV1ClientImpl.createDatastoreOptions(projectId, config, DatastoreServiceGlobalConfig.getConfig().httpConnectTimeoutMillis());
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException("Could not get Cloud Datastore options from environment.", e);
            }
            datastore = DatastoreFactory.get().create(options);
            datastoreInstances.put(key, datastore);
        }
        return new CloudDatastoreV1ClientImpl(datastore, DatastoreServiceGlobalConfig.getConfig().maxRetries());
    }

    @Override
    public Future<BeginTransactionResponse> beginTransaction(final BeginTransactionRequest req) {
        return this.makeCall(new Callable<BeginTransactionResponse>(){

            @Override
            public BeginTransactionResponse call() throws DatastoreException {
                return CloudDatastoreV1ClientImpl.this.datastore.beginTransaction(req);
            }
        });
    }

    @Override
    public Future<RollbackResponse> rollback(final RollbackRequest req) {
        return this.makeCall(new Callable<RollbackResponse>(){

            @Override
            public RollbackResponse call() throws DatastoreException {
                return CloudDatastoreV1ClientImpl.this.datastore.rollback(req);
            }
        });
    }

    @Override
    public Future<RunQueryResponse> runQuery(final RunQueryRequest req) {
        return this.makeCall(new Callable<RunQueryResponse>(){

            @Override
            public RunQueryResponse call() throws DatastoreException {
                return CloudDatastoreV1ClientImpl.this.datastore.runQuery(req);
            }
        });
    }

    @Override
    public Future<LookupResponse> lookup(final LookupRequest req) {
        return this.makeCall(new Callable<LookupResponse>(){

            @Override
            public LookupResponse call() throws DatastoreException {
                return CloudDatastoreV1ClientImpl.this.datastore.lookup(req);
            }
        });
    }

    @Override
    public Future<AllocateIdsResponse> allocateIds(final AllocateIdsRequest req) {
        return this.makeCall(new Callable<AllocateIdsResponse>(){

            @Override
            public AllocateIdsResponse call() throws DatastoreException {
                return CloudDatastoreV1ClientImpl.this.datastore.allocateIds(req);
            }
        });
    }

    private Future<CommitResponse> commit(final CommitRequest req) {
        return this.makeCall(new Callable<CommitResponse>(){

            @Override
            public CommitResponse call() throws DatastoreException {
                return CloudDatastoreV1ClientImpl.this.datastore.commit(req);
            }
        });
    }

    @Override
    public Future<CommitResponse> rawCommit(byte[] bytes) {
        try {
            return this.commit(CommitRequest.parseFrom((byte[])bytes));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(e);
        }
    }

    private <T extends Message> Future<T> makeCall(final Callable<T> oneAttempt) {
        final Exception stackTraceCapturer = DatastoreServiceGlobalConfig.getConfig().asyncStackTraceCaptureEnabled() ? new Exception() : null;
        return executor.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    return (Message)new RetryingCallable(oneAttempt, CloudDatastoreV1ClientImpl.this.maxRetries).call();
                }
                catch (DatastoreException e) {
                    String message = stackTraceCapturer != null ? String.format("%s%nstack trace when async call was initiated: <%n%s>", e.getMessage(), Throwables.getStackTraceAsString((Throwable)stackTraceCapturer)) : String.format("%s%n(stack trace capture for async call is disabled)", e.getMessage());
                    throw DatastoreApiHelper.createV1Exception(e.getCode(), message, e);
                }
            }
        });
    }

    private static DatastoreOptions createDatastoreOptions(String projectId, final DatastoreServiceConfig config, final int httpConnectTimeoutMillis) throws GeneralSecurityException, IOException {
        DatastoreOptions.Builder options = new DatastoreOptions.Builder();
        CloudDatastoreV1ClientImpl.setProjectEndpoint(projectId, options);
        options.credential(CloudDatastoreV1ClientImpl.getCredential());
        options.initializer(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                request.setConnectTimeout(httpConnectTimeoutMillis);
                if (config.getDeadline() != null) {
                    request.setReadTimeout((int)(config.getDeadline() * 1000.0));
                }
            }
        });
        return options.build();
    }

    private static Credential getCredential() throws GeneralSecurityException, IOException {
        if (DatastoreServiceGlobalConfig.getConfig().emulatorHost() != null) {
            logger.log(Level.INFO, "Emulator host was provided. Not using credentials.");
            return null;
        }
        String serviceAccount = DatastoreServiceGlobalConfig.getConfig().serviceAccount();
        if (serviceAccount != null) {
            String privateKeyFile = DatastoreServiceGlobalConfig.getConfig().privateKeyFile();
            if (privateKeyFile != null) {
                logger.log(Level.INFO, "Service account and private key file were provided. Using service account credential.");
                return CloudDatastoreV1ClientImpl.getServiceAccountCredentialBuilder(serviceAccount).setServiceAccountPrivateKeyFromP12File(new File(privateKeyFile)).build();
            }
            PrivateKey privateKey = DatastoreServiceGlobalConfig.getConfig().privateKey();
            if (privateKey != null) {
                logger.log(Level.INFO, "Service account and private key were provided. Using service account credential.");
                return CloudDatastoreV1ClientImpl.getServiceAccountCredentialBuilder(serviceAccount).setServiceAccountPrivateKey(privateKey).build();
            }
            throw new IllegalStateException("Service account was provided without private key or private key file.");
        }
        if (DatastoreServiceGlobalConfig.getConfig().useComputeEngineCredential()) {
            return new ComputeCredential((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)GsonFactory.getDefaultInstance());
        }
        if (DatastoreServiceGlobalConfig.getConfig().accessToken() != null) {
            GoogleCredential credential = CloudDatastoreV1ClientImpl.getCredentialBuilder().build().setAccessToken(DatastoreServiceGlobalConfig.getConfig().accessToken()).createScoped((Collection)DatastoreOptions.SCOPES);
            credential.refreshToken();
            return credential;
        }
        return GoogleCredential.getApplicationDefault().createScoped((Collection)DatastoreOptions.SCOPES);
    }

    private static void setProjectEndpoint(String projectId, DatastoreOptions.Builder options) {
        if (DatastoreServiceGlobalConfig.getConfig().hostOverride() != null) {
            options.projectEndpoint(String.format("%s/%s/projects/%s", DatastoreServiceGlobalConfig.getConfig().hostOverride(), "v1".toLowerCase(), projectId));
            return;
        }
        if (DatastoreServiceGlobalConfig.getConfig().emulatorHost() != null) {
            options.projectId(projectId);
            options.localHost(DatastoreServiceGlobalConfig.getConfig().emulatorHost());
            return;
        }
        options.projectId(projectId);
    }

    private static GoogleCredential.Builder getServiceAccountCredentialBuilder(String account) throws GeneralSecurityException, IOException {
        return CloudDatastoreV1ClientImpl.getCredentialBuilder().setServiceAccountId(account).setServiceAccountScopes((Collection)DatastoreOptions.SCOPES);
    }

    private static GoogleCredential.Builder getCredentialBuilder() throws GeneralSecurityException, IOException {
        return new GoogleCredential.Builder().setTransport((HttpTransport)GoogleNetHttpTransport.newTrustedTransport()).setJsonFactory((JsonFactory)GsonFactory.getDefaultInstance());
    }

    private static class RetryingCallable<T>
    implements Callable<T> {
        private final Callable<T> callable;
        private final int maxRetries;

        public RetryingCallable(Callable<T> callable, int maxRetries) {
            this.callable = callable;
            this.maxRetries = maxRetries;
        }

        @Override
        public T call() throws Exception {
            int remainingTries = this.maxRetries + 1;
            ExponentialBackOff backoff = new ExponentialBackOff();
            while (true) {
                --remainingTries;
                try {
                    return this.callable.call();
                }
                catch (Exception e) {
                    if (RetryingCallable.isRetryable(e) && remainingTries > 0) {
                        logger.log(Level.FINE, String.format("Caught retryable exception; %d tries remaining", remainingTries), e);
                        Thread.sleep(backoff.nextBackOffMillis());
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }

        private static boolean isRetryable(Exception e) {
            return e instanceof DatastoreException && e.getCause() instanceof ConnectException;
        }
    }

    @AutoValue
    static abstract class DatastoreInstanceKey {
        DatastoreInstanceKey() {
        }

        @Nullable
        abstract Double deadline();

        static DatastoreInstanceKey create(DatastoreServiceConfig config) {
            return new AutoValue_CloudDatastoreV1ClientImpl_DatastoreInstanceKey(config.getDeadline());
        }
    }
}

