/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.exception;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.SuppressedValidationFailures;
import com.google.cloud.datastore.logs.ProblemCode;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;

public class ValidationException
extends DatastoreException {
    private static final DatastoreV3Pb.Error.ErrorCode DEFAULT_V3_ERROR_CODE = DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST;
    public static final String DIFFERENT_APP_ID_MESSAGE = "mismatched app ids within request: ";
    public static final String DIFFERENT_DATABASE_MESSAGE = "mismatched databases within request: ";
    public static final String TRANSACTION_WITH_FAILOVER_MESSAGE = "read operations inside transactions can't allow failover";
    public static final String MISSING_APP_ID = "The app id is the empty string.";
    public static final String NEED_ANCESTOR_ERROR = "global queries do not support strong consistency";
    public static final String QUERIES_IN_TRANSACTION_NEED_ANCESTOR = "queries inside transactions must have ancestors";

    public ValidationException(String message) {
        super(message, DEFAULT_V3_ERROR_CODE, null);
    }

    public ValidationException(String message, Throwable cause) {
        super(message, DEFAULT_V3_ERROR_CODE, cause);
    }

    public ValidationException(String message, DatastoreV3Pb.Error.ErrorCode errorCode) {
        super(message, errorCode, null);
    }

    public ValidationException(String message, ProblemCode problemCode) {
        super(problemCode, message, DEFAULT_V3_ERROR_CODE);
    }

    public ValidationException(String message, ProblemCode problemCode, DatastoreV3Pb.Error.ErrorCode errorCode) {
        super(problemCode, message, errorCode);
    }

    public ValidationException(String message, ProblemCode problemCode, ValidationException cause) {
        super(problemCode, message, DEFAULT_V3_ERROR_CODE, cause);
    }

    @FormatMethod
    public static void validateAssertion(boolean assertion, String message, Object ... messageArgs) throws ValidationException {
        if (!assertion) {
            throw new ValidationException(String.format(message, messageArgs));
        }
    }

    @FormatMethod
    public static void validateAssertion(boolean assertion, ProblemCode problemCode, String message, Object ... messageArgs) throws ValidationException {
        if (!assertion) {
            throw new ValidationException(String.format(message, messageArgs), problemCode);
        }
    }

    @FormatMethod
    public static void validateAssertionIf(boolean assertion, ProblemCode problemCode, boolean validationEnabled, SuppressedValidationFailures suppressedFailures, String message, Object ... messageArgs) throws ValidationException {
        if (assertion) {
            return;
        }
        if (validationEnabled) {
            throw new ValidationException(String.format(message, messageArgs), problemCode);
        }
        suppressedFailures.add(problemCode);
    }

    @FormatMethod
    public static void validatePrecondition(boolean precondition, String message, Object ... messageArgs) throws ValidationException {
        if (!precondition) {
            throw new ValidationException(String.format(message, messageArgs), DatastoreV3Pb.Error.ErrorCode.FAILED_PRECONDITION);
        }
    }

    @FormatMethod
    public static void validatePrecondition(boolean precondition, ProblemCode problemCode, @FormatString String message, Object ... messageArgs) throws ValidationException {
        if (!precondition) {
            throw new ValidationException(String.format(message, messageArgs), problemCode, DatastoreV3Pb.Error.ErrorCode.FAILED_PRECONDITION);
        }
    }
}

