/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import com.google.appengine.tools.util.JarMaker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;

public class JarTool
extends JarMaker {
    private Deque<File> stack = new ArrayDeque<File>(1000);
    private int prefixLength;

    public JarTool(String baseName, File inputDirectory, File outputDirectory, int maximumSize, Set<String> excludes) {
        super(baseName, 4, outputDirectory, maximumSize, excludes, true);
        if (!inputDirectory.isDirectory()) {
            throw new IllegalArgumentException(inputDirectory.getPath() + " is not a directory.");
        }
        this.stack.push(inputDirectory);
        this.prefixLength = JarTool.getZipCompatiblePath(inputDirectory).length();
    }

    @Override
    protected JarMaker.JarEntryData getNextJarEntry() throws IOException {
        File nextFile;
        block0: while (true) {
            if ((nextFile = this.stack.pollFirst()) == null) {
                return null;
            }
            if (!nextFile.isDirectory()) break;
            File[] fileArray = JarTool.sortedListing(nextFile);
            int n = fileArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                File f = fileArray[n2];
                if (f.isDirectory() || this.shouldIncludeFile(f.getName())) {
                    this.stack.push(f);
                }
                ++n2;
            }
            break;
        }
        JarEntry jarEntry = new JarEntry(JarTool.getZipCompatiblePath(nextFile).substring(this.prefixLength));
        jarEntry.setTime(0L);
        FileInputStream inputStream = new FileInputStream(nextFile);
        return new JarMaker.JarEntryData(jarEntry, inputStream);
    }

    private static String getZipCompatiblePath(File f) {
        String path = f.getPath();
        path = path.replace("\\", "/");
        if (f.isDirectory() && !path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    @Override
    protected Manifest getManifest() {
        return null;
    }

    private static File[] sortedListing(File dir) {
        File[] contents = dir.listFiles();
        Comparator<File> comparator = new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                if (f1.isDirectory() && f2.isFile()) {
                    return -1;
                }
                if (f1.isFile() && f2.isDirectory()) {
                    return 1;
                }
                return f2.getName().compareTo(f1.getName());
            }
        };
        Arrays.sort(contents, comparator);
        return contents;
    }
}

