/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.tools.info.AppengineSdk;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;

public class MavenSdk
extends AppengineSdk {
    private final ListMultimap<String, File> profileToFiles;
    private final String resourceFile;
    private boolean includeTestingJarOnSharedPath = false;

    public MavenSdk(ListMultimap<String, File> profileToFiles) {
        this.profileToFiles = profileToFiles;
        this.resourceFile = this.getSingletonFile("Resources").toString();
    }

    @Override
    public void includeTestingJarOnSharedPath(boolean val) {
        this.includeTestingJarOnSharedPath = val;
    }

    @Override
    public File getToolsApiJarFile() {
        return this.getSingletonFile("ToolsApi");
    }

    @Override
    public List<File> getUserJspLibFiles() {
        return this.profileToFiles.get((Object)("UserJsp" + MavenSdk.getJettySuffix()));
    }

    @Override
    public List<File> getUserLibFiles() {
        return Collections.emptyList();
    }

    @Override
    public String getQuickStartClasspath() {
        List classes = Lists.transform((List)this.profileToFiles.get((Object)"QuickStart"), (Function)new Function<File, String>(){

            public String apply(File file) {
                return file.getAbsolutePath();
            }
        });
        return Joiner.on((String)System.getProperty("path.separator")).join((Iterable)classes);
    }

    @Override
    public List<File> getSharedJspLibFiles() {
        return this.profileToFiles.get((Object)("SharedJsp" + MavenSdk.getJettySuffix()));
    }

    @Override
    public List<URL> getImplLibs() {
        return this.toURLs(this.profileToFiles.get((Object)("Impl" + MavenSdk.getJettySuffix())));
    }

    @Override
    public List<File> getSharedLibFiles() {
        List sharedLibFiles = this.profileToFiles.get((Object)("Shared" + MavenSdk.getJettySuffix()));
        if (this.includeTestingJarOnSharedPath) {
            sharedLibFiles.addAll(this.profileToFiles.get((Object)"Testing"));
        }
        return sharedLibFiles;
    }

    @Override
    public List<URL> getDatanucleusLibs(String version) {
        if (!version.equals("v2")) {
            throw new IllegalArgumentException("Only Datanucleus v2 is supported. Invalid version: " + version);
        }
        return this.toURLs(this.profileToFiles.get((Object)"Datanucleus"));
    }

    @Override
    public String getWebDefaultXml() {
        return new File(this.resourceFile, "aaaaaaa/webdefault.xml").toString();
    }

    @Override
    public File getResourcesDirectory() {
        return new File(this.resourceFile, "docs");
    }

    @Override
    public File getAgentJarFile() {
        return this.getSingletonFile("Agent");
    }

    @Override
    public List<URL> getSharedLibs() {
        return this.toURLs(this.getSharedLibFiles());
    }

    @Override
    public List<URL> getWebApiToolsLibs() {
        return this.toURLs(this.profileToFiles.get((Object)"WebApiTool"));
    }

    @Override
    public File getLoggingProperties() {
        return Paths.get(this.resourceFile, "config", "sdk", "logging.properties").toFile();
    }

    private static String getJettySuffix() {
        return "Jetty9";
    }

    private File getSingletonFile(String profile) {
        try {
            return (File)this.profileToFiles.get((Object)profile).get(0);
        }
        catch (Exception ex) {
            throw new IllegalStateException("The profiles map must include a \"" + profile + "\" key corresponding a singleton file list.");
        }
    }
}

