/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.testing;

import com.google.appengine.api.NamespaceManager;
import com.google.apphosting.api.ApiProxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class MockEnvironment
implements ApiProxy.Environment {
    private static final AtomicLong VERSION_ID_COUNTER = new AtomicLong();
    private static final String REQUEST_NAMESPACE = "";
    public static final String APPS_NAMESPACE_KEY = NamespaceManager.class.getName() + ".appsNamespace";
    private final String appId;
    private final String moduleId;
    private final String versionId;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public static MockEnvironment fromTestClass(Class<?> testClass) {
        return new MockEnvironment(testClass.getName(), Long.toHexString(VERSION_ID_COUNTER.getAndIncrement()));
    }

    public MockEnvironment(String appId, String moduleId, String versionId) {
        this.appId = appId;
        this.moduleId = moduleId;
        this.versionId = versionId;
        this.attributes.put(APPS_NAMESPACE_KEY, REQUEST_NAMESPACE);
    }

    public MockEnvironment(String appId, String versionId) {
        this(appId, "default", versionId);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getEmail() {
        return null;
    }

    public boolean isLoggedIn() {
        return false;
    }

    public boolean isAdmin() {
        return false;
    }

    public String getAuthDomain() {
        return null;
    }

    @Deprecated
    public String getRequestNamespace() {
        throw new IllegalArgumentException("Failure by calling to deprecated getRequestNamespace(). Try calling NamespaceManager.getGoogleAppsNamespace().");
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public long getRemainingMillis() {
        return Long.MAX_VALUE;
    }
}

