/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.apphosting.api.AppEngineInternal;
import com.google.common.base.CharMatcher;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.LetterTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cjk.CJKTokenizer;
import org.apache.lucene.analysis.miscellaneous.EmptyTokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.AttributeSource;

@AppEngineInternal
final class PrefixFieldAnalyzerUtil {
    static final Logger LOG = Logger.getLogger(PrefixFieldAnalyzerUtil.class.getCanonicalName());

    PrefixFieldAnalyzerUtil() {
    }

    static String normalizePrefixField(String value) {
        String normalizedString = Normalizer.normalize(value, Normalizer.Form.NFKC);
        return CharMatcher.whitespace().trimAndCollapseFrom((CharSequence)normalizedString, ' ').toLowerCase();
    }

    static List<String> createUntokenizedPrefixes(String value) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            prefixes.add(value.substring(0, i + 1));
        }
        return prefixes;
    }

    static List<String> tokenizePrefixFieldQuery(String input) {
        ArrayList<String> output = new ArrayList<String>();
        input = PrefixFieldAnalyzerUtil.normalizePrefixField(input);
        TokenStream stream = PrefixFieldAnalyzerUtil.getTokenizedPrefixWordSeparator(new StringReader(input));
        TermAttribute tokenTerm = (TermAttribute)stream.addAttribute(TermAttribute.class);
        try {
            while (stream.incrementToken()) {
                output.add(tokenTerm.term());
            }
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
        return output;
    }

    static TokenStream getTokenizedPrefixTokenStreamForIndexing(Reader reader) {
        return new TokenizedPrefixFilter(PrefixFieldAnalyzerUtil.getTokenizedPrefixWordSeparator(reader));
    }

    private static TokenStream getTokenizedPrefixWordSeparator(Reader reader) {
        boolean isCjk;
        StringBuilder readerContents = new StringBuilder();
        try {
            isCjk = LuceneUtils.isProbablyCjk(reader, readerContents);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to read stream for tokenization.", e);
            return new EmptyTokenStream();
        }
        reader = new StringReader(PrefixFieldAnalyzerUtil.normalizePrefixField(readerContents.toString()));
        if (isCjk) {
            return new CJKTokenizer(reader);
        }
        return new PrefixWordSeparatorTokenizer(reader);
    }

    static final class TokenizedPrefixFilter
    extends TokenFilter {
        private final LinkedList<String> extraTokens = new LinkedList();
        private final TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private AttributeSource.State savedState;

        TokenizedPrefixFilter(TokenStream input) {
            super(input);
        }

        public boolean incrementToken() throws IOException {
            if (!this.extraTokens.isEmpty()) {
                this.restoreState(this.savedState);
                this.posIncAtt.setPositionIncrement(0);
                this.termAtt.setTermBuffer(this.extraTokens.remove());
                return true;
            }
            if (this.input.incrementToken()) {
                this.extraTokens.addAll(this.extractPrefixes(this.termAtt.term()));
                this.savedState = this.captureState();
                return true;
            }
            return false;
        }

        private List<String> extractPrefixes(String token) {
            ArrayList<String> prefixes = new ArrayList<String>();
            for (int i = 0; i < token.length() - 1; ++i) {
                prefixes.add(token.substring(0, i + 1));
            }
            return prefixes;
        }
    }

    static final class PrefixWordSeparatorTokenizer
    extends LetterTokenizer {
        PrefixWordSeparatorTokenizer(Reader in) {
            super(in);
        }

        protected char normalize(char c) {
            String cleaned = PrefixFieldAnalyzerUtil.normalizePrefixField(Character.toString(c));
            if (cleaned.isEmpty()) {
                return '\'';
            }
            return cleaned.charAt(0);
        }

        protected boolean isTokenChar(char c) {
            return !LuceneUtils.WORD_SEPARATORS.contains((Object)new Character(c));
        }
    }
}

