/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.GeometricField;
import com.google.appengine.api.search.dev.PrefixFieldAnalyzerUtil;
import com.google.apphosting.api.AppEngineInternal;
import com.google.apphosting.api.search.DocumentPb;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

@AppEngineInternal
public final class LuceneUtils {
    public static final String FIELDLESS_FIELD_NAME = "_GLOBAL";
    static final String DOCID_FIELD_NAME = "_DOCID";
    static final String ORIGINAL_DOC_FIELD_NAME = "_ORIGINALDOC";
    static final String ALLDOCS_FIELD_NAME = "_ALLDOC";
    static final String LOCALE_FIELD_NAME = "_LOCALE";
    static final String ALLDOCS_FIELD_VALUE = "X";
    static final String ALLDOCS_FIELD_MISSING_VALUE = "Y";
    static final String ORDER_ID_FIELD_NAME = "_rank";
    private static final Logger log = Logger.getLogger(LuceneUtils.class.getName());
    static final String CONVERTED_HTML_TYPE = "HTML2TEXT";
    public static final long MSEC_PER_DAY = 86400000L;
    static final String FACET_NAME_PREFIX = "facet_";
    static final String FIELD_NAME_PREFIX = "";
    static final ImmutableSet<Character> WORD_SEPARATORS = ImmutableSet.of((Object)Character.valueOf('!'), (Object)Character.valueOf('\"'), (Object)Character.valueOf('%'), (Object)Character.valueOf('('), (Object)Character.valueOf(')'), (Object)Character.valueOf('*'), (Object[])new Character[]{Character.valueOf(','), Character.valueOf('.'), Character.valueOf('/'), Character.valueOf(':'), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('@'), Character.valueOf('['), Character.valueOf('\\'), Character.valueOf(']'), Character.valueOf('^'), Character.valueOf('`'), Character.valueOf('{'), Character.valueOf('|'), Character.valueOf('}'), Character.valueOf('~'), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\f'), Character.valueOf('\r'), Character.valueOf(' '), Character.valueOf('&'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf(';')});
    private static final float CJK_CHARACTER_THRESHOLD = 0.2f;
    private static final ImmutableSet<Character.UnicodeBlock> CJK_BLOCKS = ImmutableSet.of((Object)Character.UnicodeBlock.BOPOMOFO, (Object)Character.UnicodeBlock.BOPOMOFO_EXTENDED, (Object)Character.UnicodeBlock.CJK_COMPATIBILITY, (Object)Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS, (Object)Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS, (Object)Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, (Object[])new Character.UnicodeBlock[]{Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B, Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS, Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS, Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO, Character.UnicodeBlock.HANGUL_JAMO, Character.UnicodeBlock.HANGUL_SYLLABLES, Character.UnicodeBlock.HIRAGANA, Character.UnicodeBlock.IDEOGRAPHIC_DESCRIPTION_CHARACTERS, Character.UnicodeBlock.KANBUN, Character.UnicodeBlock.KANGXI_RADICALS, Character.UnicodeBlock.KATAKANA, Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS, Character.UnicodeBlock.TAI_XUAN_JING_SYMBOLS, Character.UnicodeBlock.YI_RADICALS, Character.UnicodeBlock.YI_SYLLABLES, Character.UnicodeBlock.YIJING_HEXAGRAM_SYMBOLS});
    private static final ThreadLocal<TimeZone> UTC_TZ = new ThreadLocal<TimeZone>(){

        @Override
        protected TimeZone initialValue() {
            return TimeZone.getTimeZone("UTC");
        }
    };
    private static final ThreadLocal<DateFormat> ISO8601_SIMPLE = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return LuceneUtils.getDateFormat("yyyy-MM-dd");
        }
    };

    private static DateFormat getDateFormat(String formatString) {
        SimpleDateFormat format = new SimpleDateFormat(formatString, Locale.US);
        format.setTimeZone(UTC_TZ.get());
        return format;
    }

    public static String makeLuceneFieldName(DocumentPb.Field field) {
        return LuceneUtils.makeLuceneFieldName(field.getName(), field.getValue().getType());
    }

    public static String makeLuceneFieldName(String name, DocumentPb.FieldValue.ContentType type) {
        return FIELD_NAME_PREFIX + type + "@" + name;
    }

    static String makeLuceneFieldName(String name, DocumentPb.FacetValue.ContentType contentType) {
        return FACET_NAME_PREFIX + contentType + "@" + name;
    }

    public static String makeLuceneFieldNameWithExtractedText(String name, DocumentPb.FieldValue.ContentType type) {
        if (type == DocumentPb.FieldValue.ContentType.HTML) {
            return "HTML2TEXT@" + name;
        }
        return LuceneUtils.makeLuceneFieldName(name, type);
    }

    public static String makeLuceneFieldNameWithExtractedText(DocumentPb.Field field) {
        return LuceneUtils.makeLuceneFieldNameWithExtractedText(field.getName(), field.getValue().getType());
    }

    public static String extractTextFromHtml(String html) {
        Document doc = Jsoup.parse((String)html);
        Element body = doc.body();
        return body != null ? body.text() : FIELD_NAME_PREFIX;
    }

    public static double stringValueToDouble(String value) {
        try {
            return NumberFormat.getNumberInstance().parse(value).doubleValue();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static AbstractField convertFacetToLuceneField(DocumentPb.Facet facet) {
        DocumentPb.FacetValue facetValue = facet.getValue();
        String facetName = LuceneUtils.makeLuceneFieldName(facet.getName(), facet.getValue().getType());
        String value = facet.getValue().getStringValue();
        switch (facetValue.getType()) {
            case ATOM: {
                return new Field(facetName, value, Field.Store.YES, Field.Index.NOT_ANALYZED);
            }
            case NUMBER: {
                NumericField numericField = new NumericField(facetName, Field.Store.YES, true);
                numericField.setDoubleValue(LuceneUtils.stringValueToDouble(value));
                return numericField;
            }
        }
        throw new IllegalArgumentException("Facet type " + facetValue.getType() + " not handled");
    }

    static boolean isFacetField(Fieldable field) {
        return field.name().startsWith(FACET_NAME_PREFIX);
    }

    static DocumentPb.Facet convertLuceneFieldToFacet(Fieldable field) {
        if (!LuceneUtils.isFacetField(field)) {
            throw new IllegalArgumentException(String.format("Field %s is not a facet field", field.name()));
        }
        String typeName = field.name().substring(FACET_NAME_PREFIX.length());
        int atIndex = typeName.indexOf("@");
        return DocumentPb.Facet.newBuilder().setName(typeName.substring(atIndex + 1)).setValue(DocumentPb.FacetValue.newBuilder().setStringValue(field.stringValue()).setType(DocumentPb.FacetValue.ContentType.valueOf((String)typeName.substring(0, atIndex))).build()).build();
    }

    public static List<AbstractField> toLuceneFields(DocumentPb.Field field) {
        ArrayList<AbstractField> output = new ArrayList<AbstractField>();
        DocumentPb.FieldValue fieldValue = field.getValue();
        Field.Index globalIndexStrategy = Field.Index.ANALYZED;
        String fieldName = LuceneUtils.makeLuceneFieldName(field);
        String value = fieldValue.getStringValue();
        boolean makeGlobalField = true;
        switch (fieldValue.getType()) {
            case HTML: {
                output.add((AbstractField)new Field(fieldName, value, Field.Store.YES, Field.Index.NOT_ANALYZED));
                value = LuceneUtils.extractTextFromHtml(value);
                output.add((AbstractField)new Field(LuceneUtils.makeLuceneFieldNameWithExtractedText(field), value, Field.Store.YES, Field.Index.ANALYZED));
                break;
            }
            case TEXT: {
                output.add((AbstractField)new Field(fieldName, value, Field.Store.YES, globalIndexStrategy));
                break;
            }
            case ATOM: {
                value = value.toLowerCase();
                output.add((AbstractField)new Field(fieldName, value, Field.Store.YES, Field.Index.NOT_ANALYZED));
                globalIndexStrategy = Field.Index.NOT_ANALYZED;
                break;
            }
            case UNTOKENIZED_PREFIX: {
                globalIndexStrategy = Field.Index.NOT_ANALYZED;
                value = PrefixFieldAnalyzerUtil.normalizePrefixField(value);
                for (String prefix : PrefixFieldAnalyzerUtil.createUntokenizedPrefixes(value)) {
                    output.add((AbstractField)new Field(fieldName, prefix, Field.Store.NO, Field.Index.NOT_ANALYZED));
                }
                makeGlobalField = false;
                break;
            }
            case TOKENIZED_PREFIX: {
                TokenStream stream = PrefixFieldAnalyzerUtil.getTokenizedPrefixTokenStreamForIndexing(new StringReader(value));
                output.add((AbstractField)new Field(fieldName, stream));
                makeGlobalField = false;
                break;
            }
            case DATE: {
                NumericField dateField = new NumericField(fieldName, Field.Store.YES, true);
                try {
                    long days = LuceneUtils.dateStringToLong(value) / 86400000L;
                    value = Long.toString(days);
                    dateField.setLongValue(days);
                }
                catch (ParseException e) {
                    log.warning("Failed to parse date for " + fieldName + ": " + value);
                    dateField.setLongValue(0L);
                }
                output.add((AbstractField)dateField);
                globalIndexStrategy = Field.Index.NOT_ANALYZED;
                break;
            }
            case NUMBER: {
                NumericField numericField = new NumericField(fieldName, Field.Store.YES, true);
                numericField.setDoubleValue(LuceneUtils.stringValueToDouble(value));
                output.add((AbstractField)numericField);
                globalIndexStrategy = Field.Index.NOT_ANALYZED;
                break;
            }
            case GEO: {
                output.add(new GeometricField(fieldName, fieldValue.getGeo()));
                makeGlobalField = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Field type " + fieldValue.getType() + " not handled");
            }
        }
        if (makeGlobalField) {
            output.add((AbstractField)new Field(FIELDLESS_FIELD_NAME, value, Field.Store.NO, globalIndexStrategy));
        }
        return output;
    }

    public static org.apache.lucene.document.Document toLuceneDocument(String docId, DocumentPb.Document input) {
        org.apache.lucene.document.Document output = new org.apache.lucene.document.Document();
        if (input.hasLanguage()) {
            output.add((Fieldable)new Field(LOCALE_FIELD_NAME, input.getLanguage(), Field.Store.YES, Field.Index.NO));
        }
        for (DocumentPb.Facet facet : input.getFacetList()) {
            output.add((Fieldable)LuceneUtils.convertFacetToLuceneField(facet));
        }
        for (DocumentPb.Field field : input.getFieldList()) {
            for (AbstractField luceneField : LuceneUtils.toLuceneFields(field)) {
                output.add((Fieldable)luceneField);
            }
        }
        output.add((Fieldable)new Field(ALLDOCS_FIELD_NAME, ALLDOCS_FIELD_VALUE, Field.Store.NO, Field.Index.NOT_ANALYZED));
        output.add((Fieldable)new Field(DOCID_FIELD_NAME, docId, Field.Store.YES, Field.Index.NOT_ANALYZED));
        output.add((Fieldable)new Field(ORIGINAL_DOC_FIELD_NAME, input.toByteArray(), Field.Store.YES));
        output.add((Fieldable)new Field(ORDER_ID_FIELD_NAME, Integer.toString(input.getOrderId()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        return output;
    }

    static boolean isProbablyCjk(Reader reader, StringBuilder readerContents) throws IOException {
        int len;
        char[] buffer = new char[1024];
        long cjkChars = 0L;
        long totalChars = 0L;
        while ((len = reader.read(buffer)) >= 0) {
            totalChars += (long)len;
            readerContents.append(buffer, 0, len);
            for (int i = 0; i < len; ++i) {
                if (!CJK_BLOCKS.contains((Object)Character.UnicodeBlock.of(buffer[i]))) continue;
                ++cjkChars;
            }
        }
        return (float)cjkChars / (float)totalChars > 0.2f;
    }

    public static Long dateStringToLong(String value) throws ParseException {
        try {
            return Long.parseLong(value);
        }
        catch (IllegalArgumentException exception) {
            return ISO8601_SIMPLE.get().parse(value).getTime();
        }
    }

    public static boolean isDateString(String value) {
        try {
            ISO8601_SIMPLE.get().parse(value);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static double numericFieldToDouble(Fieldable f) {
        if (f instanceof NumericField) {
            NumericField numericField = (NumericField)f;
            return numericField.getNumericValue().doubleValue();
        }
        return Double.parseDouble(f.stringValue());
    }

    public static Object luceneFieldToValue(Fieldable f, DocumentPb.FieldValue.ContentType type) {
        switch (type) {
            case HTML: 
            case TEXT: 
            case ATOM: {
                return ((Field)f).stringValue();
            }
            case DATE: {
                long value = f instanceof NumericField ? ((NumericField)f).getNumericValue().longValue() : Long.parseLong(f.stringValue());
                return Long.toString(value);
            }
            case NUMBER: {
                if (f instanceof NumericField) {
                    NumericField numericField = (NumericField)f;
                    return Double.toString(numericField.getNumericValue().doubleValue());
                }
                return f.stringValue();
            }
            case GEO: {
                String[] parts = ((Field)f).stringValue().split(",", 2);
                return new double[]{Double.parseDouble(parts[0]), Double.parseDouble(parts[1])};
            }
        }
        throw new IllegalArgumentException("Failed to correctly handle type " + type);
    }

    static DocumentPb.Document.Builder toAppengineDocumentIdBuilder(org.apache.lucene.document.Document d) {
        String docId = ((Field)d.getFieldable(DOCID_FIELD_NAME)).stringValue();
        DocumentPb.Document.Builder docBuilder = DocumentPb.Document.newBuilder();
        docBuilder.setId(docId);
        return docBuilder;
    }

    public static DocumentPb.Document toAppengineDocumentId(org.apache.lucene.document.Document d) {
        return LuceneUtils.toAppengineDocumentIdBuilder(d).build();
    }

    static DocumentPb.Document.Builder toAppengineDocumentBuilder(org.apache.lucene.document.Document d) throws InvalidProtocolBufferException {
        Fieldable doc = d.getFieldable(ORIGINAL_DOC_FIELD_NAME);
        if (doc == null) {
            return null;
        }
        DocumentPb.Document.Builder docBuilder = DocumentPb.Document.newBuilder();
        docBuilder.mergeFrom(doc.getBinaryValue(), doc.getBinaryOffset(), doc.getBinaryLength());
        return docBuilder;
    }

    public static DocumentPb.Document toAppengineDocument(org.apache.lucene.document.Document d) throws InvalidProtocolBufferException {
        DocumentPb.Document.Builder docBuilder = LuceneUtils.toAppengineDocumentBuilder(d);
        if (docBuilder != null) {
            return docBuilder.build();
        }
        return null;
    }

    public static Query getMatchAnyDocumentQuery() {
        return new TermQuery(new Term(ALLDOCS_FIELD_NAME, ALLDOCS_FIELD_VALUE));
    }

    public static Query getMatchNoneQuery() {
        return new TermQuery(new Term(ALLDOCS_FIELD_NAME, ALLDOCS_FIELD_MISSING_VALUE));
    }

    public static Term newDeleteTerm(String docId) {
        return new Term(DOCID_FIELD_NAME, docId);
    }
}

